/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyNetwork;
import cytoscape.visual.AppearanceCalculator;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.LineType;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.calculators.EdgeArrowCalculator;
import cytoscape.visual.calculators.EdgeCalculator;
import cytoscape.visual.calculators.EdgeColorCalculator;
import cytoscape.visual.calculators.EdgeFontFaceCalculator;
import cytoscape.visual.calculators.EdgeFontSizeCalculator;
import cytoscape.visual.calculators.EdgeLabelCalculator;
import cytoscape.visual.calculators.EdgeLineTypeCalculator;
import cytoscape.visual.calculators.EdgeToolTipCalculator;
import giny.model.Edge;
import java.awt.Color;
import java.awt.Font;
import java.util.Properties;

public class EdgeAppearanceCalculator
extends AppearanceCalculator {
    EdgeAppearance defaultAppearance = new EdgeAppearance();
    private EdgeAppearance currentAppearance;
    private CyNetwork currentNetwork;
    private Edge currentEdge;

    public EdgeAppearanceCalculator() {
    }

    public EdgeAppearanceCalculator(EdgeAppearanceCalculator toCopy) {
        super(toCopy);
    }

    public EdgeAppearanceCalculator(String name, Properties eacProps, String baseKey, CalculatorCatalog catalog) {
        super(name, eacProps, baseKey, catalog, new EdgeAppearance());
        this.defaultAppearance = (EdgeAppearance)this.tmpDefaultAppearance;
    }

    public EdgeAppearance calculateEdgeAppearance(Edge edge, CyNetwork network) {
        EdgeAppearance appr = (EdgeAppearance)this.defaultAppearance.clone();
        this.calculateEdgeAppearance(appr, edge, network);
        this.currentAppearance = appr;
        this.currentEdge = edge;
        this.currentNetwork = network;
        return appr;
    }

    public void calculateEdgeAppearance(EdgeAppearance appr, Edge edge, CyNetwork network) {
        appr.copy(this.defaultAppearance);
        for (Calculator c : this.calcs) {
            c.apply(appr, edge, network);
        }
        appr.applyBypass(edge);
    }

    public EdgeAppearance getDefaultAppearance() {
        return this.defaultAppearance;
    }

    public void setDefaultAppearance(EdgeAppearance appr) {
        this.defaultAppearance = appr;
    }

    public String getDescription() {
        return this.getDescription("EdgeAppearanceCalculator", this.defaultAppearance);
    }

    public void applyProperties(String name, Properties eacProps, String baseKey, CalculatorCatalog catalog) {
        this.applyProperties(this.defaultAppearance, name, eacProps, baseKey, catalog);
    }

    public Properties getProperties(String baseKey) {
        return this.getProperties(this.defaultAppearance, baseKey);
    }

    protected void copyDefaultAppearance(AppearanceCalculator toCopy) {
        this.defaultAppearance = (EdgeAppearance)((EdgeAppearanceCalculator)toCopy).getDefaultAppearance().clone();
    }

    protected boolean isValidCalculator(Calculator c) {
        return c instanceof EdgeCalculator;
    }

    public EdgeColorCalculator getEdgeColorCalculator() {
        return (EdgeColorCalculator)this.getCalculator((byte)8);
    }

    public EdgeLineTypeCalculator getEdgeLineTypeCalculator() {
        return (EdgeLineTypeCalculator)this.getCalculator((byte)9);
    }

    public EdgeArrowCalculator getEdgeSourceArrowCalculator() {
        return (EdgeArrowCalculator)this.getCalculator((byte)10);
    }

    public EdgeArrowCalculator getEdgeTargetArrowCalculator() {
        return (EdgeArrowCalculator)this.getCalculator((byte)11);
    }

    public EdgeLabelCalculator getEdgeLabelCalculator() {
        return (EdgeLabelCalculator)this.getCalculator((byte)12);
    }

    public EdgeFontFaceCalculator getEdgeFontFaceCalculator() {
        return (EdgeFontFaceCalculator)this.getCalculator((byte)124);
    }

    public EdgeFontSizeCalculator getEdgeFontSizeCalculator() {
        return (EdgeFontSizeCalculator)this.getCalculator((byte)125);
    }

    public EdgeToolTipCalculator getEdgeToolTipCalculator() {
        return (EdgeToolTipCalculator)this.getCalculator((byte)15);
    }

    public void setDefaultEdgeColor(Color c) {
        this.defaultAppearance.setColor(c);
    }

    public void setDefaultEdgeLineType(LineType lt) {
        this.defaultAppearance.setLineType(lt);
    }

    public void setDefaultEdgeSourceArrow(Arrow a) {
        this.defaultAppearance.setSourceArrow(a);
    }

    public void setDefaultEdgeTargetArrow(Arrow a) {
        this.defaultAppearance.setTargetArrow(a);
    }

    public void setDefaultEdgeLabel(String s) {
        this.defaultAppearance.setLabel(s);
    }

    public void setDefaultEdgeFont(Font f) {
        this.defaultAppearance.setFont(f);
    }

    public void setDefaultEdgeFontFace(Font f) {
        this.defaultAppearance.setFont(f);
    }

    public void setDefaultEdgeFontSize(float f) {
        this.defaultAppearance.setFontSize(f);
    }

    public void setDefaultEdgeToolTip(String s) {
        this.defaultAppearance.setToolTip(s);
    }

    public Color getDefaultEdgeColor() {
        return this.defaultAppearance.getColor();
    }

    public LineType getDefaultEdgeLineType() {
        return this.defaultAppearance.getLineType();
    }

    public Arrow getDefaultEdgeSourceArrow() {
        return this.defaultAppearance.getSourceArrow();
    }

    public Arrow getDefaultEdgeTargetArrow() {
        return this.defaultAppearance.getTargetArrow();
    }

    public String getDefaultEdgeLabel() {
        return this.defaultAppearance.getLabel();
    }

    public Font getDefaultEdgeFont() {
        return this.defaultAppearance.getFont();
    }

    public Font getDefaultEdgeFontFace() {
        return this.defaultAppearance.getFont();
    }

    public float getDefaultEdgeFontSize() {
        return this.defaultAppearance.getFontSize();
    }

    public String getDefaultEdgeToolTip() {
        return this.defaultAppearance.getToolTip();
    }

    public Color calculateEdgeColor(Edge edge, CyNetwork network) {
        this.doCalc(edge, network);
        return this.currentAppearance.getColor();
    }

    public LineType calculateEdgeLineType(Edge edge, CyNetwork network) {
        this.doCalc(edge, network);
        return this.currentAppearance.getLineType();
    }

    public Arrow calculateEdgeSourceArrow(Edge edge, CyNetwork network) {
        this.doCalc(edge, network);
        return this.currentAppearance.getSourceArrow();
    }

    public Arrow calculateEdgeTargetArrow(Edge edge, CyNetwork network) {
        this.doCalc(edge, network);
        return this.currentAppearance.getTargetArrow();
    }

    public String calculateEdgeLabel(Edge edge, CyNetwork network) {
        this.doCalc(edge, network);
        return this.currentAppearance.getLabel();
    }

    public Font calculateEdgeFont(Edge edge, CyNetwork network) {
        this.doCalc(edge, network);
        return this.currentAppearance.getFont();
    }

    public String calculateEdgeToolTip(Edge edge, CyNetwork network) {
        this.doCalc(edge, network);
        return this.currentAppearance.getToolTip();
    }

    public void setEdgeColorCalculator(EdgeColorCalculator c) {
        this.setCalculator(c);
    }

    public void setEdgeLineTypeCalculator(EdgeLineTypeCalculator c) {
        this.setCalculator(c);
    }

    public void setEdgeSourceArrowCalculator(EdgeArrowCalculator c) {
        c.set((byte)10, "edgeSourceArrowCalculator", "Edge Source Arrow");
        this.setCalculator(c);
    }

    public void setEdgeTargetArrowCalculator(EdgeArrowCalculator c) {
        c.set((byte)11, "edgeSourceTargetCalculator", "Edge Target Arrow");
        this.setCalculator(c);
    }

    public void setEdgeLabelCalculator(EdgeLabelCalculator c) {
        this.setCalculator(c);
    }

    public void setEdgeFontFaceCalculator(EdgeFontFaceCalculator c) {
        this.setCalculator(c);
    }

    public void setEdgeFontSizeCalculator(EdgeFontSizeCalculator c) {
        this.setCalculator(c);
    }

    public void setEdgeToolTipCalculator(EdgeToolTipCalculator c) {
        this.setCalculator(c);
    }

    private void doCalc(Edge edge, CyNetwork network) {
        if (edge != this.currentEdge && network != this.currentNetwork) {
            this.calculateEdgeAppearance(edge, network);
        }
    }
}

