/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view.cytopanels;

import cytoscape.view.cytopanels.CytoPanelContainer;
import cytoscape.view.cytopanels.CytoPanelImp;
import cytoscape.view.cytopanels.CytoPanelState;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

public class BiModalJSplitPane
extends JSplitPane
implements CytoPanelContainer {
    private JFrame frame;
    public static final int MODE_SHOW_SPLIT = 1;
    public static final int MODE_HIDE_SPLIT = 2;
    public static final String MODE_PROPERTY = "MODE_PROPERTY";
    private int currentMode;
    private int defaultDividerSize;
    private int dividerLocation;

    public BiModalJSplitPane(JFrame f, int orientation, int initialMode, Component leftComponent, Component rightComponent) {
        super(orientation, leftComponent, rightComponent);
        this.currentMode = initialMode;
        this.frame = f;
        this.addComponentListener();
        this.setBorder(null);
        this.setOneTouchExpandable(false);
        this.defaultDividerSize = this.getDividerSize();
        if (initialMode == 2) {
            this.setDividerSize(0);
        }
    }

    public void insertCytoPanel(CytoPanelImp cytoPanel, int compassDirection) {
        boolean success = false;
        switch (compassDirection) {
            case 1: {
                this.setTopComponent(cytoPanel);
                success = true;
                break;
            }
            case 5: {
                this.setBottomComponent(cytoPanel);
                success = true;
                break;
            }
            case 3: {
                this.setRightComponent(cytoPanel);
                success = true;
                break;
            }
            case 7: {
                this.setLeftComponent(cytoPanel);
                success = true;
                break;
            }
            case 6: {
                this.setBottomComponent(cytoPanel);
                success = true;
            }
        }
        if (!success) {
            throw new IllegalArgumentException("Illegal Argument:  " + compassDirection + ".  Must be one of:  SwingConstants.{NORTH,SOUTH,EAST,WEST.");
        }
        this.setDividerSize(this.defaultDividerSize);
        if (this.dividerLocation != -1) {
            this.setDividerLocation(this.dividerLocation);
        }
    }

    public Point getLocationOnScreen() {
        return this.frame.getLocationOnScreen();
    }

    public Rectangle getBounds() {
        return this.frame.getBounds();
    }

    public void setMode(CytoPanelState cytoPanelState, int newMode) {
        if (newMode != 1 && newMode != 2) {
            throw new IllegalArgumentException("Illegal Argument:  " + newMode + ".  Must be one of:  MODE_SHOW_SPLIT or " + " MODE_HIDE_SPLIT.");
        }
        int oldMode = this.currentMode;
        if (newMode != this.currentMode) {
            if (newMode == 2) {
                this.hideSplit();
            } else if (newMode == 1) {
                this.showSplit();
            }
            this.currentMode = newMode;
            this.firePropertyChange(MODE_PROPERTY, oldMode, newMode);
        }
        if (cytoPanelState == CytoPanelState.FLOAT) {
            this.setDividerSize(0);
            this.dividerLocation = this.getDividerLocation();
        }
    }

    public int getMode() {
        return this.currentMode;
    }

    private void showSplit() {
        this.setDividerSize(this.defaultDividerSize);
        if (this.dividerLocation != -1) {
            this.setDividerLocation(this.dividerLocation);
        }
        this.resetToPreferredSizes();
        this.validateParent();
    }

    private void hideSplit() {
        this.setDividerSize(0);
        this.dividerLocation = this.getDividerLocation();
        this.resetToPreferredSizes();
        this.validateParent();
    }

    private void validateParent() {
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    private void addComponentListener() {
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                BiModalJSplitPane.this.dividerLocation = -1;
            }
        });
    }
}

