/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.MetadataEntries;
import cytoscape.generated2.Date;
import cytoscape.generated2.Description;
import cytoscape.generated2.Format;
import cytoscape.generated2.Identifier;
import cytoscape.generated2.ObjectFactory;
import cytoscape.generated2.RdfDescription;
import cytoscape.generated2.RdfRDF;
import cytoscape.generated2.Source;
import cytoscape.generated2.Title;
import cytoscape.generated2.Type;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataParser {
    public static final String DEFAULT_NETWORK_METADATA_LABEL = "Network Metadata";
    private static final String DEF_URI = "http://www.cytoscape.org/";
    private static final String DEF_TYPE = "Protein-Protein Interaction";
    private static final String DEF_FORMAT = "Cytoscape-XGMML";
    private String metadataLabel;
    private CyNetwork network;
    private RdfRDF metadata;
    private CyAttributes networkAttributes;
    private Map rdfAsMap;

    public MetadataParser(CyNetwork network) {
        this(network, DEFAULT_NETWORK_METADATA_LABEL);
    }

    public MetadataParser(CyNetwork network, String metadataLabel) {
        this.metadataLabel = metadataLabel;
        this.network = network;
        this.networkAttributes = Cytoscape.getNetworkAttributes();
        this.rdfAsMap = this.networkAttributes.getMapAttribute(network.getIdentifier(), metadataLabel);
    }

    public Map<String, String> makeNewMetadataMap() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String defSource = CytoscapeInit.getProperties().getProperty("defaultMetadata.source");
        String defType = CytoscapeInit.getProperties().getProperty("defaultMetadata.type");
        String defFormat = CytoscapeInit.getProperties().getProperty("defaultMetadata.format");
        MetadataEntries[] entries = MetadataEntries.values();
        block7: for (int i = 0; i < entries.length; ++i) {
            switch (entries[i]) {
                case DATE: {
                    java.util.Date now = new java.util.Date();
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dataMap.put(entries[i].toString(), df.format(now));
                    continue block7;
                }
                case TITLE: {
                    dataMap.put(entries[i].toString(), this.network.getTitle());
                    continue block7;
                }
                case SOURCE: {
                    if (defSource == null) {
                        dataMap.put(entries[i].toString(), DEF_URI);
                        continue block7;
                    }
                    dataMap.put(entries[i].toString(), defSource);
                    continue block7;
                }
                case TYPE: {
                    if (defType == null) {
                        dataMap.put(entries[i].toString(), DEF_TYPE);
                        continue block7;
                    }
                    dataMap.put(entries[i].toString(), defType);
                    continue block7;
                }
                case FORMAT: {
                    if (defFormat == null) {
                        dataMap.put(entries[i].toString(), DEF_FORMAT);
                        continue block7;
                    }
                    dataMap.put(entries[i].toString(), defFormat);
                    continue block7;
                }
                default: {
                    dataMap.put(entries[i].toString(), "N/A");
                }
            }
        }
        return dataMap;
    }

    public RdfRDF getMetadata() throws JAXBException {
        ObjectFactory objFactory = new ObjectFactory();
        this.metadata = objFactory.createRdfRDF();
        RdfDescription dc = objFactory.createRdfDescription();
        dc.setAbout(DEF_URI);
        if (this.rdfAsMap == null || this.rdfAsMap.keySet().size() == 0) {
            this.rdfAsMap = this.makeNewMetadataMap();
        }
        Set labels = this.rdfAsMap.keySet();
        Object value = null;
        String key2 = null;
        for (String key2 : labels) {
            value = this.rdfAsMap.get(key2);
            dc.getDcmes().add(this.getJAXBElement(key2.trim(), value));
        }
        this.metadata.getDescription().add(dc);
        this.networkAttributes.setMapAttribute(this.network.getIdentifier(), this.metadataLabel, this.rdfAsMap);
        return this.metadata;
    }

    public Map getMetadataMap() {
        if (this.rdfAsMap == null || this.rdfAsMap.keySet().size() == 0) {
            this.rdfAsMap = this.makeNewMetadataMap();
        }
        return this.rdfAsMap;
    }

    private JAXBElement getJAXBElement(String label, Object value) throws JAXBException {
        ObjectFactory objF = new ObjectFactory();
        MetadataEntries entry = MetadataEntries.valueOf(label.toUpperCase());
        if (entry == null) {
            return null;
        }
        switch (entry) {
            case DATE: {
                Date dt = objF.createDate();
                dt.setContent(value.toString());
                JAXBElement<Date> dtElement = objF.createDate(dt);
                return dtElement;
            }
            case TITLE: {
                Title tl = objF.createTitle();
                tl.setContent(value.toString());
                JAXBElement<Title> tlElement = objF.createTitle(tl);
                return tlElement;
            }
            case IDENTIFIER: {
                Identifier id = objF.createIdentifier();
                id.setContent(value.toString());
                JAXBElement<Identifier> idElement = objF.createIdentifier(id);
                return idElement;
            }
            case DESCRIPTION: {
                Description dsc = objF.createDescription();
                dsc.setContent(value.toString());
                JAXBElement<Description> dscElement = objF.createDescription(dsc);
                return dscElement;
            }
            case SOURCE: {
                Source src = objF.createSource();
                src.setContent(value.toString());
                JAXBElement<Source> srcElement = objF.createSource(src);
                return srcElement;
            }
            case TYPE: {
                Type type = objF.createType();
                type.setContent(value.toString());
                JAXBElement<Type> typeElement = objF.createType(type);
                return typeElement;
            }
            case FORMAT: {
                Format fmt = objF.createFormat();
                fmt.setContent(value.toString());
                JAXBElement<Format> fmtElement = objF.createFormat(fmt);
                return fmtElement;
            }
        }
        return null;
    }

    public void setMetadata(MetadataEntries entryName, String value) {
        Map<String, String> metadata = this.networkAttributes.getMapAttribute(this.network.getIdentifier(), this.metadataLabel);
        if (metadata == null) {
            metadata = this.makeNewMetadataMap();
        }
        metadata.put(entryName.toString(), value);
        this.networkAttributes.setMapAttribute(this.network.getIdentifier(), this.metadataLabel, metadata);
        this.rdfAsMap = metadata;
    }

    public void setMetadata(RdfRDF newMetadata) {
        RdfDescription dc = newMetadata.getDescription().get(0);
        for (JAXBElement<?> entry : dc.getDcmes()) {
            MetadataEntries type = MetadataEntries.valueOf(entry.getName().getLocalPart().toUpperCase());
            switch (type) {
                case DATE: {
                    this.setMetadata(type, ((Date)entry.getValue()).getContent());
                    break;
                }
                case TITLE: {
                    this.setMetadata(type, ((Title)entry.getValue()).getContent());
                    break;
                }
                case IDENTIFIER: {
                    this.setMetadata(type, ((Identifier)entry.getValue()).getContent());
                    break;
                }
                case DESCRIPTION: {
                    this.setMetadata(type, ((Description)entry.getValue()).getContent());
                    break;
                }
                case SOURCE: {
                    this.setMetadata(type, ((Source)entry.getValue()).getContent());
                    break;
                }
                case TYPE: {
                    this.setMetadata(type, ((Type)entry.getValue()).getContent());
                    break;
                }
                case FORMAT: {
                    this.setMetadata(type, ((Format)entry.getValue()).getContent());
                    break;
                }
            }
        }
    }
}

