/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.data.readers.KeyValue;
import cytoscape.util.FileUtil;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.text.ParseException;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

public class GMLParser {
    static int QUOTE_CHAR = 34;
    static String QUOTE_STRING = "\"";
    static Pattern keyPattern = Pattern.compile("\\w+");
    static Pattern integerPattern = Pattern.compile("(\\+|\\-){0,1}\\d+");
    static Pattern realPattern = Pattern.compile("(\\+|\\-){0,1}\\d+\\.\\d+((E|e)(\\+|\\-){0,1}\\d+){0,1}");
    static String LIST_OPEN = "[";
    static String LIST_CLOSE = "]";
    StreamTokenizer tokenizer;

    public GMLParser(StreamTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public GMLParser(String file) throws IOException, Exception {
        this.tokenizer = new StreamTokenizer(new FilterNewlineReader(new InputStreamReader(FileUtil.getInputStream(file))));
        this.tokenizer.resetSyntax();
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(34);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.wordChars(32, 33);
        this.tokenizer.wordChars(36, 126);
        this.tokenizer.wordChars(160, 255);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.nextToken();
    }

    public static void main(String[] args) {
        if (!integerPattern.matcher("9").matches()) {
            System.out.println("integer failed");
        }
        if (!integerPattern.matcher("+11").matches()) {
            System.out.println("integer failed");
        }
        if (!realPattern.matcher("11.9e-07").matches()) {
            System.out.println("real failed");
        }
        try {
            GMLParser parser = new GMLParser("test.gml");
            Vector vector = parser.parseList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printList(List list, Writer writer) throws IOException {
        GMLParser.printList(list, "", writer);
    }

    protected static void printList(List list, String indent, Writer writer) throws IOException {
        for (KeyValue keyVal : list) {
            if (keyVal.value instanceof List) {
                writer.write(indent + keyVal.key + "\t");
                writer.write(LIST_OPEN + "\n");
                GMLParser.printList((List)keyVal.value, indent + "\t", writer);
                writer.write(indent + LIST_CLOSE + "\n");
                continue;
            }
            if (keyVal.value instanceof String) {
                writer.write(indent + keyVal.key + "\t");
                writer.write(QUOTE_STRING + keyVal.value + QUOTE_STRING + "\n");
                continue;
            }
            if (keyVal.value instanceof Double) {
                Double value = (Double)keyVal.value;
                if (value.isNaN() || value.isInfinite()) continue;
                writer.write(indent + keyVal.key + "\t");
                writer.write(keyVal.value + "\n");
                continue;
            }
            if (!(keyVal.value instanceof Integer)) continue;
            writer.write(indent + keyVal.key + "\t");
            writer.write(keyVal.value + "\n");
        }
    }

    public Vector parseList() throws IOException, ParseException {
        Vector<KeyValue> result = new Vector<KeyValue>();
        while (this.isKey()) {
            String key = this.parseKey();
            if (key == null) {
                throw new ParseException("Bad key", this.tokenizer.lineno());
            }
            this.tokenizer.nextToken();
            Object value = this.parseValue();
            if (value == null) {
                throw new ParseException("Bad value associated with key " + key, this.tokenizer.lineno());
            }
            result.add(new KeyValue(key, value));
            this.tokenizer.nextToken();
        }
        return result;
    }

    private boolean isKey() {
        if (this.tokenizer.ttype != -3) {
            return false;
        }
        return keyPattern.matcher(this.tokenizer.sval).matches();
    }

    private boolean isInteger() {
        return integerPattern.matcher(this.tokenizer.sval).matches();
    }

    private boolean isReal() {
        return realPattern.matcher(this.tokenizer.sval).matches();
    }

    private boolean isString() {
        return this.tokenizer.ttype == QUOTE_CHAR;
    }

    private boolean isList() {
        return this.tokenizer.sval.equals(LIST_OPEN);
    }

    private String parseKey() {
        if (this.isKey()) {
            return this.tokenizer.sval;
        }
        return null;
    }

    private Object parseValue() throws IOException, ParseException {
        Object result = null;
        if (this.tokenizer.ttype == 10) {
            return result;
        }
        if (this.isString()) {
            return this.tokenizer.sval;
        }
        if (this.isInteger()) {
            return new Integer(this.tokenizer.sval);
        }
        if (this.isReal()) {
            return new Double(this.tokenizer.sval);
        }
        if (this.isList()) {
            this.tokenizer.nextToken();
            Vector list = this.parseList();
            if (!this.tokenizer.sval.equals(LIST_CLOSE)) {
                throw new ParseException("Unterminated list", this.tokenizer.lineno());
            }
            return list;
        }
        return result;
    }

    private class FilterNewlineReader
    extends FilterReader {
        public FilterNewlineReader(Reader r) {
            super(r);
        }

        public int read() throws IOException {
            int c = super.read();
            if (c == 10 || c == 13) {
                return 32;
            }
            return c;
        }
    }
}

