/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.AllTests;
import cytoscape.data.annotation.OntologyTerm;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class OntologyTermTest
extends TestCase {
    public OntologyTermTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() throws Exception {
        AllTests.standardOut("testCtor");
        String name = "Carbohydrate Metabolism";
        int id = 80001;
        OntologyTerm term = new OntologyTerm(name, id);
        OntologyTermTest.assertTrue((boolean)term.getName().equals(name));
        OntologyTermTest.assertTrue((term.getId() == id ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.numberOfParents() == 0 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.numberOfContainers() == 0 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.numberOfParentsAndContainers() == 0 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.getParents().length == 0 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.getContainers().length == 0 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.getParentsAndContainers().length == 0 ? 1 : 0) != 0);
    }

    public void testAddParentsAndContainers() throws Exception {
        AllTests.standardOut("testAddParentsAndContainers");
        String name = "Carbohydrate Metabolism";
        int id = 80001;
        OntologyTerm term = new OntologyTerm(name, id);
        int[] parents = new int[]{123, 456};
        for (int i = 0; i < parents.length; ++i) {
            term.addParent(parents[i]);
        }
        int[] containers = new int[]{1, 2, 3, 4};
        for (int i = 0; i < containers.length; ++i) {
            term.addContainer(containers[i]);
        }
        OntologyTermTest.assertTrue((boolean)term.getName().equals(name));
        OntologyTermTest.assertTrue((term.getId() == id ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.numberOfParents() == 2 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.numberOfContainers() == 4 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.numberOfParentsAndContainers() == 6 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.getParents().length == 2 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.getContainers().length == 4 ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((term.getParentsAndContainers().length == 6 ? 1 : 0) != 0);
        int[] retrievedParents = term.getParents();
        OntologyTermTest.assertTrue((retrievedParents[0] == parents[0] ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((retrievedParents[1] == parents[1] ? 1 : 0) != 0);
        int[] retrievedContainers = term.getContainers();
        OntologyTermTest.assertTrue((retrievedContainers[0] == containers[0] ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((retrievedContainers[1] == containers[1] ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((retrievedContainers[2] == containers[2] ? 1 : 0) != 0);
        OntologyTermTest.assertTrue((retrievedContainers[3] == containers[3] ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(OntologyTermTest.class));
    }
}

