/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import ViolinStrings.Strings;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.Semantics;
import cytoscape.view.CyNetworkView;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;

public class CyNetworkUtilities {
    public static boolean saveSelectedNodeNames(CyNetworkView networkView, CyNetwork network, String filename) {
        if (networkView == null || network == null || filename == null) {
            return false;
        }
        Set selectedNodes = network.getSelectedNodes();
        if (selectedNodes == null || selectedNodes.size() == 0) {
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "No selected nodes.", "Message", 1);
            return false;
        }
        String lineSep = System.getProperty("line.separator");
        try {
            File file = new File(filename);
            FileWriter fout = new FileWriter(file);
            for (CyNode node : selectedNodes) {
                String nodeUID = node.getIdentifier();
                fout.write(nodeUID + lineSep);
            }
            fout.close();
            return true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Error Writing to \"" + filename + "\"", 0);
            return false;
        }
    }

    public static boolean saveVisibleNodeNames(CyNetwork network, String filename) {
        if (network == null || filename == null) {
            return false;
        }
        String callerID = "CyNetworkUtilities.saveVisibleNodeNames";
        String lineSep = System.getProperty("line.separator");
        try {
            File file = new File(filename);
            FileWriter fout = new FileWriter(file);
            Iterator i = network.nodesIterator();
            while (i.hasNext()) {
                CyNode node = (CyNode)i.next();
                fout.write(node.getIdentifier() + lineSep);
            }
            fout.close();
            return true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Error Writing to \"" + filename + "\"", 0);
            return false;
        }
    }

    public static boolean selectNodesStartingWith(CyNetwork network, String key, CyNetworkView networkView) {
        if (network == null || key == null || networkView == null) {
            return false;
        }
        key = key.toLowerCase();
        boolean found = false;
        String callerID = "CyNetworkUtilities.selectNodesStartingWith";
        int nodeFound = 0;
        Vector<CyNode> matchedNodes = new Vector<CyNode>();
        Iterator i = network.nodesIterator();
        while (i.hasNext()) {
            CyNode node = (CyNode)i.next();
            String nodeUID = node.getIdentifier();
            boolean matched = false;
            if (nodeUID != null && Strings.isLike((String)nodeUID, (String)key, (int)0, (boolean)true)) {
                matched = true;
                found = true;
                matchedNodes.add(node);
            } else {
                List synonyms = Semantics.getAllSynonyms(nodeUID, network);
                for (String synonym : synonyms) {
                    if (!Strings.isLike((String)synonym, (String)key, (int)0, (boolean)true)) continue;
                    matched = true;
                    found = true;
                    matchedNodes.add(node);
                    break;
                }
            }
            if (!matched) continue;
            ++nodeFound;
        }
        if (nodeFound == 0) {
            JOptionPane.showMessageDialog(null, "No match for the string \"" + key + "\"", "Error: Node Not Found", 0);
        }
        if (nodeFound > 0) {
            network.setSelectedNodeState(matchedNodes, true);
        }
        return found;
    }
}

