/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.writers.XGMMLWriter;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.view.CyNetworkView;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;

class ExportAsXGMMLTask
implements Task {
    private String fileName;
    private CyNetwork network;
    private CyNetworkView view;
    private TaskMonitor taskMonitor;

    public ExportAsXGMMLTask(String fileName, CyNetwork network, CyNetworkView view) {
        this.fileName = fileName;
        this.network = network;
        this.view = view;
    }

    public void run() {
        this.taskMonitor.setStatus("Exporting Network and Attributes...");
        this.taskMonitor.setPercentCompleted(-1);
        int numNodes = this.network.getNodeCount();
        if (numNodes == 0) {
            throw new IllegalArgumentException("Network is empty.");
        }
        try {
            this.saveGraph();
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "Cannot export graph as XGMML.");
        }
        this.taskMonitor.setPercentCompleted(100);
        this.taskMonitor.setStatus("Network and attributes are successfully saved to:  " + this.fileName);
        System.out.println("Network and attributes are exported as an XGMML file: " + this.fileName);
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Exporting Network and Attributes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGraph() throws IOException, JAXBException, URISyntaxException, XMLStreamException, FactoryConfigurationError {
        FileWriter fileWriter = new FileWriter(this.fileName);
        XGMMLWriter writer = new XGMMLWriter(this.network, this.view);
        try {
            writer.write(fileWriter);
        }
        finally {
            fileWriter.close();
        }
        Object[] ret_val = new Object[]{this.network, new File(this.fileName).toURI(), new Integer(Cytoscape.FILE_XGMML)};
        Cytoscape.firePropertyChange("NETWORK_SAVED", null, ret_val);
    }
}

