/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfFont;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfChunk
extends RtfElement {
    private static final byte[] FONT_SUBSCRIPT = "\\sub".getBytes();
    private static final byte[] FONT_SUPERSCRIPT = "\\super".getBytes();
    private static final byte[] FONT_END_SUPER_SUBSCRIPT = "\\nosupersub".getBytes();
    private static final byte[] HIGHLIGHT = "\\highlight".getBytes();
    private RtfFont font = null;
    private String content = "";
    private boolean softLineBreaks = false;
    private float superSubScript = 0.0f;
    private RtfColor background = null;

    public RtfChunk(RtfDocument rtfDocument, Chunk chunk) {
        super(rtfDocument);
        if (chunk == null) {
            return;
        }
        if (chunk.getAttributes() != null && chunk.getAttributes().get("SUBSUPSCRIPT") != null) {
            this.superSubScript = ((Float)chunk.getAttributes().get("SUBSUPSCRIPT")).floatValue();
        }
        if (chunk.getAttributes() != null && chunk.getAttributes().get("BACKGROUND") != null) {
            this.background = new RtfColor(this.document, (Color)((Object[])chunk.getAttributes().get("BACKGROUND"))[0]);
        }
        this.font = new RtfFont(rtfDocument, chunk.font());
        this.content = chunk.content();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this.background != null) {
                byteArrayOutputStream.write(OPEN_GROUP);
            }
            byteArrayOutputStream.write(this.font.writeBegin());
            if (this.superSubScript < 0.0f) {
                byteArrayOutputStream.write(FONT_SUBSCRIPT);
            } else if (this.superSubScript > 0.0f) {
                byteArrayOutputStream.write(FONT_SUPERSCRIPT);
            }
            if (this.background != null) {
                byteArrayOutputStream.write(HIGHLIGHT);
                byteArrayOutputStream.write(this.intToByteArray(this.background.getColorNumber()));
            }
            byteArrayOutputStream.write(DELIMITER);
            byteArrayOutputStream.write(this.document.filterSpecialChar(this.content, false, this.softLineBreaks || this.document.getDocumentSettings().isAlwaysGenerateSoftLinebreaks()).getBytes());
            if (this.superSubScript != 0.0f) {
                byteArrayOutputStream.write(FONT_END_SUPER_SUBSCRIPT);
            }
            byteArrayOutputStream.write(this.font.writeEnd());
            if (this.background != null) {
                byteArrayOutputStream.write(CLOSE_GROUP);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        super.setRtfDocument(rtfDocument);
        this.font.setRtfDocument(this.document);
    }

    public void setSoftLineBreaks(boolean bl) {
        this.softLineBreaks = bl;
    }

    public boolean getSoftLineBreaks() {
        return this.softLineBreaks;
    }
}

