/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ColorConverter {
    private static ColorConverter defaultInstance = new ColorConverter(true);
    private Map colorToString;
    private Map stringToColor;

    public ColorConverter() {
        this(false);
    }

    private ColorConverter(boolean init) {
        if (init) {
            this.colorToString = new HashMap();
            this.stringToColor = new HashMap();
            this.init();
        } else {
            this.colorToString = new HashMap(ColorConverter.defaultInstance.colorToString);
            this.stringToColor = new HashMap(ColorConverter.defaultInstance.stringToColor);
        }
    }

    private void init() {
        this.addEntry(Color.black, "Black");
        this.addEntry(Color.blue, "Blue");
        this.addEntry(Color.cyan, "Cyan");
        this.addEntry(Color.darkGray, "Dark Gray");
        this.addEntry(Color.gray, "Gray");
        this.addEntry(Color.green, "Green");
        this.addEntry(Color.lightGray, "Light Gray");
        this.addEntry(Color.magenta, "Magenta");
        this.addEntry(Color.orange, "Orange");
        this.addEntry(Color.pink, "Pink");
        this.addEntry(Color.red, "Red");
        this.addEntry(Color.white, "White");
        this.addEntry(Color.yellow, "Yellow");
        this.addEntry(new Color(0, 0, 0), "Black");
        this.addEntry(new Color(192, 192, 192), "Silver");
        this.addEntry(new Color(128, 128, 128), "Gray");
        this.addEntry(new Color(255, 255, 255), "White");
        this.addEntry(new Color(128, 0, 0), "Maroon");
        this.addEntry(new Color(255, 0, 0), "Red");
        this.addEntry(new Color(128, 0, 128), "Purple");
        this.addEntry(new Color(255, 0, 255), "Fuchsia");
        this.addEntry(new Color(0, 128, 0), "Green");
        this.addEntry(new Color(0, 255, 0), "Lime");
        this.addEntry(new Color(128, 128, 0), "Olive");
        this.addEntry(new Color(255, 255, 0), "Yellow");
        this.addEntry(new Color(0, 0, 128), "Navy");
        this.addEntry(new Color(0, 0, 255), "Blue");
        this.addEntry(new Color(0, 128, 128), "Teal");
        this.addEntry(new Color(0, 255, 255), "Aqua");
        this.addEntry(new Color(0.1f, 0.1f, 0.1f), "Gray 10%");
        this.addEntry(new Color(0.2f, 0.2f, 0.2f), "Gray 20%");
        this.addEntry(new Color(0.3f, 0.3f, 0.3f), "Gray 30%");
        this.addEntry(new Color(0.4f, 0.4f, 0.4f), "Gray 40%");
        this.addEntry(new Color(0.5f, 0.5f, 0.5f), "Gray 50%");
        this.addEntry(new Color(0.6f, 0.6f, 0.6f), "Gray 60%");
        this.addEntry(new Color(0.7f, 0.7f, 0.7f), "Gray 70%");
        this.addEntry(new Color(0.8f, 0.8f, 0.8f), "Gray 80%");
        this.addEntry(new Color(0.9f, 0.9f, 0.9f), "Gray 90%");
        this.addEntry(new Color(255, 136, 28), "Orange");
        this.addEntry(new Color(120, 62, 27), "Brown");
        this.addEntry(new Color(0, 125, 32), "Forest Green");
        this.addEntry(new Color(11, 157, 150), "Turquoise");
        this.addEntry(new Color(109, 0, 168), "Purple");
        this.addEntry(new Color(168, 0, 126), "Magenta");
        this.addEntry(new Color(164, 207, 255), "Sky Blue");
        this.addEntry(new Color(225, 170, 255), "Violet");
        this.addEntry(new Color(255, 170, 210), "Light Magenta");
    }

    public static String get(Color color) {
        return defaultInstance.colorToString(color);
    }

    public static Color get(String name) throws ColorConversionException {
        return defaultInstance.stringToColor(name);
    }

    public void addEntry(Color c, String name) {
        this.stringToColor.put(name.toLowerCase(), c);
        this.colorToString.put(c, name);
    }

    public void clear() {
        this.stringToColor.clear();
        this.colorToString.clear();
    }

    public String colorToString(Color color) {
        String name = (String)this.colorToString.get(color);
        return name != null ? name : ColorConverter.getRGBName(color);
    }

    public Color stringToColor(String name) throws ColorConversionException {
        Color c = (Color)this.stringToColor.get(name = name.toLowerCase());
        if (c == null) {
            try {
                if (name.indexOf(44) > 0) {
                    StringTokenizer st = new StringTokenizer(name, ",");
                    int[] i = new int[4];
                    float[] f = new float[4];
                    String red = st.nextToken().trim();
                    String green = st.nextToken().trim();
                    String blue = st.nextToken().trim();
                    String alpha = st.hasMoreTokens() ? st.nextToken().trim() : null;
                    try {
                        i[0] = Integer.parseInt(red);
                        i[1] = Integer.parseInt(green);
                        i[2] = Integer.parseInt(blue);
                        i[3] = alpha != null ? Integer.parseInt(alpha) : 255;
                        c = this.createColor(i[0], i[1], i[2], i[3]);
                    }
                    catch (NumberFormatException nfe1) {
                        f[0] = Float.parseFloat(red);
                        f[1] = Float.parseFloat(green);
                        f[2] = Float.parseFloat(blue);
                        f[3] = alpha != null ? Float.parseFloat(alpha) : 1.0f;
                        c = this.createColor(f[0], f[1], f[2], f[3]);
                    }
                } else {
                    c = Color.decode(name);
                }
            }
            catch (Throwable t) {
                throw new ColorConversionException(name, t);
            }
        }
        return c;
    }

    protected Color createColor(int red, int green, int blue, int alpha) {
        return new Color(red, green, blue, alpha);
    }

    protected Color createColor(float red, float green, float blue, float alpha) {
        return new Color(red, green, blue, alpha);
    }

    private static String getRGBName(Color color) {
        return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha();
    }

    public static class ColorConversionException
    extends Exception {
        ColorConversionException(String value, Throwable cause) {
            super("Cannot convert " + value + " to Color");
            this.initCause(cause);
        }
    }
}

