/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;

public abstract class SequenceBuilderBase
implements SequenceBuilder {
    public static Object ERROR_FEATURES_PROPERTY = SequenceBuilderBase.class + "ERROR_FEATURES_PROPERTY";
    protected String name;
    protected String uri;
    protected Annotation annotation = new SimpleAnnotation();
    private Set rootFeatures = new HashSet();
    private List featureStack = new ArrayList();
    protected Sequence seq;

    public void startSequence() {
    }

    public void endSequence() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public abstract void addSymbols(Alphabet var1, Symbol[] var2, int var3, int var4) throws IllegalAlphabetException;

    public void addSequenceProperty(Object key, Object value) {
        this.addProperty(this.annotation, key, value);
    }

    public void startFeature(Feature.Template templ) {
        int stackSize;
        TemplateWithChildren t2 = new TemplateWithChildren();
        t2.template = templ;
        if (templ.annotation == Annotation.EMPTY_ANNOTATION) {
            templ.annotation = new SmallAnnotation();
        }
        if ((stackSize = this.featureStack.size()) == 0) {
            this.rootFeatures.add(t2);
        } else {
            TemplateWithChildren parent = (TemplateWithChildren)this.featureStack.get(stackSize - 1);
            if (parent.children == null) {
                parent.children = new HashSet();
            }
            parent.children.add(t2);
        }
        this.featureStack.add(t2);
    }

    public void addFeatureProperty(Object key, Object value) throws ParseException {
        try {
            int stackSize = this.featureStack.size();
            TemplateWithChildren top = (TemplateWithChildren)this.featureStack.get(stackSize - 1);
            this.addProperty(top.template.annotation, key, value);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new ParseException(ioobe, "Attempted to add annotation to a feature when no startFeature had been invoked");
        }
    }

    public void endFeature() {
        if (this.featureStack.size() == 0) {
            throw new BioError("Assertion failed: Not within a feature");
        }
        this.featureStack.remove(this.featureStack.size() - 1);
    }

    public Sequence makeSequence() throws BioException {
        try {
            Iterator i = this.rootFeatures.iterator();
            while (i.hasNext()) {
                TemplateWithChildren twc = (TemplateWithChildren)i.next();
                try {
                    Feature f = this.seq.createFeature(twc.template);
                    if (twc.children == null) continue;
                    this.makeChildFeatures(f, twc.children);
                }
                catch (Exception e) {
                    HashSet<TemplateWithChildren> errFeatures;
                    e.printStackTrace();
                    Annotation ann = this.seq.getAnnotation();
                    if (ann.containsProperty(ERROR_FEATURES_PROPERTY)) {
                        errFeatures = (HashSet<TemplateWithChildren>)ann.getProperty(ERROR_FEATURES_PROPERTY);
                    } else {
                        errFeatures = new HashSet<TemplateWithChildren>();
                        ann.setProperty(ERROR_FEATURES_PROPERTY, errFeatures);
                    }
                    errFeatures.add(twc);
                }
            }
        }
        catch (Exception ex) {
            throw new BioError("Couldn't create feature", ex);
        }
        return this.seq;
    }

    private void makeChildFeatures(Feature parent, Set children) throws Exception {
        Iterator i = children.iterator();
        while (i.hasNext()) {
            TemplateWithChildren twc = (TemplateWithChildren)i.next();
            Feature f = parent.createFeature(twc.template);
            if (twc.children == null) continue;
            this.makeChildFeatures(f, twc.children);
        }
    }

    protected void addProperty(Annotation ann, Object key, Object value) {
        if (value == null) {
            return;
        }
        Object oldValue = null;
        ArrayList<Object> newValue = value;
        if (ann.containsProperty(key)) {
            oldValue = ann.getProperty(key);
        }
        if (oldValue != null) {
            if (oldValue instanceof Collection) {
                ((Collection)oldValue).add(newValue);
                newValue = oldValue;
            } else {
                ArrayList<Object> nvList = new ArrayList<Object>();
                nvList.add(oldValue);
                nvList.add(newValue);
                newValue = nvList;
            }
        }
        try {
            ann.setProperty(key, newValue);
        }
        catch (ChangeVetoException ex) {
            throw new BioError("Annotation should be modifiable", ex);
        }
    }

    private static class TemplateWithChildren {
        Feature.Template template;
        Set children;

        private TemplateWithChildren() {
        }
    }
}

