/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceBuilderFilter;

public class FastaDescriptionLineParser
extends SequenceBuilderFilter {
    public FastaDescriptionLineParser(SequenceBuilder delegate) {
        super(delegate);
    }

    public void addSequenceProperty(Object key, Object value) throws ParseException {
        this.getDelegate().addSequenceProperty(key, value);
        if ("description_line".equals(key)) {
            String dline = value.toString();
            StringTokenizer toke = new StringTokenizer(dline);
            String name = toke.nextToken();
            this.setName(name);
            this.setURI("urn:sequence/fasta:" + name);
            if (toke.hasMoreTokens()) {
                this.getDelegate().addSequenceProperty("description", toke.nextToken("******"));
            }
        }
    }

    public static class Factory
    implements SequenceBuilderFactory,
    Serializable {
        private SequenceBuilderFactory delegateFactory;

        public Factory(SequenceBuilderFactory delegateFactory) {
            this.delegateFactory = delegateFactory;
        }

        public SequenceBuilder makeSequenceBuilder() {
            return new FastaDescriptionLineParser(this.delegateFactory.makeSequenceBuilder());
        }
    }
}

