/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.chromatogram;

import org.biojava.bio.chromatogram.Chromatogram;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.SymbolList;

public class ChromatogramTools {
    private ChromatogramTools() {
    }

    public static final SymbolList getDNASequence(Chromatogram chromat) {
        return chromat.getBaseCalls().symbolListForLabel(Chromatogram.DNA);
    }

    public static final SymbolList getTraceOffsets(Chromatogram chromat) {
        return chromat.getBaseCalls().symbolListForLabel(Chromatogram.OFFSETS);
    }

    public static final int[] getTraceOffsetArray(Chromatogram chromat) {
        int[] array = new int[chromat.getSequenceLength()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = ChromatogramTools.getTraceOffset(chromat, i + 1);
        }
        return array;
    }

    public static final int getTraceOffset(Chromatogram chromat, int which) {
        return ChromatogramTools.getIntFromSymbolList(chromat.getBaseCalls().symbolListForLabel(Chromatogram.OFFSETS), which);
    }

    public static final int getIntFromSymbolList(SymbolList list, int which) {
        return ((IntegerAlphabet.IntegerSymbol)list.symbolAt(which)).intValue();
    }
}

