/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.emblcd;

import java.io.IOException;
import java.io.InputStream;
import org.biojava.bio.seq.db.emblcd.RecordParser;

public abstract class EmblCDROMIndexReader {
    protected InputStream input;
    protected StringBuffer sb;
    protected RecordParser recParser;
    private byte[] int4 = new byte[4];
    private byte[] int2 = new byte[2];
    private byte[] dbName = new byte[20];
    private byte[] dbRelease = new byte[10];
    private byte[] dbDate = new byte[4];
    private byte[] record;
    private long fileLength;
    private long recordCount;
    private int recordLength;
    private String name;
    private String release;
    private String date;

    public EmblCDROMIndexReader(InputStream input) throws IOException {
        this.input = input;
        this.sb = new StringBuffer(512);
        this.recParser = new RecordParser();
        this.parseHeader();
    }

    public long readFileLength() {
        return this.fileLength;
    }

    public long readRecordCount() {
        return this.recordCount;
    }

    public int readRecordLength() {
        return this.recordLength;
    }

    public String readDBName() {
        return this.name;
    }

    public String readDBRelease() {
        return this.release;
    }

    public String readDBDate() {
        return this.date;
    }

    public abstract Object[] readRecord() throws IOException;

    public byte[] readRawRecord() throws IOException {
        int eof = this.input.read(this.record);
        if (eof == -1) {
            this.input.close();
        }
        return this.record;
    }

    public void close() throws IOException {
        this.input.close();
    }

    private void parseHeader() throws IOException {
        int eof = 0;
        eof = this.input.read(this.int4);
        if (eof == -1) {
            this.input.close();
        }
        this.fileLength = this.recParser.parseInt4(this.int4);
        eof = this.input.read(this.int4);
        if (eof == -1) {
            this.input.close();
        }
        this.recordCount = this.recParser.parseInt4(this.int4);
        eof = this.input.read(this.int2);
        if (eof == -1) {
            this.input.close();
        }
        this.recordLength = this.recParser.parseInt2(this.int2);
        this.record = new byte[this.recordLength];
        eof = this.input.read(this.dbName);
        if (eof == -1) {
            this.input.close();
        }
        this.sb.setLength(0);
        this.name = this.recParser.parseString(this.sb, this.dbName);
        eof = this.input.read(this.dbRelease);
        if (eof == -1) {
            this.input.close();
        }
        this.sb.setLength(0);
        this.release = this.recParser.parseString(this.sb, this.dbRelease);
        eof = this.input.read(this.dbDate);
        if (eof == -1) {
            this.input.close();
        }
        this.sb.setLength(0);
        this.date = this.recParser.parseDate(this.sb, this.dbDate);
        this.input.skip(256L);
    }
}

