/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.exportchooser;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.exportchooser.OptionTextField;
import org.freehep.util.UserProperties;

public class ImageExportFileType
extends AbstractExportFileType {
    protected String format;
    protected ImageWriterSpi spi;
    protected ImageWriteParam param;
    protected OptionCheckBox antialias;
    protected OptionCheckBox antialiasText;
    protected OptionCheckBox progressive;
    protected OptionCheckBox compress;
    protected OptionComboBox compressMode;
    protected OptionComboBox compressDescription;
    protected OptionTextField compressQuality;

    private ImageExportFileType(String format, ImageWriterSpi spi, ImageWriteParam param) {
        this.format = format;
        this.spi = spi;
        this.param = param;
    }

    protected ImageExportFileType(String format) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(format);
        if (iterator.hasNext()) {
            ImageWriter writer = iterator.next();
            this.format = format;
            this.spi = writer.getOriginatingProvider();
            this.param = writer.getDefaultWriteParam();
            return;
        }
        throw new IllegalArgumentException(((Object)((Object)this)).getClass() + ": Format not valid: " + format);
    }

    public static ImageExportFileType getInstance(String format) {
        try {
            SpecialClassLoader loader = new SpecialClassLoader(ImageExportFileType.class.getClassLoader(), format);
            String className = "ImageExportFileType";
            return (ImageExportFileType)((Object)loader.loadClass(className).newInstance());
        }
        catch (IllegalArgumentException e) {
            System.err.println(e);
            return null;
        }
        catch (NoClassDefFoundError e) {
            System.err.println(e);
            return null;
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            return null;
        }
        catch (InstantiationException e) {
            System.err.println(e);
            return null;
        }
        catch (IllegalAccessException e) {
            System.err.println(e);
            return null;
        }
        catch (ClassFormatError e) {
            System.err.println(e);
            return null;
        }
        catch (SecurityException e) {
            if (format.equalsIgnoreCase("gif")) {
                return ImageExportFileType.exportFileType("org.freehep.graphicsio.gif.GIFExportFileType");
            }
            if (format.equalsIgnoreCase("png")) {
                return ImageExportFileType.exportFileType("org.freehep.graphicsio.png.PNGExportFileType");
            }
            if (format.equalsIgnoreCase("jpg")) {
                return ImageExportFileType.exportFileType("org.freehep.graphicsio.jpg.JPGExportFileType");
            }
            if (format.equalsIgnoreCase("raw")) {
                return ImageExportFileType.exportFileType("org.freehep.graphicsio.raw.RawExportFileType");
            }
            System.err.println(e);
            return null;
        }
    }

    private static ImageExportFileType exportFileType(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (ImageExportFileType)((Object)clazz.newInstance());
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public String getDescription() {
        String f = this.format.toLowerCase();
        if (f.equals("jpg") || f.equals("jpeg")) {
            return "Joint Photographers Expert Group Format";
        }
        if (f.equals("png")) {
            return "Portable Network Graphics Format";
        }
        if (f.equals("gif")) {
            return "Graphics Interchange Format";
        }
        return this.spi.getDescription(Locale.US);
    }

    public String[] getExtensions() {
        return this.spi.getFileSuffixes();
    }

    public String[] getMIMETypes() {
        return this.spi.getMIMETypes();
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, ImageGraphics2D.getDefaultProperties(this.format));
        OptionPanel panel = new OptionPanel(this.format.toUpperCase() + " Format");
        String formatKey = "org.freehep.graphicsio." + this.format;
        panel.add("0 * * 1 [5 15 5 15] w", new BackgroundPanel((Properties)options, formatKey, ImageGraphics2D.canWriteTransparent(this.format), null));
        this.antialias = new OptionCheckBox((Properties)options, formatKey + ".Antialias", "Antialias");
        panel.add("0 * * 1 [5 15 5 15] w", this.antialias);
        this.antialiasText = new OptionCheckBox((Properties)options, formatKey + ".AntialiasText", "Antialias Text");
        panel.add("0 * * 1 [5 15 5 15] w", this.antialiasText);
        this.progressive = new OptionCheckBox((Properties)options, formatKey + ".Progressive", "Progressive");
        if (this.param.canWriteProgressive()) {
            panel.add("0 * * 1 [5 15 5 15] w", this.progressive);
        }
        this.compress = new OptionCheckBox((Properties)options, formatKey + ".Compress", "Compress");
        if (this.param.canWriteCompressed()) {
            if (ImageGraphics2D.canWriteUncompressed(this.format)) {
                panel.add("0 * * 1 [5 15 5 15] w", this.compress);
            }
            this.param.setCompressionMode(options.isProperty(formatKey + ".Compress") ? 2 : 0);
        }
        if (this.param.canWriteCompressed() && this.param.getCompressionMode() == 2) {
            String[] compressionTypes = this.param.getCompressionTypes();
            JLabel compressModeLabel = new JLabel("Compression Mode");
            this.compressMode = new OptionComboBox((Properties)options, formatKey + ".CompressMode", compressionTypes);
            if (compressionTypes.length > 1) {
                panel.add("0 * [5 15 5 15] r", compressModeLabel);
                panel.add("1 * [5 15 5 15] lw", this.compressMode);
                this.compress.enables(compressModeLabel);
                this.compress.enables(this.compressMode);
            }
            JLabel compressQualityLabel = new JLabel("Quality Value");
            panel.add("0 * [5 15 5 15] r", compressQualityLabel);
            this.compressQuality = new OptionTextField((Properties)options, formatKey + ".CompressQuality", 5);
            panel.add("1 * [5 15 5 15] lw", this.compressQuality);
            this.compress.enables(compressQualityLabel);
            this.compress.enables(this.compressQuality);
        }
        return panel;
    }

    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new ImageGraphics2D(os, target, this.format);
    }

    public String toString() {
        return super.toString() + " for " + this.format;
    }

    private static class SpecialClassLoader
    extends ClassLoader {
        private String format;

        SpecialClassLoader(ClassLoader parent, String format) {
            super(parent);
            this.format = format;
        }

        public Class findClass(String name) throws ClassNotFoundException {
            try {
                String formatUp = this.format.toUpperCase();
                String pkg = "org.freehep.graphicsio.exportchooser.";
                String templateName = pkg.replaceAll("\\.", "/") + (this.format.length() == 4 ? "ZZZZ" : "ZZZ") + name + ".class";
                String className = pkg + formatUp + name;
                InputStream in = this.getResourceAsStream(templateName);
                if (in == null) {
                    throw new IllegalArgumentException(templateName + " class does not exist.");
                }
                int n = 0;
                int offset = 0;
                byte[] bytes = new byte[4096];
                while (n >= 0) {
                    n = in.read(bytes, offset, bytes.length - offset);
                    if (n <= 0) continue;
                    offset += n;
                }
                in.close();
                if (this.format.length() == 3) {
                    for (int i = 0; i < 3; ++i) {
                        byte by = (byte)formatUp.charAt(i);
                        bytes[250 + i] = by;
                        bytes[172 + i] = by;
                        bytes[133 + i] = by;
                        bytes[202 + i] = (byte)this.format.charAt(i);
                    }
                } else {
                    for (int i = 0; i < 4; ++i) {
                        byte by = (byte)formatUp.charAt(i);
                        bytes[253 + i] = by;
                        bytes[173 + i] = by;
                        bytes[133 + i] = by;
                        bytes[204 + i] = (byte)this.format.charAt(i);
                    }
                }
                return this.defineClass(className, bytes, 0, offset);
            }
            catch (IOException e) {
                System.out.println(e);
                throw new ClassNotFoundException();
            }
        }
    }
}

