/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.BinomialDistributionUnder;
import BiNGO.CalculateTestTask;
import BiNGO.DistributionCountNeg;
import BiNGO.SwingWorker;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.Ontology;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class BinomialTestCalculateUnder
implements CalculateTestTask {
    private static Vector selectedNodes;
    private static Vector graphNodes;
    private static HashMap mapSmallN;
    private static HashMap mapSmallX;
    private static int bigN;
    private static int bigX;
    private static HashMap binomialTestMap;
    protected int currentProgress;
    protected int lengthOfTask;
    protected String statusMessage;
    protected boolean done;
    protected boolean canceled;

    public BinomialTestCalculateUnder(Vector selectedNodes, Vector graphNodes, Annotation annotation, Ontology ontology) {
        BinomialTestCalculateUnder.selectedNodes = selectedNodes;
        BinomialTestCalculateUnder.graphNodes = graphNodes;
        DistributionCountNeg dc = new DistributionCountNeg(annotation, ontology, selectedNodes, graphNodes);
        dc.countSmallN();
        dc.countSmallX();
        dc.countBigN();
        dc.countBigX();
        mapSmallN = dc.getHashMapSmallN();
        mapSmallX = dc.getHashMapSmallX();
        bigN = dc.getBigN();
        bigX = dc.getBigX();
        this.currentProgress = 0;
        this.lengthOfTask = mapSmallX.size();
        this.done = false;
        this.canceled = false;
    }

    public void calculate() {
        binomialTestMap = new HashMap();
        HashSet set = new HashSet(mapSmallX.keySet());
        Iterator iterator = set.iterator();
        this.currentProgress = 0;
        this.lengthOfTask = set.size();
        this.done = false;
        this.canceled = false;
        while (iterator.hasNext()) {
            Integer id = new Integer(iterator.next().toString());
            Integer smallXvalue = new Integer(mapSmallX.get(id).toString());
            Integer smallNvalue = new Integer(mapSmallN.get(id).toString());
            BinomialDistributionUnder bt = new BinomialDistributionUnder(smallXvalue, bigX, smallNvalue, bigN);
            binomialTestMap.put(id, bt.calculateBinomialDistribution());
            ++this.currentProgress;
            double percentDone = this.currentProgress * 100 / this.lengthOfTask;
            this.statusMessage = "Completed " + percentDone + "%.";
        }
        this.done = true;
        this.currentProgress = this.lengthOfTask;
    }

    public HashMap getTestMap() {
        return binomialTestMap;
    }

    public HashMap getMapSmallX() {
        return mapSmallX;
    }

    public HashMap getMapSmallN() {
        return mapSmallN;
    }

    public int getBigX() {
        return bigX;
    }

    public int getBigN() {
        return bigN;
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getTaskDescription() {
        return "Calculating Binomial Tests";
    }

    public String getCurrentStatusMessage() {
        return this.statusMessage;
    }

    public boolean isDone() {
        return this.done;
    }

    public void stop() {
        this.canceled = true;
        this.statusMessage = null;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public void start(boolean return_when_done) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return new DoTask();
            }
        };
        worker.start();
        if (return_when_done) {
            worker.get();
        }
    }

    class DoTask {
        DoTask() {
            BinomialTestCalculateUnder.this.calculate();
        }
    }
}

