/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.CytoscapeInit;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorCatalogFactory;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearance;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.SubjectBase;
import cytoscape.visual.VisualStyle;
import ding.view.DGraphView;
import ding.view.DingCanvas;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.Paint;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;

public class VisualMappingManager
extends SubjectBase {
    CyNetworkView networkView;
    CalculatorCatalog catalog;
    VisualStyle visualStyle;
    Logger logger;
    NodeAppearance myNodeApp = new NodeAppearance();
    EdgeAppearance myEdgeApp = new EdgeAppearance();
    GlobalAppearance myGlobalApp = new GlobalAppearance();

    public VisualMappingManager(CyNetworkView networkView) {
        VisualStyle vs;
        this.networkView = networkView;
        this.logger = this.logger;
        this.loadCalculatorCatalog();
        String defStyle = CytoscapeInit.getProperties().getProperty("defaultVisualStyle");
        if (defStyle == null) {
            defStyle = "default";
        }
        if ((vs = this.catalog.getVisualStyle(defStyle)) == null) {
            vs = this.catalog.getVisualStyle("default");
        }
        this.setVisualStyle(vs);
    }

    public void loadCalculatorCatalog() {
        this.loadCalculatorCatalog(null);
    }

    public void loadCalculatorCatalog(String vizmapLocation) {
        if (this.catalog == null) {
            this.catalog = CalculatorCatalogFactory.loadCalculatorCatalog();
        } else if (vizmapLocation != null) {
            this.catalog = CalculatorCatalogFactory.loadCalculatorCatalog();
        }
    }

    public void setNetworkView(CyNetworkView new_view) {
        this.networkView = new_view;
    }

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public CyNetwork getNetwork() {
        return this.networkView.getNetwork();
    }

    public CalculatorCatalog getCalculatorCatalog() {
        return this.catalog;
    }

    public VisualStyle getVisualStyle() {
        return this.visualStyle;
    }

    public VisualStyle setVisualStyle(VisualStyle vs) {
        if (vs != null) {
            VisualStyle tmp = this.visualStyle;
            this.visualStyle = vs;
            this.fireStateChanged();
            return tmp;
        }
        return this.visualStyle;
    }

    public VisualStyle setVisualStyle(String name) {
        VisualStyle vs = this.catalog.getVisualStyle(name);
        if (vs != null) {
            return this.setVisualStyle(vs);
        }
        return this.visualStyle;
    }

    public void applyNodeAppearances() {
        this.applyNodeAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyNodeAppearances(CyNetwork network, CyNetworkView network_view) {
        NodeAppearanceCalculator nodeAppearanceCalculator = this.visualStyle.getNodeAppearanceCalculator();
        Iterator i = network_view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nodeView = (NodeView)i.next();
            Node node = nodeView.getNode();
            nodeAppearanceCalculator.calculateNodeAppearance(this.myNodeApp, node, network);
            this.myNodeApp.applyAppearance(nodeView);
        }
    }

    public void applyEdgeAppearances() {
        this.applyEdgeAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyEdgeAppearances(CyNetwork network, CyNetworkView network_view) {
        EdgeAppearanceCalculator edgeAppearanceCalculator = this.visualStyle.getEdgeAppearanceCalculator();
        Iterator i = network_view.getEdgeViewsIterator();
        while (i.hasNext()) {
            EdgeView edgeView = (EdgeView)i.next();
            if (edgeView == null) continue;
            Edge edge = edgeView.getEdge();
            edgeAppearanceCalculator.calculateEdgeAppearance(this.myEdgeApp, edge, network);
            this.myEdgeApp.applyAppearance(edgeView);
        }
    }

    public void applyGlobalAppearances() {
        this.applyGlobalAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyGlobalAppearances(CyNetwork network, CyNetworkView network_view) {
        GlobalAppearanceCalculator globalAppearanceCalculator = this.visualStyle.getGlobalAppearanceCalculator();
        globalAppearanceCalculator.calculateGlobalAppearance(this.myGlobalApp, network);
        if (network_view instanceof DGraphView) {
            DingCanvas backgroundCanvas = ((DGraphView)network_view).getCanvas(DGraphView.Canvas.BACKGROUND_CANVAS);
            backgroundCanvas.setBackground(this.myGlobalApp.getBackgroundColor());
        } else {
            System.out.println("VisualMappingManager.applyGlobalAppearances() - DGraphView not found!");
            network_view.setBackgroundPaint(this.myGlobalApp.getBackgroundColor());
        }
        Iterator nodeIt = network.nodesIterator();
        while (nodeIt.hasNext()) {
            network_view.getNodeView((CyNode)nodeIt.next()).setSelectedPaint((Paint)this.myGlobalApp.getNodeSelectionColor());
        }
        Iterator edgeIt = network.edgesIterator();
        while (edgeIt.hasNext()) {
            network_view.getEdgeView((CyEdge)edgeIt.next()).setSelectedPaint((Paint)this.myGlobalApp.getEdgeSelectionColor());
        }
    }

    public void applyAppearances() {
        Date start = new Date();
        this.applyNodeAppearances();
        this.applyEdgeAppearances();
        this.applyGlobalAppearances();
        Date stop = new Date();
    }

    public void vizmapNode(NodeView nodeView, CyNetworkView network_view) {
        CyNode node = (CyNode)nodeView.getNode();
        NodeAppearanceCalculator nodeAppearanceCalculator = this.visualStyle.getNodeAppearanceCalculator();
        nodeAppearanceCalculator.calculateNodeAppearance(this.myNodeApp, node, network_view.getNetwork());
        this.myNodeApp.applyAppearance(nodeView);
    }

    public void vizmapEdge(EdgeView edgeView, CyNetworkView network_view) {
        CyEdge edge = (CyEdge)edgeView.getEdge();
        EdgeAppearanceCalculator edgeAppearanceCalculator = this.visualStyle.getEdgeAppearanceCalculator();
        edgeAppearanceCalculator.calculateEdgeAppearance(this.myEdgeApp, edge, network_view.getNetwork());
        this.myEdgeApp.applyAppearance(edgeView);
    }
}

