/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.dialogs.IntegerEntryField;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JointIntegerEntry
extends JPanel {
    IntegerEntryField field1;
    IntegerEntryField field2;
    JLabel constraintLabel;
    JCheckBox constraintBox;
    JFrame mainFrame;
    JPanel mainPanel;
    String field1Name;
    String field2Name;
    String fieldName;
    boolean locked;

    public JointIntegerEntry(String fieldName, String field1Name, String field2Name, int defaultValue1, int defaultValue2, int maxValue1, int maxValue2) {
        super(new GridLayout(1, 2, 10, 10));
        this.field1Name = field1Name;
        this.field2Name = field2Name;
        this.fieldName = fieldName;
        String fullName1 = fieldName + " " + field1Name;
        this.field1 = new IntegerEntryField(fullName1, defaultValue1, maxValue1);
        String fullName2 = fieldName + " " + field2Name;
        this.field2 = new IntegerEntryField(fullName2, defaultValue2, maxValue2);
        String constrString = "Lock " + fullName1 + " to " + field2Name + "?";
        this.constraintLabel = new JLabel(constrString);
        this.locked = false;
        if (defaultValue1 == defaultValue2) {
            this.locked = true;
        }
        this.constraintBox = new JCheckBox("", this.locked);
        this.constraintBox.addItemListener(new LockedItemListener());
        this.field1.getField().addFocusListener(new CopyField1To2Listener());
        this.whetherField2IsEnabled();
    }

    public Integer getInteger(String whichField) {
        if (whichField.equalsIgnoreCase(this.field1Name)) {
            return this.field1.getInteger();
        }
        return this.field2.getInteger();
    }

    public void setInteger(String whichField, Integer newVal) {
        if (whichField.equalsIgnoreCase(this.field1Name)) {
            this.field1.setInteger(newVal);
        } else {
            this.field2.setInteger(newVal);
        }
    }

    public int getInt(String whichField) {
        if (whichField.equalsIgnoreCase(this.field1Name)) {
            return this.field1.getInt();
        }
        return this.field2.getInt();
    }

    public void setInt(String whichField, int newVal) {
        if (whichField.equalsIgnoreCase(this.field1Name)) {
            this.field1.setInt(newVal);
        } else {
            this.field2.setInt(newVal);
        }
    }

    public void whetherField2IsEnabled() {
        this.field2.getLabel().setEnabled(!this.locked);
        this.field2.getField().setEnabled(!this.locked);
    }

    private void copy1to2() {
        this.field2.setInt(this.field1.getInt());
    }

    public JTextField getField(String whichField) {
        if (whichField.equalsIgnoreCase(this.field1Name)) {
            return this.field1.getField();
        }
        return this.field2.getField();
    }

    public JLabel getLabel(String whichField) {
        if (whichField.equalsIgnoreCase(this.field1Name)) {
            return this.field1.getLabel();
        }
        return this.field2.getLabel();
    }

    public JCheckBox getConstraintBox() {
        return this.constraintBox;
    }

    public JLabel getConstraintLabel() {
        return this.constraintLabel;
    }

    public class CopyField1To2Listener
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            if (JointIntegerEntry.this.locked) {
                JointIntegerEntry.this.copy1to2();
            }
        }

        public void focusLost(FocusEvent e) {
            if (JointIntegerEntry.this.locked) {
                JointIntegerEntry.this.copy1to2();
            }
        }
    }

    public class LockedItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            JCheckBox jcb = (JCheckBox)e.getItem();
            JointIntegerEntry.this.locked = jcb.isSelected();
            if (JointIntegerEntry.this.locked) {
                JointIntegerEntry.this.copy1to2();
            }
            JointIntegerEntry.this.whetherField2IsEnabled();
        }
    }
}

