/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.readers.GraphReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;

public class LoadNetworkTask
implements Task {
    private URI uri;
    private TaskMonitor taskMonitor;
    private GraphReader reader;
    private String name;

    public static void loadURL(URL u, boolean skipMessage) {
        LoadNetworkTask task = new LoadNetworkTask(u);
        LoadNetworkTask.setupTask(task, skipMessage);
    }

    public static void loadFile(File file, boolean skipMessage) {
        LoadNetworkTask task = new LoadNetworkTask(file);
        LoadNetworkTask.setupTask(task, skipMessage);
    }

    private static void setupTask(LoadNetworkTask task, boolean skipMessage) {
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner((Container)Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(true);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(skipMessage);
        TaskManager.executeTask((Task)task, (JTaskConfig)jTaskConfig);
    }

    private LoadNetworkTask(URL u) {
        this.reader = Cytoscape.getImportHandler().getReader(u);
        try {
            this.uri = u.toURI();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.uri = null;
        }
        this.name = u.toString();
    }

    private LoadNetworkTask(File file) {
        this.reader = Cytoscape.getImportHandler().getReader(file.getAbsolutePath());
        this.uri = file.toURI();
        this.name = file.getName();
    }

    public void run() {
        this.taskMonitor.setStatus("Reading in Network Data...");
        try {
            this.taskMonitor.setPercentCompleted(-1);
            this.taskMonitor.setStatus("Creating Cytoscape Network...");
            CyNetwork cyNetwork = Cytoscape.createNetwork(this.reader, true, null);
            Object[] ret_val = new Object[]{cyNetwork, this.uri};
            Cytoscape.firePropertyChange("NETWORK_LOADED", null, ret_val);
            if (cyNetwork != null) {
                this.informUserOfGraphStats(cyNetwork);
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("Could not read network from: ");
                sb.append(this.name);
                sb.append("\nThis file may not be a valid file format.");
                this.taskMonitor.setException((Throwable)new IOException(sb.toString()), sb.toString());
            }
            this.taskMonitor.setPercentCompleted(100);
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "Unable to load network.");
        }
    }

    private void informUserOfGraphStats(CyNetwork newNetwork) {
        DecimalFormat formatter = new DecimalFormat("#,###,###");
        StringBuffer sb = new StringBuffer();
        sb.append("Succesfully loaded network from:  ");
        sb.append(this.name);
        sb.append("\n\nNetwork contains " + formatter.format(newNetwork.getNodeCount()));
        sb.append(" nodes and " + formatter.format(newNetwork.getEdgeCount()));
        sb.append(" edges.\n\n");
        if (newNetwork.getNodeCount() < Integer.parseInt(CytoscapeInit.getProperties().getProperty("viewThreshold"))) {
            sb.append("Network is under " + CytoscapeInit.getProperties().getProperty("viewThreshold") + " nodes.  A view will be automatically created.");
        } else {
            sb.append("Network is over " + CytoscapeInit.getProperties().getProperty("viewThreshold") + " nodes.  A view has not been created." + "  If you wish to view this network, use " + "\"Create View\" from the \"Edit\" menu.");
        }
        this.taskMonitor.setStatus(sb.toString());
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Loading Network");
    }
}

