/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.FetchURL;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.GenbankProcessor;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.utils.ChangeVetoException;

public class GenbankSequenceDB {
    private static SequenceFormat format;
    private static String DBName;
    private boolean IOExceptionFound = false;
    private boolean ExceptionFound = false;
    private static final String urlBatchSequences = "http://www.ncbi.nlm.nih.gov:80/entrez/eutils/efetch.fcgi";

    protected SequenceFormat getSequenceFormat() {
        return format;
    }

    protected Alphabet getAlphabet() {
        return DNATools.getDNA();
    }

    protected URL getAddress(String id) throws MalformedURLException {
        String defaultReturnFormat = "text";
        FetchURL seqURL = new FetchURL(DBName, defaultReturnFormat);
        String baseurl = seqURL.getbaseURL();
        String db = seqURL.getDB();
        String url = baseurl + db + "&id=" + id + "&rettype=gb";
        return new URL(url);
    }

    protected URL getAddress(String id, String format) throws MalformedURLException {
        FetchURL seqURL = new FetchURL(DBName, format);
        String baseurl = seqURL.getbaseURL();
        if (!baseurl.equalsIgnoreCase("")) {
            baseurl = seqURL.getbaseURL();
        }
        String db = seqURL.getDB();
        String url = baseurl + db + "&id=" + id + "&rettype=gb";
        return new URL(url);
    }

    public String getName() {
        return DBName;
    }

    public Sequence getSequence(String id) throws Exception {
        try {
            this.IOExceptionFound = false;
            this.ExceptionFound = false;
            URL queryURL = this.getAddress(id);
            SequenceFormat sFormat = this.getSequenceFormat();
            SimpleSequenceBuilder sbuilder = new SimpleSequenceBuilder();
            GenbankProcessor.Factory sFact = new GenbankProcessor.Factory(SimpleSequenceBuilder.FACTORY);
            Alphabet alpha = this.getAlphabet();
            SymbolTokenization rParser = alpha.getTokenization("token");
            DataInputStream in = new DataInputStream(queryURL.openStream());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            SequenceIterator seqI = SeqIOTools.readGenbank(reader);
            return seqI.nextSequence();
        }
        catch (Exception e) {
            System.out.println("Exception found in GenbankSequenceDB -- getSequence");
            System.out.println(e.toString());
            this.ExceptionFound = true;
            this.IOExceptionFound = true;
            return null;
        }
    }

    public boolean checkIOException() {
        return this.IOExceptionFound;
    }

    public boolean checkException() {
        return this.ExceptionFound;
    }

    private String makeBatchRequest(URL url, Set list) {
        StringBuffer params = new StringBuffer();
        params.append("db=nucleotide&rettype=gb&id=");
        boolean b = true;
        Iterator i = list.iterator();
        while (b) {
            String idSequence = (String)i.next();
            params.append(idSequence);
            if (i.hasNext()) {
                params.append(",");
                continue;
            }
            b = false;
        }
        StringBuffer header = new StringBuffer();
        header.append("POST ");
        header.append(url.getPath());
        header.append(" HTTP/1.0\r\nConnection: close\r\nAccept: text/html, text/plain\r\nHost: ");
        header.append(url.getHost());
        header.append("\r\nUser-Agent: Biojava/GenbankSequenceDB\r\nContent-Type: application/x-www-form-urlencoded\r\nContent-Length: ");
        header.append(params.length());
        header.append("\r\n\r\n");
        StringBuffer request = new StringBuffer();
        request.append(header);
        request.append(params);
        return request.toString();
    }

    public SequenceDB getSequences(Set list) throws BioException {
        return this.getSequences(list, null);
    }

    public SequenceDB getSequences(Set list, SequenceDB database) throws BioException {
        if (database == null) {
            database = new HashSequenceDB();
        }
        try {
            URL url = new URL(urlBatchSequences);
            int port = url.getPort();
            String hostname = url.getHost();
            Socket s = new Socket(hostname, port);
            InputStream sin = s.getInputStream();
            BufferedReader fromServer = new BufferedReader(new InputStreamReader(sin));
            OutputStream sout = s.getOutputStream();
            PrintWriter toServer = new PrintWriter(new OutputStreamWriter(sout));
            toServer.print(this.makeBatchRequest(url, list));
            toServer.flush();
            boolean finEntete = false;
            String l = null;
            while ((l = fromServer.readLine()) != null && !finEntete) {
                if (!l.equals("")) continue;
                finEntete = true;
            }
            SequenceIterator seqI = SeqIOTools.readGenbank(fromServer);
            while (seqI.hasNext()) {
                database.addSequence(seqI.nextSequence());
            }
        }
        catch (MalformedURLException e) {
            throw new BioException(e, "Exception found in GenbankSequenceDB -- getSequences");
        }
        catch (IOException e) {
            throw new BioException(e, "Exception found in GenbankSequenceDB -- getSequences");
        }
        catch (BioException e) {
            throw new BioException(e, "Exception found in GenbankSequenceDB -- getSequences");
        }
        catch (ChangeVetoException e) {
            throw new BioException(e, "Exception found in GenbankSequenceDB -- getSequences");
        }
        return database;
    }

    static {
        DBName = "Genbank";
        GenbankFormat genbankFormat = new GenbankFormat();
    }
}

