/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.util.ArrayList;
import java.util.List;
import org.baderlab.brain.DistanceMetric;

public class DistanceMatrix {
    private double[] distanceMatrix = null;
    private int matrixDim = 0;
    private ArrayList labels = null;

    public DistanceMatrix(int matrixDim) {
        if (matrixDim < 2) {
            throw new RuntimeException("Distance matrix size must be larger than 1");
        }
        this.matrixDim = matrixDim;
        this.distanceMatrix = new double[(matrixDim * matrixDim - 1) / 2];
    }

    public int getMatrixDimension() {
        return this.matrixDim;
    }

    public void setValue(int i, int j, double value) {
        if (j >= i) {
            return;
        }
        this.distanceMatrix[i * (i - 1) / 2 + j] = value;
    }

    public double getValue(int i, int j) {
        if (i == j) {
            return 0.0;
        }
        if (j > i) {
            int oldj = j;
            j = i;
            i = oldj;
        }
        return this.distanceMatrix[i * (i - 1) / 2 + j];
    }

    public void setLabels(ArrayList labels) {
        this.labels = labels;
    }

    public ArrayList getLabels() {
        return this.labels;
    }

    public void calcDistances(List objectList, DistanceMetric distanceMetric) {
        for (int i = 0; i < objectList.size(); ++i) {
            Object object1 = objectList.get(i);
            for (int j = 0; j < i; ++j) {
                Object object2 = objectList.get(j);
                this.setValue(i, j, distanceMetric.calc(object1, object2));
            }
        }
    }

    public DistanceMatrix copy() {
        DistanceMatrix dm = new DistanceMatrix(this.matrixDim);
        System.arraycopy(this.distanceMatrix, 0, dm.distanceMatrix, 0, this.distanceMatrix.length);
        dm.setLabels(this.getLabels());
        return dm;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (i = 0; i < this.labels.size(); ++i) {
            sb.append("\t" + (String)this.labels.get(i));
        }
        sb.append(lineSep);
        for (i = 0; i < this.matrixDim; ++i) {
            sb.append(this.labels.get(i) + "\t");
            for (int j = 0; j < i; ++j) {
                sb.append(this.getValue(i, j));
                if (j >= i) continue;
                sb.append("\t");
            }
            sb.append(lineSep);
        }
        return sb.toString();
    }
}

