/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import java.util.ListIterator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.agave.AGAVEFeatureCallbackItf;
import org.biojava.bio.seq.io.agave.StAXContentHandler;
import org.biojava.bio.seq.io.agave.StAXFeatureHandler;
import org.biojava.bio.seq.io.agave.StAXHandlerFactory;
import org.biojava.bio.seq.io.agave.StAXPropertyHandler;
import org.biojava.bio.symbol.RangeLocation;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AGAVESeqLocationPropHandler
extends StAXPropertyHandler {
    public static final StAXHandlerFactory AGAVE_SEQ_LOCATION_PROP_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new AGAVESeqLocationPropHandler(staxenv);
        }
    };
    private int start;
    private int end;
    private String strand = "false";

    AGAVESeqLocationPropHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        this.setHandlerCharacteristics("seq_location", true);
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.start = new Integer(attrs.getValue("least_start"));
        this.end = new Integer(attrs.getValue("greatest_end"));
        this.strand = attrs.getValue("is_on_complement");
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
        int currLevel = this.staxenv.getLevel();
        if (currLevel >= 1) {
            ListIterator li = this.staxenv.getHandlerStackIterator(currLevel);
            while (li.hasPrevious()) {
                Object ob = li.previous();
                if (!(ob instanceof AGAVEFeatureCallbackItf)) continue;
                ((AGAVEFeatureCallbackItf)ob).reportFeature(new RangeLocation(this.start, this.end));
                if ("true".equalsIgnoreCase(this.strand)) {
                    ((AGAVEFeatureCallbackItf)ob).reportStrand(StrandedFeature.NEGATIVE);
                } else if ("false".equalsIgnoreCase(this.strand)) {
                    ((AGAVEFeatureCallbackItf)ob).reportStrand(StrandedFeature.POSITIVE);
                } else {
                    ((AGAVEFeatureCallbackItf)ob).reportStrand(StrandedFeature.UNKNOWN);
                }
                return;
            }
        }
    }
}

