/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.biojava.bio.dist.AbstractOrderNDistribution;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;

class IndexedNthOrderDistribution
extends AbstractOrderNDistribution
implements Serializable {
    static final long serialVersionUID = 8943232063125632673L;
    private transient Distribution[] dists;
    private transient AlphabetIndex index;
    private DistributionFactory df;

    IndexedNthOrderDistribution(Alphabet alpha, DistributionFactory df) throws IllegalAlphabetException {
        super(alpha);
        FiniteAlphabet conditioning = (FiniteAlphabet)this.getConditioningAlphabet();
        this.index = AlphabetManager.getAlphabetIndex(conditioning);
        this.index.addChangeListener(ChangeListener.ALWAYS_VETO, AlphabetIndex.INDEX);
        this.df = df;
        this.dists = new Distribution[conditioning.size()];
        for (int i = 0; i < conditioning.size(); ++i) {
            this.dists[i] = df.createDistribution(this.getConditionedAlphabet());
        }
    }

    public void setDistribution(Symbol sym, Distribution dist) throws IllegalSymbolException, IllegalAlphabetException {
        int indx = this.index.indexForSymbol(sym);
        if (dist.getAlphabet() != this.getConditionedAlphabet()) {
            throw new IllegalAlphabetException("The distribution must be over " + this.getConditionedAlphabet() + ", not " + dist.getAlphabet());
        }
        Distribution old = this.dists[indx];
        if (old != null && this.weightForwarder != null) {
            old.removeChangeListener(this.weightForwarder);
        }
        if (this.weightForwarder != null) {
            dist.addChangeListener(this.weightForwarder);
        }
        this.dists[indx] = dist;
    }

    public Distribution getDistribution(Symbol sym) throws IllegalSymbolException {
        return this.dists[this.index.indexForSymbol(sym)];
    }

    public Collection conditionedDistributions() {
        return Arrays.asList(this.dists);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        SymbolDistMemento[] sdm = new SymbolDistMemento[this.dists.length];
        for (int w = 0; w < sdm.length; ++w) {
            sdm[w] = new SymbolDistMemento(this.index.symbolForIndex(w), this.dists[w]);
        }
        oos.writeObject(sdm);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        FiniteAlphabet conditioning = (FiniteAlphabet)this.getConditioningAlphabet();
        this.index = AlphabetManager.getAlphabetIndex(conditioning);
        this.index.addChangeListener(ChangeListener.ALWAYS_VETO, AlphabetIndex.INDEX);
        this.dists = new Distribution[conditioning.size()];
        SymbolDistMemento[] sdm = (SymbolDistMemento[])stream.readObject();
        for (int m = 0; m < sdm.length; ++m) {
            try {
                this.dists[this.index.indexForSymbol((Symbol)sdm[m].symbol)] = sdm[m].dist;
                continue;
            }
            catch (IllegalSymbolException ex) {
                throw new IOException("Symbol in serialized stream can't be found in the alphabet");
            }
        }
    }

    private static class SymbolDistMemento
    implements Serializable {
        static final long serialVersionUID = 8387939181177306749L;
        public final Symbol symbol;
        public final Distribution dist;

        public SymbolDistMemento(Symbol s, Distribution dist) {
            this.symbol = s;
            this.dist = dist;
        }
    }
}

