/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.writers;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.attr.MultiHashMapDefinition;
import cytoscape.data.readers.MetadataParser;
import cytoscape.data.writers.NamespacePrefixMapperImpl;
import cytoscape.generated2.Att;
import cytoscape.generated2.GraphicEdge;
import cytoscape.generated2.GraphicGraph;
import cytoscape.generated2.GraphicNode;
import cytoscape.generated2.Graphics;
import cytoscape.generated2.ObjectFactory;
import cytoscape.generated2.ObjectType;
import cytoscape.generated2.RdfRDF;
import cytoscape.generated2.TypeGraphicsType;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.LineType;
import ding.view.DGraphView;
import giny.view.Bend;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;

public class XGMMLWriter {
    private static final String PACKAGE_NAME = "cytoscape.generated2";
    private static final String FORMAT_VERSION = "documentVersion";
    private static final float VERSION = 1.0f;
    private static final String METADATA_NAME = "networkMetadata";
    private static final String METADATA_ATTR_NAME = "Network Metadata";
    private static final String METANODE_KEY = "__metaNodeRindices";
    protected static final String NORMAL = "normal";
    protected static final String METANODE = "metanode";
    protected static final String REFERENCE = "reference";
    protected static final int NODE = 1;
    protected static final int EDGE = 2;
    protected static final int NETWORK = 3;
    public static final String BACKGROUND = "backgroundColor";
    public static final String GRAPH_VIEW_ZOOM = "GRAPH_VIEW_ZOOM";
    public static final String GRAPH_VIEW_CENTER_X = "GRAPH_VIEW_CENTER_X";
    public static final String GRAPH_VIEW_CENTER_Y = "GRAPH_VIEW_CENTER_Y";
    private static final String CSS_FILE = "base.css";
    protected static final String FLOAT_TYPE = "real";
    protected static final String INT_TYPE = "integer";
    protected static final String STRING_TYPE = "string";
    protected static final String LIST_TYPE = "list";
    protected static final String BOOLEAN_TYPE = "boolean";
    protected static final String MAP_TYPE = "map";
    protected static final String COMPLEX_TYPE = "complex";
    private CyAttributes nodeAttributes;
    private CyAttributes edgeAttributes;
    private CyAttributes networkAttributes;
    private String[] nodeAttNames = null;
    private String[] edgeAttNames = null;
    private String[] networkAttNames = null;
    private CyNetwork network;
    private CyNetworkView networkView;
    private ArrayList nodeList;
    private ArrayList metanodeList;
    private HashMap edgeMap;
    private ObjectFactory objFactory;
    private MetadataParser mdp;
    private GraphicGraph graph = null;

    public XGMMLWriter(CyNetwork network, CyNetworkView view) throws JAXBException, URISyntaxException {
        this.network = network;
        this.networkView = view;
        this.nodeAttributes = Cytoscape.getNodeAttributes();
        this.edgeAttributes = Cytoscape.getEdgeAttributes();
        this.networkAttributes = Cytoscape.getNetworkAttributes();
        this.nodeList = new ArrayList();
        this.metanodeList = new ArrayList();
        this.edgeMap = new HashMap();
        this.nodeAttNames = this.nodeAttributes.getAttributeNames();
        this.edgeAttNames = this.edgeAttributes.getAttributeNames();
        this.networkAttNames = this.networkAttributes.getAttributeNames();
        this.initializeJaxbObjects();
    }

    private void initializeJaxbObjects() throws JAXBException, URISyntaxException {
        this.objFactory = new ObjectFactory();
        this.graph = this.objFactory.createGraphicGraph();
        Att graphAtt = this.objFactory.createAtt();
        Att formatVersion = this.objFactory.createAtt();
        formatVersion.setName(FORMAT_VERSION);
        formatVersion.setValue(Float.toString(1.0f));
        this.graph.getAtt().add(formatVersion);
        this.graph.setId(this.network.getTitle());
        this.graph.setLabel(this.network.getTitle());
        this.mdp = new MetadataParser(this.network);
        RdfRDF metadata = this.mdp.getMetadata();
        graphAtt.setName(METADATA_NAME);
        graphAtt.getContent().add(metadata);
        this.graph.getAtt().add(graphAtt);
        if (this.networkView != null) {
            Att globalGraphics = this.objFactory.createAtt();
            globalGraphics.setName(BACKGROUND);
            globalGraphics.setValue(this.paint2string(this.networkView.getBackgroundPaint()));
            this.graph.getAtt().add(globalGraphics);
        }
    }

    public void write(Writer writer) throws JAXBException, IOException {
        this.writeNetworkAttributes();
        this.writeBaseNodes();
        this.writeMetanodes();
        this.writeEdges();
        JAXBContext jc = JAXBContext.newInstance((String)PACKAGE_NAME, (ClassLoader)this.getClass().getClassLoader());
        Marshaller marshaller = jc.createMarshaller();
        try {
            marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)Boolean.FALSE);
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        JAXBElement<GraphicGraph> graphicGraphElement = this.objFactory.createGraph(this.graph);
        marshaller.marshal(graphicGraphElement, writer);
        if (writer != null) {
            writer.close();
        }
    }

    private void writeEdges() throws JAXBException {
        Iterator it = this.network.edgesIterator();
        CyEdge curEdge = null;
        while (it.hasNext()) {
            curEdge = (CyEdge)it.next();
            this.writeEdge(curEdge);
            if (!this.edgeMap.containsKey(curEdge.getIdentifier())) continue;
            this.edgeMap.remove(curEdge.getIdentifier());
        }
        it = this.edgeMap.keySet().iterator();
        while (it.hasNext()) {
            curEdge = (CyEdge)this.edgeMap.get(it.next());
            this.writeEdge(curEdge);
        }
    }

    private void writeEdge(CyEdge curEdge) throws JAXBException {
        Graphics edgeGraphics;
        GraphicEdge jxbEdge = this.objFactory.createGraphicEdge();
        jxbEdge.setId(curEdge.getIdentifier());
        jxbEdge.setLabel(curEdge.getIdentifier());
        jxbEdge.setSource(Integer.toString(curEdge.getSource().getRootGraphIndex()));
        jxbEdge.setTarget(Integer.toString(curEdge.getTarget().getRootGraphIndex()));
        if (this.networkView != Cytoscape.getNullNetworkView() && (edgeGraphics = this.getGraphics(2, this.networkView.getEdgeView(curEdge))) != null) {
            jxbEdge.setGraphics(edgeGraphics);
        }
        this.attributeWriter(2, curEdge.getIdentifier(), jxbEdge);
        this.graph.getNodeOrEdge().add(jxbEdge);
    }

    private void writeNetworkAttributes() throws JAXBException {
        this.attributeWriter(3, this.network.getIdentifier(), null);
        if (this.networkView != null) {
            this.saveViewZoom();
            this.saveViewCenter();
        }
    }

    protected void attributeWriter(int type, String id, Object target) throws JAXBException {
        block6: {
            block7: {
                block5: {
                    if (type != 1) break block5;
                    GraphicNode targetNode = (GraphicNode)target;
                    for (int i = 0; i < this.nodeAttNames.length; ++i) {
                        if (this.nodeAttNames[i] == "node.width" || this.nodeAttNames[i] == "node.height") continue;
                        if (this.nodeAttNames[i] == "nodeType") {
                            String nType = this.nodeAttributes.getStringAttribute(id, this.nodeAttNames[i]);
                            if (nType != null) {
                                targetNode.setName(nType);
                                continue;
                            }
                            targetNode.setName("base");
                            continue;
                        }
                        Att att = this.createAttribute(id, this.nodeAttributes, this.nodeAttNames[i]);
                        if (att == null) continue;
                        targetNode.getAtt().add(att);
                    }
                    break block6;
                }
                if (type != 2) break block7;
                for (int i = 0; i < this.edgeAttNames.length; ++i) {
                    Att att = this.createAttribute(id, this.edgeAttributes, this.edgeAttNames[i]);
                    if (att == null) continue;
                    ((GraphicEdge)target).getAtt().add(att);
                }
                break block6;
            }
            if (type != 3) break block6;
            for (int i = 0; i < this.networkAttNames.length; ++i) {
                Att att;
                if (this.networkAttNames[i].equals(METADATA_ATTR_NAME) || this.networkAttNames[i].equals(METANODE_KEY) || (att = this.createAttribute(id, this.networkAttributes, this.networkAttNames[i])) == null) continue;
                this.graph.getAtt().add(att);
            }
        }
    }

    private Att createAttribute(String id, CyAttributes attributes, String attributeName) throws JAXBException {
        Att attr = this.objFactory.createAtt();
        byte attType = attributes.getType(attributeName);
        if (attType == 2) {
            Double dAttr = attributes.getDoubleAttribute(id, attributeName);
            attr.setName(attributeName);
            attr.setLabel(attributeName);
            attr.setType(ObjectType.fromValue(FLOAT_TYPE));
            if (dAttr != null) {
                attr.setValue(dAttr.toString());
            }
        } else if (attType == 3) {
            Integer iAttr = attributes.getIntegerAttribute(id, attributeName);
            attr.setName(attributeName);
            attr.setLabel(attributeName);
            attr.setType(ObjectType.fromValue(INT_TYPE));
            if (iAttr != null) {
                attr.setValue(iAttr.toString());
            }
        } else if (attType == 4) {
            String sAttr = attributes.getStringAttribute(id, attributeName);
            attr.setName(attributeName);
            attr.setLabel(attributeName);
            attr.setType(ObjectType.fromValue(STRING_TYPE));
            if (sAttr != null) {
                sAttr = sAttr.replace("\n", "\\n");
                attr.setValue(sAttr);
            } else if (attributeName == "nodeType") {
                attr.setValue(NORMAL);
            }
        } else if (attType == 1) {
            Boolean bAttr = attributes.getBooleanAttribute(id, attributeName);
            attr.setName(attributeName);
            attr.setLabel(attributeName);
            attr.setType(ObjectType.fromValue(BOOLEAN_TYPE));
            if (bAttr != null) {
                attr.setValue(bAttr.toString());
            }
        } else if (attType == -2) {
            List listAttr = attributes.getListAttribute(id, attributeName);
            attr.setName(attributeName);
            attr.setLabel(attributeName);
            attr.setType(ObjectType.fromValue(LIST_TYPE));
            for (Object obj : listAttr) {
                Att memberAttr = this.objFactory.createAtt();
                memberAttr.setValue(obj.toString());
                memberAttr.setType(ObjectType.fromValue(this.checkType(obj)));
                attr.getContent().add(memberAttr);
            }
        } else if (attType == -3) {
            Map mapAttr = attributes.getMapAttribute(id, attributeName);
            attr.setName(attributeName);
            attr.setLabel(attributeName);
            attr.setType(ObjectType.fromValue(MAP_TYPE));
            for (Object obj : mapAttr.keySet()) {
                String key = (String)obj;
                Att memberAttr = this.objFactory.createAtt();
                memberAttr.setName(key);
                memberAttr.setType(ObjectType.fromValue(this.checkType(mapAttr.get(key))));
                memberAttr.setValue(mapAttr.get(key).toString());
                attr.getContent().add(memberAttr);
            }
        } else if (attType == -4) {
            attr = this.createComplexAttribute(id, attributes, attributeName);
        }
        return attr;
    }

    private Att createComplexAttribute(String id, CyAttributes attributes, String attributeName) throws JAXBException {
        MultiHashMap mmap = attributes.getMultiHashMap();
        MultiHashMapDefinition mmapDef = attributes.getMultiHashMapDefinition();
        byte[] dimTypes = mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
        if (!this.objectHasKey(id, attributes, attributeName)) {
            return null;
        }
        Att attrToReturn = this.objFactory.createAtt();
        attrToReturn.setType(ObjectType.fromValue(COMPLEX_TYPE));
        attrToReturn.setLabel(attributeName);
        attrToReturn.setName(attributeName);
        attrToReturn.setValue(String.valueOf(dimTypes.length));
        Map complexAttributeStructure = this.getComplexAttributeStructure(mmap, id, attributeName, null, 0, dimTypes.length);
        String valTypeStr = this.getType(mmapDef.getAttributeValueType(attributeName));
        for (Object key : complexAttributeStructure.keySet()) {
            Map thisKeyMap = (Map)complexAttributeStructure.get(key);
            Att thisKeyAttr = this.objFactory.createAtt();
            thisKeyAttr.setType(ObjectType.fromValue(this.getType(dimTypes[0])));
            thisKeyAttr.setLabel(key.toString());
            thisKeyAttr.setName(key.toString());
            thisKeyAttr.setValue(String.valueOf(thisKeyMap.size()));
            thisKeyAttr.getContent().add(this.walkComplexAttributeStructure(thisKeyAttr, thisKeyMap, valTypeStr, dimTypes, 1));
            attrToReturn.getContent().add(thisKeyAttr);
        }
        return attrToReturn;
    }

    private boolean objectHasKey(String id, CyAttributes attributes, String attributeName) {
        MultiHashMap mmap = attributes.getMultiHashMap();
        CountedIterator keysIt = mmap.getObjectKeys(attributeName);
        while (keysIt.hasNext()) {
            String thisKey = (String)keysIt.next();
            if (thisKey == null || !thisKey.equals(id)) continue;
            return true;
        }
        return false;
    }

    private Map getComplexAttributeStructure(MultiHashMap mmap, String id, String attributeName, Object[] keys, int keysIndex, int numKeyDimensions) {
        if (keysIndex == numKeyDimensions) {
            return null;
        }
        HashMap keyHashMap = new HashMap();
        Object[] newKeys = new Object[keysIndex + 1];
        for (int lc = 0; lc < keysIndex; ++lc) {
            newKeys[lc] = keys[lc];
        }
        CountedIterator keyspan = mmap.getAttributeKeyspan(id, attributeName, keys);
        while (keyspan.hasNext()) {
            Object newKey = keyspan.next();
            newKeys[keysIndex] = newKey;
            Map nextLevelMap = this.getComplexAttributeStructure(mmap, id, attributeName, newKeys, keysIndex + 1, numKeyDimensions);
            Map objectToStore = nextLevelMap == null ? mmap.getAttributeValue(id, attributeName, newKeys) : nextLevelMap;
            keyHashMap.put(newKey, objectToStore);
        }
        return keyHashMap;
    }

    private Att walkComplexAttributeStructure(Att parentAttr, Map complexAttributeStructure, String attributeType, byte[] dimTypes, int dimTypesIndex) throws JAXBException, IllegalArgumentException {
        Att attrToReturn = null;
        for (Object key : complexAttributeStructure.keySet()) {
            Object possibleAttributeValue = complexAttributeStructure.get(key);
            if (possibleAttributeValue instanceof Map) {
                if (attrToReturn != null) {
                    parentAttr.getContent().add(attrToReturn);
                }
                attrToReturn = this.objFactory.createAtt();
                attrToReturn.setType(ObjectType.fromValue(this.getType(dimTypes[dimTypesIndex])));
                attrToReturn.setLabel(key.toString());
                attrToReturn.setName(key.toString());
                attrToReturn.setValue(String.valueOf(((Map)possibleAttributeValue).size()));
                Att returnedAttribute = this.walkComplexAttributeStructure(attrToReturn, (Map)possibleAttributeValue, attributeType, dimTypes, dimTypesIndex + 1);
                if (returnedAttribute == attrToReturn) continue;
                attrToReturn.getContent().add(returnedAttribute);
                continue;
            }
            if (parentAttr == null) {
                throw new IllegalArgumentException("Att argument should not be null.");
            }
            attrToReturn = parentAttr;
            Att keyAttr = this.objFactory.createAtt();
            keyAttr.setType(ObjectType.fromValue(this.getType(dimTypes[dimTypesIndex])));
            keyAttr.setLabel(key.toString());
            keyAttr.setName(key.toString());
            keyAttr.setValue(String.valueOf(1));
            Att valueAttr = this.objFactory.createAtt();
            valueAttr.setType(ObjectType.fromValue(attributeType));
            valueAttr.setValue(possibleAttributeValue.toString());
            keyAttr.getContent().add(valueAttr);
            attrToReturn.getContent().add(keyAttr);
        }
        return attrToReturn;
    }

    private Graphics getGraphics(int type, Object target) throws JAXBException {
        if (target == null) {
            return null;
        }
        Graphics graphics = this.objFactory.createGraphics();
        if (type == 1) {
            NodeView curNodeView = (NodeView)target;
            boolean hiddenNodeFlag = false;
            if (curNodeView.getWidth() == -1.0) {
                this.networkView.showGraphObject(curNodeView);
                hiddenNodeFlag = true;
            }
            graphics.setType(this.number2shape(curNodeView.getShape()));
            graphics.setH(curNodeView.getHeight());
            graphics.setW(curNodeView.getWidth());
            graphics.setX(curNodeView.getXPosition());
            graphics.setY(curNodeView.getYPosition());
            graphics.setFill(this.paint2string(curNodeView.getUnselectedPaint()));
            BasicStroke borderType = (BasicStroke)curNodeView.getBorder();
            graphics.setWidth(BigInteger.valueOf((long)borderType.getLineWidth()));
            graphics.setOutline(this.paint2string(curNodeView.getBorderPaint()));
            Att cytoscapeNodeAttr = this.objFactory.createAtt();
            cytoscapeNodeAttr.setName("cytoscapeNodeGraphicsAttributes");
            Att transparency = this.objFactory.createAtt();
            Att nodeLabelFont = this.objFactory.createAtt();
            Att borderLineType = this.objFactory.createAtt();
            transparency.setName("nodeTransparency");
            nodeLabelFont.setName("nodeLabelFont");
            borderLineType.setName("borderLineType");
            transparency.setValue(Double.toString(curNodeView.getTransparency()));
            nodeLabelFont.setValue(this.encodeFont(curNodeView.getLabel().getFont()));
            float[] dash = borderType.getDashArray();
            if (dash == null) {
                borderLineType.setValue("solid");
            } else {
                String dashArray = null;
                StringBuffer dashBuf = new StringBuffer();
                for (int i = 0; i < dash.length; ++i) {
                    dashBuf.append(Double.toString(dash[i]));
                    if (i >= dash.length - 1) continue;
                    dashBuf.append(",");
                }
                dashArray = dashBuf.toString();
                borderLineType.setValue(dashArray);
            }
            cytoscapeNodeAttr.getContent().add(transparency);
            cytoscapeNodeAttr.getContent().add(nodeLabelFont);
            cytoscapeNodeAttr.getContent().add(borderLineType);
            graphics.getAtt().add(cytoscapeNodeAttr);
            if (hiddenNodeFlag) {
                this.networkView.hideGraphObject(curNodeView);
            }
            return graphics;
        }
        if (type == 2) {
            EdgeView curEdgeView = (EdgeView)target;
            graphics.setWidth(BigInteger.valueOf((long)curEdgeView.getStrokeWidth()));
            graphics.setFill(this.paint2string(curEdgeView.getUnselectedPaint()));
            Att cytoscapeEdgeAttr = this.objFactory.createAtt();
            cytoscapeEdgeAttr.setName("cytoscapeEdgeGraphicsAttributes");
            Att sourceArrow = this.objFactory.createAtt();
            Att targetArrow = this.objFactory.createAtt();
            Att edgeLabelFont = this.objFactory.createAtt();
            Att edgeLineType = this.objFactory.createAtt();
            Att sourceArrowColor = this.objFactory.createAtt();
            Att targetArrowColor = this.objFactory.createAtt();
            Att bend = this.objFactory.createAtt();
            Att curved = this.objFactory.createAtt();
            sourceArrow.setName("sourceArrow");
            targetArrow.setName("targetArrow");
            edgeLabelFont.setName("edgeLabelFont");
            edgeLineType.setName("edgeLineType");
            sourceArrowColor.setName("sourceArrowColor");
            targetArrowColor.setName("targetArrowColor");
            bend.setName("edgeBend");
            curved.setName("curved");
            sourceArrow.setValue(Integer.toString(curEdgeView.getSourceEdgeEnd()));
            targetArrow.setValue(Integer.toString(curEdgeView.getTargetEdgeEnd()));
            edgeLabelFont.setValue(this.encodeFont(curEdgeView.getLabel().getFont()));
            edgeLineType.setValue(this.lineTypeBuilder(curEdgeView).toString());
            Bend bendData = curEdgeView.getBend();
            List handles = bendData.getHandles();
            for (Point2D handle : handles) {
                Att handlePoint = this.objFactory.createAtt();
                Att handleX = this.objFactory.createAtt();
                Att handleY = this.objFactory.createAtt();
                handlePoint.setName("handle");
                handleX.setName("x");
                handleY.setName("y");
                handleX.setValue(Double.toString(handle.getX()));
                handleY.setValue(Double.toString(handle.getY()));
                handlePoint.getContent().add(handleX);
                handlePoint.getContent().add(handleY);
                bend.getContent().add(handlePoint);
            }
            if (curEdgeView.getLineType() == 1) {
                curved.setValue("CURVED_LINES");
            } else if (curEdgeView.getLineType() == 2) {
                curved.setValue("STRAIGHT_LINES");
            }
            sourceArrowColor.setValue(this.paint2string(curEdgeView.getSourceEdgeEndPaint()));
            targetArrowColor.setValue(this.paint2string(curEdgeView.getTargetEdgeEndPaint()));
            cytoscapeEdgeAttr.getContent().add(sourceArrow);
            cytoscapeEdgeAttr.getContent().add(targetArrow);
            cytoscapeEdgeAttr.getContent().add(edgeLabelFont);
            cytoscapeEdgeAttr.getContent().add(edgeLineType);
            cytoscapeEdgeAttr.getContent().add(sourceArrowColor);
            cytoscapeEdgeAttr.getContent().add(targetArrowColor);
            if (bend.getContent().size() != 0) {
                cytoscapeEdgeAttr.getContent().add(bend);
            }
            cytoscapeEdgeAttr.getContent().add(curved);
            graphics.getAtt().add(cytoscapeEdgeAttr);
            return graphics;
        }
        return null;
    }

    private void expand(CyNode node, GraphicNode metanode, int[] childrenIndices) throws JAXBException {
        CyNode childNode = null;
        Att children = this.objFactory.createAtt();
        children.setName("metanodeChildren");
        GraphicGraph subGraph = this.objFactory.createGraphicGraph();
        GraphicNode jxbChildNode = null;
        for (int i = 0; i < childrenIndices.length; ++i) {
            childNode = (CyNode)Cytoscape.getRootGraph().getNode(childrenIndices[i]);
            jxbChildNode = this.objFactory.createGraphicNode();
            jxbChildNode.setId(childNode.getIdentifier());
            jxbChildNode.setLabel(childNode.getIdentifier());
            subGraph.getNodeOrEdge().add(jxbChildNode);
            int[] grandChildrenIndices = Cytoscape.getRootGraph().getNodeMetaChildIndicesArray(childNode.getRootGraphIndex());
            if (grandChildrenIndices == null || grandChildrenIndices.length == 0) {
                this.attributeWriter(1, childNode.getIdentifier(), jxbChildNode);
                metanode.setGraphics(this.getGraphics(1, this.networkView.getNodeView(node)));
                continue;
            }
            this.expand(childNode, jxbChildNode, grandChildrenIndices);
        }
        this.attributeWriter(1, metanode.getId(), metanode);
        children.getContent().add(subGraph);
        metanode.getAtt().add(children);
    }

    private TypeGraphicsType number2shape(int type) {
        switch (type) {
            case 2: {
                return TypeGraphicsType.ELLIPSE;
            }
            case 6: {
                return TypeGraphicsType.RECTANGLE;
            }
            case 1: {
                return TypeGraphicsType.DIAMOND;
            }
            case 3: {
                return TypeGraphicsType.HEXAGON;
            }
            case 4: {
                return TypeGraphicsType.OCTAGON;
            }
            case 5: {
                return TypeGraphicsType.PARALELLOGRAM;
            }
            case 0: {
                return TypeGraphicsType.TRIANGLE;
            }
        }
        return null;
    }

    private String paint2string(Paint p) {
        Color c = (Color)p;
        return "#" + Integer.toHexString(256 + c.getRed()).substring(1) + Integer.toHexString(256 + c.getGreen()).substring(1) + Integer.toHexString(256 + c.getBlue()).substring(1);
    }

    private void writeBaseNodes() throws JAXBException {
        GraphicNode jxbNode = null;
        CyNode curNode = null;
        Iterator it = this.network.nodesIterator();
        while (it.hasNext()) {
            NodeView curNodeView;
            curNode = (CyNode)it.next();
            jxbNode = this.objFactory.createGraphicNode();
            jxbNode.setId(Integer.toString(curNode.getRootGraphIndex()));
            jxbNode.setLabel(curNode.getIdentifier());
            jxbNode.setName("base");
            if (this.networkView != null && (curNodeView = this.networkView.getNodeView(curNode)) != null) {
                jxbNode.setGraphics(this.getGraphics(1, curNodeView));
            }
            this.attributeWriter(1, curNode.getIdentifier(), jxbNode);
            if (this.isMetanode(curNode)) {
                this.nodeList.add(curNode);
                this.expandChildren(curNode);
                continue;
            }
            this.nodeList.add(curNode);
            this.graph.getNodeOrEdge().add(jxbNode);
        }
    }

    private GraphicNode buildJAXBNode(CyNode node) throws JAXBException {
        GraphicNode jxbNode = null;
        jxbNode = this.objFactory.createGraphicNode();
        jxbNode.setId(Integer.toString(node.getRootGraphIndex()));
        jxbNode.setLabel(node.getIdentifier());
        if (this.networkView != Cytoscape.getNullNetworkView()) {
            jxbNode.setGraphics(this.getGraphics(1, this.networkView.getNodeView(node)));
        }
        this.attributeWriter(1, node.getIdentifier(), jxbNode);
        return jxbNode;
    }

    private void expandChildren(CyNode node) throws JAXBException {
        CyNode childNode = null;
        GraphicNode jxbNode = null;
        int[] childrenIndices = Cytoscape.getRootGraph().getNodeMetaChildIndicesArray(node.getRootGraphIndex());
        for (int i = 0; i < childrenIndices.length; ++i) {
            childNode = (CyNode)Cytoscape.getRootGraph().getNode(childrenIndices[i]);
            if (this.isMetanode(childNode)) {
                this.nodeList.add(childNode);
                this.expandChildren(childNode);
                continue;
            }
            this.nodeList.add(childNode);
            jxbNode = this.buildJAXBNode(childNode);
            jxbNode.setName("base");
            this.graph.getNodeOrEdge().add(jxbNode);
        }
    }

    private void writeMetanodes() throws JAXBException {
        CytoscapeRootGraph rootGraph = Cytoscape.getRootGraph();
        this.metanodeList = (ArrayList)this.networkAttributes.getListAttribute(this.network.getIdentifier(), METANODE_KEY);
        if (this.metanodeList == null || this.metanodeList.isEmpty()) {
            return;
        }
        Iterator it = this.metanodeList.iterator();
        HashMap<String, CyNode> embeddedMetaList = new HashMap<String, CyNode>();
        while (it.hasNext()) {
            int curNodeID = (Integer)it.next();
            int[] childrenIndices = rootGraph.getNodeMetaChildIndicesArray(curNodeID);
            if (childrenIndices == null) continue;
            for (int i = 0; i < childrenIndices.length; ++i) {
                CyNode childNode = (CyNode)Cytoscape.getRootGraph().getNode(childrenIndices[i]);
                if (!this.isMetanode(childNode)) continue;
                embeddedMetaList.put(childNode.getIdentifier(), childNode);
            }
        }
        it = this.metanodeList.iterator();
        while (it.hasNext()) {
            GraphicNode mNode;
            CyNode curNode = (CyNode)rootGraph.getNode((Integer)it.next());
            if (embeddedMetaList.containsKey(curNode.getIdentifier()) || (mNode = this.writeMetanode(curNode)) == null) continue;
            Att metanodeAtt = this.objFactory.createAtt();
            metanodeAtt.getContent().add(metanodeAtt);
            this.graph.getAtt().add(metanodeAtt);
        }
    }

    private GraphicNode writeMetanode(CyNode curNode) throws JAXBException {
        GraphicNode jxbNode = null;
        jxbNode = this.buildJAXBNode(curNode);
        HashMap<String, CyNode> childMap = new HashMap<String, CyNode>();
        int[] childrenIndices = Cytoscape.getRootGraph().getNodeMetaChildIndicesArray(curNode.getRootGraphIndex());
        Att children = this.objFactory.createAtt();
        GraphicGraph subGraph = this.objFactory.createGraphicGraph();
        for (int i = 0; childrenIndices != null && i < childrenIndices.length; ++i) {
            CyNode childNode = null;
            GraphicNode childJxbNode = null;
            childNode = (CyNode)Cytoscape.getRootGraph().getNode(childrenIndices[i]);
            childMap.put(childNode.getIdentifier(), childNode);
            String targetnodeID = Integer.toString(childNode.getRootGraphIndex());
            if (!this.isMetanode(childNode)) {
                childJxbNode = this.objFactory.createGraphicNode();
                childJxbNode.setHref("#" + targetnodeID);
            } else {
                childJxbNode = this.writeMetanode(childNode);
            }
            subGraph.getNodeOrEdge().add(childJxbNode);
        }
        children.getContent().add(subGraph);
        jxbNode.getAtt().add(children);
        Iterator it = Cytoscape.getRootGraph().edgesIterator();
        while (it.hasNext()) {
            CyEdge curEdge = (CyEdge)it.next();
            if (!childMap.containsKey(curEdge.getTarget().getIdentifier()) && !childMap.containsKey(curEdge.getSource().getIdentifier())) continue;
            this.edgeMap.put(curEdge.getIdentifier(), curEdge);
        }
        return jxbNode;
    }

    private boolean isMetanode(CyNode node) {
        int[] childrenIndices = Cytoscape.getRootGraph().getNodeMetaChildIndicesArray(node.getRootGraphIndex());
        return childrenIndices != null && childrenIndices.length != 0;
    }

    private String encodeFont(Font font) {
        return font.getName() + "-" + font.getStyle() + "-" + font.getSize();
    }

    private String checkType(Object obj) {
        if (obj.getClass() == String.class) {
            return STRING_TYPE;
        }
        if (obj.getClass() == Integer.class) {
            return INT_TYPE;
        }
        if (obj.getClass() == Double.class || obj.getClass() == Float.class) {
            return FLOAT_TYPE;
        }
        if (obj.getClass() == Boolean.class) {
            return BOOLEAN_TYPE;
        }
        return null;
    }

    private String getType(byte dimType) {
        if (dimType == 1) {
            return BOOLEAN_TYPE;
        }
        if (dimType == 2) {
            return FLOAT_TYPE;
        }
        if (dimType == 3) {
            return INT_TYPE;
        }
        if (dimType == 4) {
            return STRING_TYPE;
        }
        return null;
    }

    private LineType lineTypeBuilder(EdgeView view) {
        LineType lineType = LineType.LINE_1;
        BasicStroke stroke = (BasicStroke)view.getStroke();
        float[] dash = stroke.getDashArray();
        float width = stroke.getLineWidth();
        if (dash == null) {
            if ((double)width == 1.0) {
                lineType = LineType.LINE_1;
            } else if ((double)width == 2.0) {
                lineType = LineType.LINE_2;
            } else if ((double)width == 3.0) {
                lineType = LineType.LINE_3;
            } else if ((double)width == 4.0) {
                lineType = LineType.LINE_4;
            } else if ((double)width == 5.0) {
                lineType = LineType.LINE_5;
            } else if ((double)width == 6.0) {
                lineType = LineType.LINE_6;
            } else if ((double)width == 7.0) {
                lineType = LineType.LINE_7;
            }
        } else if ((double)width == 1.0) {
            lineType = LineType.DASHED_1;
        } else if ((double)width == 2.0) {
            lineType = LineType.DASHED_2;
        } else if ((double)width == 3.0) {
            lineType = LineType.DASHED_3;
        } else if ((double)width == 4.0) {
            lineType = LineType.DASHED_4;
        } else if ((double)width == 5.0) {
            lineType = LineType.DASHED_5;
        }
        return lineType;
    }

    private void saveViewZoom() throws JAXBException {
        Att attr = this.objFactory.createAtt();
        Double dAttr = new Double(this.networkView.getZoom());
        attr.setName(GRAPH_VIEW_ZOOM);
        attr.setLabel(GRAPH_VIEW_ZOOM);
        attr.setType(ObjectType.REAL);
        if (dAttr != null) {
            attr.setValue(dAttr.toString());
        }
        this.graph.getAtt().add(attr);
    }

    private void saveViewCenter() throws JAXBException {
        String[] coordinates = new String[]{GRAPH_VIEW_CENTER_X, GRAPH_VIEW_CENTER_Y};
        Point2D center = ((DGraphView)this.networkView).getCenter();
        for (int lc = 0; lc < 2; ++lc) {
            Att attr = this.objFactory.createAtt();
            double doubleCoord = lc == 0 ? center.getX() : center.getY();
            Double coord = new Double(doubleCoord);
            attr.setName(coordinates[lc]);
            attr.setLabel(coordinates[lc]);
            attr.setType(ObjectType.REAL);
            if (coord != null) {
                attr.setValue(coord.toString());
            }
            this.graph.getAtt().add(attr);
        }
    }
}

