/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class Thesaurus
implements Serializable {
    String species;
    HashMap labelToCommon;
    HashMap commonToLabel;
    HashMap aliasesToLabel;
    HashMap labelToAll;

    public Thesaurus(String species) {
        this.species = species;
        this.labelToCommon = new HashMap();
        this.commonToLabel = new HashMap();
        this.aliasesToLabel = new HashMap();
        this.labelToAll = new HashMap();
    }

    public String getSpecies() {
        return this.species;
    }

    public int nodeLabelCount() {
        return this.labelToAll.size();
    }

    public void add(String canonicalName, String commonName) {
        if (this.labelToCommon.containsKey(canonicalName)) {
            this.addAlternateCommonName(canonicalName, commonName);
        }
        if (!this.commonToLabel.containsKey(commonName)) {
            this.labelToCommon.put(canonicalName, commonName);
        }
        this.commonToLabel.put(commonName, canonicalName);
        this.storeAmongAllCommonNames(commonName, canonicalName);
    }

    public void remove(String canonicalName, String commonName) {
        this.labelToCommon.remove(canonicalName);
        this.commonToLabel.remove(commonName);
        this.labelToAll.remove(canonicalName);
    }

    public void addAlternateCommonName(String canonicalName, String alternateCommonName) {
        this.aliasesToLabel.put(alternateCommonName, canonicalName);
        this.storeAmongAllCommonNames(alternateCommonName, canonicalName);
    }

    protected void storeAmongAllCommonNames(String commonName, String canonicalName) {
        Vector allCommonNames = this.labelToAll.containsKey(canonicalName) ? (Vector)this.labelToAll.get(canonicalName) : new Vector();
        allCommonNames.add(commonName);
        this.labelToAll.put(canonicalName, allCommonNames);
    }

    public String getCommonName(String canonicalName) {
        return (String)this.labelToCommon.get(canonicalName);
    }

    public String getNodeLabel(String commonName) {
        if (this.commonToLabel.containsKey(commonName)) {
            return (String)this.commonToLabel.get(commonName);
        }
        if (this.aliasesToLabel.containsKey(commonName)) {
            return (String)this.aliasesToLabel.get(commonName);
        }
        return null;
    }

    public String[] getAllCommonNames(String canonicalName) {
        if (this.labelToAll.containsKey(canonicalName)) {
            Vector vector = (Vector)this.labelToAll.get(canonicalName);
            return vector.toArray(new String[0]);
        }
        return new String[0];
    }

    public String[] getAlternateCommonNames(String canonicalName) {
        if (this.labelToAll.containsKey(canonicalName)) {
            Vector vector = (Vector)this.labelToAll.get(canonicalName);
            vector.remove(this.getCommonName(canonicalName));
            return vector.toArray(new String[0]);
        }
        return new String[0];
    }

    public String[] getAllNamesInGroup(String key) {
        if (this.labelToAll.containsKey(key)) {
            Vector vector = (Vector)this.labelToAll.get(key);
            vector.add(key);
            return vector.toArray(new String[0]);
        }
        if (this.aliasesToLabel.containsKey(key)) {
            String label = (String)this.aliasesToLabel.get(key);
            Vector vector = (Vector)this.labelToAll.get(label);
            return vector.toArray(new String[0]);
        }
        return new String[0];
    }

    public String toString() {
        int length = 0;
        if (this.labelToCommon != null) {
            length = this.labelToCommon.size();
        }
        return this.species + ": " + length;
    }

    public void dump() {
        for (String label : this.labelToCommon.keySet()) {
            System.out.print("Key is " + label + ", and commons are ");
            String[] alias = this.getAllCommonNames(label);
            for (int i = 0; i < alias.length; ++i) {
                System.out.print(alias[i] + ", ");
            }
            System.out.println("");
        }
    }
}

