/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.AllTests;
import cytoscape.Cytoscape;
import cytoscape.data.readers.GMLReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GMLReaderTest
extends TestCase {
    private static String testDataDir;

    public GMLReaderTest(String name) {
        super(name);
        if (AllTests.runAllTests()) {
            testDataDir = "testData";
        }
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testSmallGraphRead() throws Exception {
        AllTests.standardOut("testSmallGraphRead");
        GMLReader reader = new GMLReader("testData/gal.gml");
        reader.read();
        int[] nodeArray = reader.getNodeIndicesArray();
        int[] edgeArray = reader.getEdgeIndicesArray();
        GMLReaderTest.assertEquals((String)"node count", (int)11, (int)nodeArray.length);
        GMLReaderTest.assertEquals((String)"edge count", (int)10, (int)edgeArray.length);
    }

    public void testMediumGraphRead() throws Exception {
        AllTests.standardOut("testMediumGraphRead");
        GMLReader reader = new GMLReader("testData/noLabels.gml");
        reader.read();
        int[] nodeArray = reader.getNodeIndicesArray();
        int[] edgeArray = reader.getEdgeIndicesArray();
        GMLReaderTest.assertEquals((String)"node count", (int)332, (int)nodeArray.length);
        GMLReaderTest.assertEquals((String)"edge count", (int)362, (int)edgeArray.length);
    }

    public void testIllFormattedGML() throws Exception {
        AllTests.standardOut("testIllFormattedGML");
        GMLReader reader = new GMLReader("testData/broken_t.gml");
        reader.read();
        int[] nodeArray = reader.getNodeIndicesArray();
        int[] edgeArray = reader.getEdgeIndicesArray();
        GMLReaderTest.assertEquals((String)"node count", (int)30, (int)nodeArray.length);
        GMLReaderTest.assertEquals((String)"edge count", (int)19, (int)edgeArray.length);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Error!  must supply path to test data directory on command line");
            Cytoscape.exit(0);
        }
        testDataDir = args[0];
        TestRunner.run((Test)new TestSuite(GMLReaderTest.class));
    }
}

