/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.BenjaminiHochbergFDR;
import BiNGO.Bonferroni;
import BiNGO.TestCalculator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MultipleTestingCorrection {
    private static String alpha;
    private static HashMap map;
    private static String type;
    private static HashMap correctionMap;
    private final String BENJAMINI_HOCHBERG_FDR = "Benjamini & Hochberg False Discovery Rate (FDR) correction";
    private final String BONFERRONI = "Bonferroni Family-Wise Error Rate (FWER) correction";

    public MultipleTestingCorrection(String alpha, HashMap map, String type) {
        MultipleTestingCorrection.type = type;
        MultipleTestingCorrection.alpha = alpha;
        MultipleTestingCorrection.map = map;
        correctionMap = null;
    }

    public void calculate() {
        HashSet goLabelsSet = new HashSet(map.keySet());
        Iterator iteratorGoLabelsSet = goLabelsSet.iterator();
        String[] pvalues = new String[map.size()];
        String[] goLabels = new String[map.size()];
        int i = 0;
        while (iteratorGoLabelsSet.hasNext()) {
            goLabels[i] = iteratorGoLabelsSet.next().toString();
            pvalues[i] = map.get(new Integer(goLabels[i])).toString();
            ++i;
        }
        if (type.equals("Bonferroni Family-Wise Error Rate (FWER) correction")) {
            Bonferroni bonferroni = new Bonferroni(pvalues, goLabels, alpha);
            TestCalculator tc = new TestCalculator(bonferroni);
            tc.run();
            String[] adjustedPvalues = bonferroni.getAdjustedPvalues();
            String[] sortedGOLabels = bonferroni.getOrdenedGOLabels();
            correctionMap = new HashMap();
            for (int i2 = 0; i2 < adjustedPvalues.length && i2 < sortedGOLabels.length; ++i2) {
                correctionMap.put(sortedGOLabels[i2], adjustedPvalues[i2]);
            }
        } else if (type.equals("Benjamini & Hochberg False Discovery Rate (FDR) correction")) {
            BenjaminiHochbergFDR fdr = new BenjaminiHochbergFDR(pvalues, goLabels, alpha);
            TestCalculator tc = new TestCalculator(fdr);
            tc.run();
            String[] adjustedPvalues = fdr.getAdjustedPvalues();
            String[] sortedGOLabels = fdr.getOrdenedGOLabels();
            correctionMap = new HashMap();
            for (int i3 = 0; i3 < adjustedPvalues.length && i3 < sortedGOLabels.length; ++i3) {
                correctionMap.put(sortedGOLabels[i3], adjustedPvalues[i3]);
            }
        } else {
            correctionMap = null;
        }
    }

    public HashMap getCorrectionMap() {
        return correctionMap;
    }
}

