package org.baderlab.lola.view.actions;

import static com.lowagie.text.Image.getInstance;
import org.baderlab.lola.model.ProfileSet;
import org.baderlab.lola.model.LogoTree;
import org.baderlab.lola.model.LogoGenerator;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.brain.BrainAlgorithm;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.*;

import com.lowagie.text.Rectangle;
import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PdfContentByte;

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: Aug 20, 2007
 * Time: 1:02:11 AM
 * To change this template use File | Settings | File Templates.
 */
public class SaveLogoTreeToFile implements ActionListener {
    private ProfileSet profileSet;
    LolaParameterSet paramSet;

    public SaveLogoTreeToFile(ProfileSet profileSet, LolaParameterSet params) {
        super();
        this.profileSet = profileSet;
        this.paramSet = params;

    }

    public void actionPerformed(ActionEvent actionEvent) {
        LogoTree tree = profileSet.getLogoTree();
        if (tree != null) {

            BrainAlgorithm alg = new BrainAlgorithm();
//            BufferedImage image = alg.runProfileCluster(
//                    paramSet.getProfileFile().toString(),
//                    paramSet.getTreeTitle(),
//                    new File(tree.getOutputPath()), true);

            BufferedImage image = tree.getImage();
            if (image != null) {
                try {
                    LogoGenerator.saveImageAsPDF(new File(tree.getOutputPath()), tree.getImage(), image.getWidth(), image.getHeight(), null);
                } catch (IOException e) {
                    e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
                }
            }

            tree.setIsSaved(true);
        }
    }
}
