/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.baderlab.wordcloud.internal.ui.UIManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.util.swing.FileUtil;

public class ExportImageAction
extends AbstractCyAction {
    public static final String SESSION_EXT = ".png";
    public static final String TITLE = "Export Cloud Image";
    private CySwingApplication application;
    private FileUtil fileUtil;
    private UIManager uiManager;

    public ExportImageAction(CySwingApplication application, FileUtil fileUtil, UIManager uiManager) {
        super(TITLE);
        this.application = application;
        this.fileUtil = fileUtil;
        this.uiManager = uiManager;
    }

    private String exportImage() {
        String fileName = this.promptForFileName();
        if (fileName != null) {
            this.saveFile(fileName);
        }
        return fileName;
    }

    private String promptForFileName() {
        String name;
        try {
            List filters = Collections.emptyList();
            name = this.fileUtil.getFile((Component)this.application.getJFrame(), "Save Current Cloud as PNG File", 1, filters).toString();
        }
        catch (Exception exp) {
            return null;
        }
        if (!name.endsWith(SESSION_EXT)) {
            name = name + SESSION_EXT;
        }
        return name;
    }

    private void saveFile(String name) {
        RenderedImage image = this.uiManager.getCloudDisplayPanel().createImage();
        try {
            ImageIO.write(image, "png", new File(name));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.exportImage();
    }
}

