/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class WordDelimiters {
    private static final String DELIMITER = "SAVEDELIMITER";
    private static final String FIRSTDELIMITER = "NewLineEquivalent";
    private static final String SECONDDELIMITER = "TabbedEquivalent";
    private Pattern splitter = null;
    private TreeSet<String> delimsInUse = new TreeSet();
    private TreeSet<String> delimsToAdd = new TreeSet();
    private TreeSet<String> userDelims = new TreeSet();
    private final HashMap<String, String> regexTranslation = new HashMap();

    public WordDelimiters() {
        this.regexTranslation.put("tab", "\\t");
        this.regexTranslation.put("space", " ");
        this.regexTranslation.put("newline", "\\n");
        this.regexTranslation.put("carriage return", "\\r");
        this.regexTranslation.put("form feed", "\\f");
        this.delimsInUse.add("tab");
        this.delimsInUse.add("space");
        this.delimsInUse.add("newline");
        this.delimsInUse.add("carriage return");
        this.delimsInUse.add("form feed");
        this.delimsInUse.add("!");
        this.delimsInUse.add("\"");
        this.delimsInUse.add("#");
        this.delimsInUse.add("$");
        this.delimsInUse.add("%");
        this.delimsInUse.add("&");
        this.delimsInUse.add("(");
        this.delimsInUse.add(")");
        this.delimsInUse.add("*");
        this.delimsInUse.add("+");
        this.delimsInUse.add(",");
        this.delimsInUse.add(".");
        this.delimsInUse.add("/");
        this.delimsInUse.add(":");
        this.delimsInUse.add(";");
        this.delimsInUse.add("<");
        this.delimsInUse.add("=");
        this.delimsInUse.add(">");
        this.delimsInUse.add("?");
        this.delimsInUse.add("@");
        this.delimsInUse.add("[");
        this.delimsInUse.add("\\");
        this.delimsInUse.add("]");
        this.delimsInUse.add("^");
        this.delimsInUse.add("_");
        this.delimsInUse.add("`");
        this.delimsInUse.add("{");
        this.delimsInUse.add("|");
        this.delimsInUse.add("}");
        this.delimsInUse.add("~");
        this.delimsInUse.add("-");
        this.delimsToAdd.add("'");
    }

    public WordDelimiters(String propFile) {
        String curDelim;
        String[] delims;
        String value;
        this.regexTranslation.put("tab", "\\t");
        this.regexTranslation.put("space", " ");
        this.regexTranslation.put("newline", "\\n");
        this.regexTranslation.put("carriage return", "\\r");
        this.regexTranslation.put("form feed", "\\f");
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split(FIRSTDELIMITER);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            String[] tokens = line.split(SECONDDELIMITER);
            if (tokens.length == 2) {
                props.put(tokens[0], tokens[1]);
            }
            ++i;
        }
        if (props.get("DelimsInUse") != null || props.get("DelimsToAdd") != null) {
            this.delimsInUse = new TreeSet();
            this.delimsToAdd = new TreeSet();
        }
        if ((value = (String)props.get("DelimsInUse")) != null) {
            delims = value.split(DELIMITER);
            int i2 = 0;
            while (i2 < delims.length) {
                curDelim = delims[i2];
                this.delimsInUse.add(curDelim);
                ++i2;
            }
        }
        if ((value = (String)props.get("DelimsToAdd")) != null) {
            delims = value.split(DELIMITER);
            int i3 = 0;
            while (i3 < delims.length) {
                curDelim = delims[i3];
                this.delimsToAdd.add(curDelim);
                ++i3;
            }
        }
        if ((value = (String)props.get("AddedDelims")) != null) {
            delims = value.split(DELIMITER);
            int i4 = 0;
            while (i4 < delims.length) {
                curDelim = delims[i4];
                this.userDelims.add(curDelim);
                ++i4;
            }
        }
    }

    public String toString() {
        StringBuffer delimVariables = new StringBuffer();
        StringBuffer output = new StringBuffer();
        if (this.delimsInUse.size() > 0) {
            for (String curDelim : this.delimsInUse) {
                output.append(String.valueOf(curDelim) + DELIMITER);
            }
            delimVariables.append("DelimsInUseTabbedEquivalent" + output.toString() + FIRSTDELIMITER);
        }
        output = new StringBuffer();
        if (this.delimsToAdd.size() > 0) {
            for (String curWord : this.delimsToAdd) {
                output.append(String.valueOf(curWord) + DELIMITER);
            }
            delimVariables.append("DelimsToAddTabbedEquivalent" + output.toString() + FIRSTDELIMITER);
        }
        output = new StringBuffer();
        if (this.userDelims.size() > 0) {
            for (String curWord : this.userDelims) {
                output.append(String.valueOf(curWord) + DELIMITER);
            }
            delimVariables.append("AddedDelimsTabbedEquivalent" + output.toString() + FIRSTDELIMITER);
        }
        return delimVariables.toString();
    }

    public synchronized Pattern getSplitter() {
        if (this.splitter == null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String delim : this.delimsInUse) {
                if (!first) {
                    sb.append('|');
                }
                if (this.regexTranslation.containsKey(delim)) {
                    sb.append(this.regexTranslation.get(delim));
                } else {
                    sb.append(Pattern.quote(delim));
                }
                first = false;
            }
            for (String delim : this.userDelims) {
                if (!first) {
                    sb.append('|');
                }
                sb.append(Pattern.quote(delim));
                first = false;
            }
            this.splitter = Pattern.compile(sb.toString());
        }
        return this.splitter;
    }

    public List<String> split(String s) {
        ArrayList<String> words = new ArrayList<String>();
        String[] stringArray = this.getSplitter().split(s);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word != null && !"".equals(word)) {
                words.add(word);
            }
            ++n2;
        }
        return words;
    }

    public void addDelimToUse(String delim) {
        this.splitter = null;
        if (this.delimsToAdd.contains(delim)) {
            this.delimsToAdd.remove(delim);
            this.delimsInUse.add(delim);
        } else if (!this.userDelims.contains(delim)) {
            this.userDelims.add(delim);
        }
    }

    public void removeDelimiter(String delim) {
        this.splitter = null;
        if (!delim.equals("newline") && !delim.equals("tab")) {
            if (this.userDelims.contains(delim)) {
                this.userDelims.remove(delim);
            } else if (this.delimsInUse.contains(delim)) {
                this.delimsInUse.remove(delim);
                this.delimsToAdd.add(delim);
            }
        }
    }

    public TreeSet<String> getDelimsInUse() {
        return this.delimsInUse;
    }

    public TreeSet<String> getDelimsToAdd() {
        return this.delimsToAdd;
    }

    public TreeSet<String> getUserDelims() {
        return this.userDelims;
    }
}

