/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.baderlab.wordcloud.internal.cluster.CloudInfo;
import org.baderlab.wordcloud.internal.cluster.SingleWordCluster;
import org.baderlab.wordcloud.internal.cluster.WordPair;

public class WordClusters {
    private ArrayList<SingleWordCluster> clusters = new ArrayList();
    private final CloudInfo cloudInfo;

    public WordClusters(CloudInfo cloudInfo) {
        this.cloudInfo = cloudInfo;
        this.initialize();
    }

    private void initialize() {
        this.clusters = new ArrayList();
        for (String curWord : this.cloudInfo.getSelectedCounts().keySet()) {
            SingleWordCluster curList = new SingleWordCluster(this.cloudInfo);
            curList.add(curWord);
            this.clusters.add(curList);
        }
    }

    public void combineClusters(WordPair aPair) {
        String curWord;
        int i;
        if (!this.isValidPair(aPair)) {
            return;
        }
        String firstWord = aPair.getFirstWord();
        String secondWord = aPair.getSecondWord();
        SingleWordCluster firstCluster = null;
        SingleWordCluster secondCluster = null;
        for (SingleWordCluster curCluster : this.clusters) {
            if (curCluster == null) continue;
            List<String> curList = curCluster.getWordList();
            int size = curList.size();
            String firstItem = curList.get(0);
            String lastItem = curList.get(size - 1);
            if (firstItem.equals(secondWord)) {
                secondCluster = curCluster;
            }
            if (!lastItem.equals(firstWord)) continue;
            firstCluster = curCluster;
        }
        SingleWordCluster newCluster = new SingleWordCluster(this.cloudInfo);
        List<String> firstList = firstCluster.getWordList();
        List<String> secondList = secondCluster.getWordList();
        for (i = 0; i < firstList.size(); ++i) {
            curWord = firstList.get(i);
            newCluster.add(curWord);
        }
        for (i = 0; i < secondList.size(); ++i) {
            curWord = secondList.get(i);
            newCluster.add(curWord);
        }
        this.clusters.remove(firstCluster);
        this.clusters.remove(secondCluster);
        this.clusters.add(newCluster);
    }

    private boolean isValidPair(WordPair aPair) {
        boolean isValid = false;
        String firstWord = aPair.getFirstWord();
        String secondWord = aPair.getSecondWord();
        Object firstCluster = null;
        SingleWordCluster secondCluster = null;
        for (SingleWordCluster curCluster : this.clusters) {
            if (curCluster == null) continue;
            List<String> curList = curCluster.getWordList();
            int size = curList.size();
            String firstItem = curList.get(0);
            String lastItem = curList.get(size - 1);
            if (firstItem.equals(secondWord)) {
                secondCluster = curCluster;
            }
            if (!lastItem.equals(firstWord)) continue;
            firstCluster = curCluster;
        }
        if (firstCluster != null && secondCluster != null && !firstCluster.equals(secondCluster)) {
            isValid = true;
        }
        return isValid;
    }

    public void orderClusters() {
        Collections.sort(this.clusters);
        Collections.reverse(this.clusters);
    }

    public ArrayList<SingleWordCluster> getClusters() {
        return this.clusters;
    }
}

