/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.baderlab.wordcloud.internal.Stemmer;
import org.baderlab.wordcloud.internal.cluster.CloudDisplayStyles;
import org.baderlab.wordcloud.internal.cluster.CloudWordInfo;
import org.baderlab.wordcloud.internal.cluster.ClusterBuilder;
import org.baderlab.wordcloud.internal.cluster.WordPair;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.model.NetworkParameters;
import org.baderlab.wordcloud.internal.model.WordDelimiters;
import org.baderlab.wordcloud.internal.model.WordFilter;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class CloudInfo {
    protected static final Integer MINFONTSIZE = 12;
    protected static final Integer MAXFONTSIZE = 64;
    private Map<String, Set<CyNode>> stringNodeMapping = new HashMap<String, Set<CyNode>>();
    private Map<String, Integer> networkCounts = new HashMap<String, Integer>();
    private Map<String, Integer> selectedCounts = new HashMap<String, Integer>();
    private Map<WordPair, Integer> networkPairCounts = new HashMap<WordPair, Integer>();
    private Map<WordPair, Integer> selectedPairCounts = new HashMap<WordPair, Integer>();
    private Map<String, Double> ratios = new HashMap<String, Double>();
    private Map<WordPair, Double> pairRatios = new HashMap<WordPair, Double>();
    private List<CloudWordInfo> cloudWords = new ArrayList<CloudWordInfo>();
    private double minRatio;
    private double maxRatio;
    private double meanRatio;
    private double meanWeight;
    private double minWeight;
    private double maxWeight;
    private boolean countInitialized = false;
    private boolean selInitialized = false;
    private boolean ratiosInitialized = false;
    private int countTotal = 0;
    private final CloudParameters cloud;

    public CloudInfo(CloudParameters cloud) {
        this.cloud = cloud;
    }

    public boolean isForCloud(CloudParameters cloud) {
        return this.cloud == cloud;
    }

    public CyNetwork getNetwork() {
        return this.cloud.getNetworkParams().getNetwork();
    }

    public int getMaxWords() {
        return this.cloud.getMaxWords();
    }

    public int getMinWordOccurrence() {
        return this.cloud.getMinWordOccurrence();
    }

    public CloudDisplayStyles getDisplayStyle() {
        return this.cloud.getDisplayStyle();
    }

    private void initializeNetworkCounts() {
        NetworkParameters networkParams = this.cloud.getNetworkParams();
        CyNetwork network = networkParams.getNetwork();
        if (this.countInitialized || network == null) {
            return;
        }
        this.networkCounts = new HashMap<String, Integer>();
        this.networkPairCounts = new HashMap<WordPair, Integer>();
        this.stringNodeMapping = new HashMap<String, Set<CyNode>>();
        for (String attributeName : this.cloud.getAttributeNames()) {
            for (CyNode curNode : networkParams.getNetwork().getNodeList()) {
                String value = this.getNodeAttributeVal(network, curNode, attributeName);
                if (value == null) continue;
                this.updateNetworkWordCounts(curNode, value);
            }
        }
        this.countInitialized = true;
    }

    private Collection<String> processNodeString(String nodeValue) {
        WordDelimiters delimeters = this.cloud.getNetworkParams().getDelimeters();
        Collection<String> words = delimeters.split(nodeValue.toLowerCase());
        if (this.cloud.getNetworkParams().getIsStemming()) {
            HashSet<String> stemmedWords = new HashSet<String>();
            for (String word : words) {
                Stemmer stemmer = new Stemmer();
                for (int i = 0; i < word.length(); ++i) {
                    stemmer.add(word.charAt(i));
                }
                stemmer.stem();
                stemmedWords.add(stemmer.toString());
            }
            words = stemmedWords;
        }
        return words;
    }

    private void updateNetworkWordCounts(CyNode curNode, String nodeValue) {
        if (nodeValue == null) {
            return;
        }
        Collection<String> wordSet = this.processNodeString(nodeValue);
        String lastWord = "";
        WordFilter filter = this.cloud.getNetworkParams().getFilter();
        for (String curWord : wordSet) {
            if (filter.contains(curWord)) continue;
            if (!this.stringNodeMapping.containsKey(curWord)) {
                this.stringNodeMapping.put(curWord, new HashSet());
                this.networkCounts.put(curWord, 0);
            }
            this.stringNodeMapping.get(curWord).add(curNode);
            int num = this.networkCounts.get(curWord);
            this.networkCounts.put(curWord, ++num);
            if (!lastWord.equals("")) {
                WordPair pair = new WordPair(lastWord, curWord, this);
                Integer curPairCount = this.networkPairCounts.get(pair);
                int count = curPairCount == null ? 1 : curPairCount;
                this.networkPairCounts.put(pair, count);
            }
            lastWord = curWord;
        }
    }

    private void updateSelectedCounts() {
        CyNetwork network = this.cloud.getNetworkParams().getNetwork();
        if (this.selInitialized || network == null) {
            return;
        }
        if (!this.countInitialized) {
            this.initializeNetworkCounts();
        }
        this.selectedCounts = new HashMap<String, Integer>();
        this.selectedPairCounts = new HashMap<WordPair, Integer>();
        Set<CyNode> selectedNodes = this.cloud.getSelectedNodes();
        for (String attributeName : this.cloud.getAttributeNames()) {
            for (CyNode curNode : selectedNodes) {
                String value = this.getNodeAttributeVal(network, curNode, attributeName);
                if (value == null) continue;
                this.updateSelectedWordCounts(curNode, value);
            }
        }
        this.calculateWeights();
        this.selInitialized = true;
    }

    private void updateSelectedWordCounts(CyNode curNode, String nodeValue) {
        if (nodeValue == null) {
            return;
        }
        Collection<String> wordSet = this.processNodeString(nodeValue);
        String lastWord = "";
        for (String curWord : wordSet) {
            WordFilter filter = this.cloud.getNetworkParams().getFilter();
            if (filter.contains(curWord)) continue;
            int curCount = 0;
            if (this.selectedCounts.containsKey(curWord)) {
                curCount = this.selectedCounts.get(curWord);
            }
            this.selectedCounts.put(curWord, ++curCount);
            if (!lastWord.equals("")) {
                WordPair pair = new WordPair(lastWord, curWord, this);
                Integer curPairCount = this.selectedPairCounts.get(pair);
                int count = curPairCount == null ? 1 : curPairCount;
                this.selectedPairCounts.put(pair, count);
            }
            lastWord = curWord;
        }
    }

    private void calculateWeights() {
        double curMin = 0.0;
        double curMax = 0.0;
        double total = 0.0;
        int count = 0;
        int selTotal = this.cloud.getSelectedNumNodes();
        boolean initialized = false;
        for (Map.Entry<String, Integer> entry : this.selectedCounts.entrySet()) {
            String curWord = entry.getKey();
            int selCount = entry.getValue();
            int netCount = this.networkCounts.get(curWord);
            double newNetCount = Math.pow(netCount, 0.0);
            int netTotal = this.cloud.getNetworkNumNodes();
            double newNetTotal = Math.pow(netTotal, 0.0);
            double numerator = (double)selCount * newNetTotal;
            double denominator = (double)selTotal * newNetCount;
            double ratio = numerator / denominator;
            total += ratio;
            ++count;
            if (!initialized) {
                curMax = ratio;
                curMin = ratio;
                initialized = true;
            }
            if (ratio > curMax) {
                curMax = ratio;
            }
            if (!(ratio < curMin)) continue;
            curMin = ratio;
        }
        this.minWeight = curMin;
        this.meanWeight = total / (double)count;
        this.maxWeight = curMax;
    }

    private void updateRatios() {
        double ratio;
        double denominator;
        double numerator;
        double newNetTotal;
        if (this.ratiosInitialized) {
            return;
        }
        if (!this.selInitialized) {
            this.updateSelectedCounts();
        }
        this.ratios = new HashMap<String, Double>();
        double curMin = 0.0;
        double curMax = 0.0;
        double total = 0.0;
        int count = 0;
        int selTotal = this.cloud.getSelectedNumNodes();
        boolean initialized = false;
        for (Map.Entry<String, Integer> entry : this.selectedCounts.entrySet()) {
            String curWord = entry.getKey();
            int selCount = entry.getValue();
            int netCount = this.networkCounts.get(curWord);
            double newNetCount = Math.pow(netCount, this.cloud.getNetWeightFactor());
            int netTotal = this.cloud.getNetworkNumNodes();
            newNetTotal = Math.pow(netTotal, this.cloud.getNetWeightFactor());
            numerator = (double)selCount * newNetTotal;
            denominator = (double)selTotal * newNetCount;
            ratio = numerator / denominator;
            this.ratios.put(curWord, ratio);
            total += ratio;
            ++count;
            if (!initialized) {
                curMax = ratio;
                curMin = ratio;
                initialized = true;
            }
            if (ratio > curMax) {
                curMax = ratio;
            }
            if (!(ratio < curMin)) continue;
            curMin = ratio;
        }
        this.maxRatio = curMax;
        this.minRatio = curMin;
        this.meanRatio = total / (double)count;
        this.pairRatios = new HashMap<WordPair, Double>();
        int netTotal = this.cloud.getNetworkNumNodes();
        for (Map.Entry<WordPair, Integer> entry : this.selectedPairCounts.entrySet()) {
            WordPair pair = entry.getKey();
            int selPairCount = entry.getValue();
            int netPairCount = this.networkPairCounts.get(pair);
            double newNetCount = Math.pow(netPairCount, this.cloud.getNetWeightFactor());
            newNetTotal = Math.pow(netTotal, this.cloud.getNetWeightFactor());
            numerator = (double)selPairCount * newNetTotal;
            denominator = (double)selTotal * newNetCount;
            ratio = numerator / denominator;
            this.pairRatios.put(pair, ratio);
        }
        this.ratiosInitialized = true;
    }

    public void calculateFontSizes() {
        if (!this.ratiosInitialized) {
            this.updateRatios();
        }
        this.cloudWords = new ArrayList<CloudWordInfo>();
        if (this.cloud.getDisplayStyle().equals((Object)CloudDisplayStyles.NO_CLUSTERING)) {
            for (Map.Entry<String, Double> entry : this.ratios.entrySet()) {
                String curWord = entry.getKey();
                int fontSize = this.calculateFontSize(curWord, entry.getValue());
                CloudWordInfo curInfo = new CloudWordInfo(this, curWord, fontSize);
                this.cloudWords.add(curInfo);
            }
            Collections.sort(this.cloudWords);
        } else {
            ClusterBuilder builder = new ClusterBuilder(this);
            builder.clusterData(this.cloud.getClusterCutoff());
            builder.buildCloudWords();
            this.cloudWords = builder.getCloudWords();
        }
    }

    public int calculateFontSize(String aWord, double ratio) {
        double zeroedMinWeight = this.minWeight - this.minWeight;
        double zeroedMeanWeight = this.meanWeight - this.minWeight;
        double zeroedMaxWeight = this.maxWeight - this.minWeight;
        double zeroedMinRatio = this.minRatio - this.minRatio;
        double zeroedMeanRatio = this.meanRatio - this.minRatio;
        double zeroedMaxRatio = this.maxRatio - this.minRatio;
        double zeroedRatio = ratio - this.minRatio;
        double newRatio = zeroedRatio * zeroedMeanWeight / zeroedMeanRatio;
        int maxFont = MAXFONTSIZE;
        int minFont = MINFONTSIZE;
        if (this.isCloseEnough(zeroedMaxRatio, zeroedMinRatio)) {
            return minFont + (maxFont - minFont) / 2;
        }
        double slope = (double)(maxFont - minFont) / (zeroedMaxWeight - zeroedMinWeight);
        double yIntercept = (double)maxFont - slope * zeroedMaxWeight;
        long temp = Math.round(slope * newRatio + yIntercept);
        int fontSize = Math.round(temp);
        return fontSize;
    }

    private boolean isCloseEnough(double d1, double d2) {
        double EPSILON = 1.0E-5;
        return Math.abs(d1 - d2) <= EPSILON * Math.max(Math.abs(d1), Math.abs(d2));
    }

    private String getNodeAttributeVal(CyNetwork network, CyNode curNode, String attributeName) {
        CyTable table = network.getDefaultNodeTable();
        CyColumn column = table.getColumn(attributeName);
        if (column == null) {
            return null;
        }
        if (column.getType().equals(String.class)) {
            return (String)table.getRow((Object)curNode.getSUID()).get(attributeName, String.class);
        }
        if (column.getType().equals(List.class) && column.getListElementType().equals(String.class)) {
            List list = table.getRow((Object)curNode.getSUID()).getList(attributeName, String.class);
            return list == null ? null : CloudInfo.join(" ", list);
        }
        return null;
    }

    private static String join(String delimiter, List<String> list) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = list.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next());
        }
        while (iter.hasNext()) {
            sb.append(delimiter).append(iter.next());
        }
        return sb.toString();
    }

    public int getCountTotal() {
        if (this.countTotal == 0) {
            Map<String, Integer> selectedCounts = this.getSelectedCounts();
            int total = 0;
            for (int x : selectedCounts.values()) {
                total += x;
            }
            this.countTotal = total;
        }
        return this.countTotal;
    }

    public String getCloudName() {
        return this.cloud.getCloudName();
    }

    public List<CloudWordInfo> getCloudWordInfoList() {
        return this.cloudWords;
    }

    public Map<String, Double> getRatios() {
        return this.ratios;
    }

    public Map<WordPair, Double> getPairRatios() {
        return this.pairRatios;
    }

    public Map<String, Integer> getSelectedCounts() {
        return this.selectedCounts;
    }

    public Map<WordPair, Integer> getSelectedPairCounts() {
        return this.selectedPairCounts;
    }

    public Map<String, Set<CyNode>> getStringNodeMapping() {
        return this.stringNodeMapping;
    }

    public double getMinRatio() {
        return this.minRatio;
    }

    public double getMaxRatio() {
        return this.maxRatio;
    }
}

