/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui.input;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.baderlab.wordcloud.internal.cluster.CloudDisplayStyles;
import org.baderlab.wordcloud.internal.model.CloudModelManager;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.model.CloudProvider;
import org.baderlab.wordcloud.internal.model.NetworkParameters;
import org.baderlab.wordcloud.internal.ui.IconManager;
import org.baderlab.wordcloud.internal.ui.IconManagerImpl;
import org.baderlab.wordcloud.internal.ui.UIManager;
import org.baderlab.wordcloud.internal.ui.action.CreateCloudAction;
import org.baderlab.wordcloud.internal.ui.action.DeleteCloudAction;
import org.baderlab.wordcloud.internal.ui.action.RenameCloudAction;
import org.baderlab.wordcloud.internal.ui.action.UpdateCloudAction;
import org.baderlab.wordcloud.internal.ui.input.CloudListMouseListener;
import org.baderlab.wordcloud.internal.ui.input.CollapsiblePanel;
import org.baderlab.wordcloud.internal.ui.input.SliderBarPanel;
import org.baderlab.wordcloud.internal.ui.input.WordSelectPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.CheckBoxJList;

public class SemanticSummaryInputPanel
extends JPanel {
    private static final int DEF_ROW_HEIGHT = 20;
    private final UIManager uiManager;
    private final CySwingApplication application;
    private final CyServiceRegistrar registrar;
    private final IconManager iconManager = new IconManagerImpl();
    private JFormattedTextField maxWordsTextField;
    private JFormattedTextField minOccurrenceField;
    private JFormattedTextField clusterCutoffTextField;
    private JComboBox<CloudDisplayStyles> cmbStyle;
    private JLabel networkLabel;
    private JList<String> cloudList;
    private JCheckBox stemmer;
    private SliderBarPanel sliderPanel;
    private CheckBoxJList attributeList;
    private JPopupMenu attributeSelectionPopupMenu;
    private JTextArea attNames;
    private JButton createButton;
    private JButton updateButton;
    private JCheckBox syncCheckBox;
    private JCheckBox filterNumsCheckBox;
    private JToggleButton sortButton;
    private ListSelectionListener cloudListSelectionListener;
    private ActionListener syncCheckboxActionListener;
    private ChangeListener networkUpdateListener;
    private Action createCloudAction;
    private final LiveUpdateListener liveUpdateListener = new LiveUpdateListener();

    public SemanticSummaryInputPanel(CyApplicationManager applicationManager, CySwingApplication application, final UIManager uiManager, CyServiceRegistrar registrar) {
        this.uiManager = uiManager;
        this.application = application;
        this.registrar = registrar;
        this.createCloudAction = new CreateCloudAction(applicationManager, application, uiManager.getCloudModelManager(), uiManager);
        this.createPanel();
        RowsSetListener nodeSelectionListener = new RowsSetListener(){

            public synchronized void handleEvent(RowsSetEvent e) {
                if (SemanticSummaryInputPanel.this.syncCheckBox.isSelected() && e.containsColumn("selected")) {
                    CloudParameters nullCloud = uiManager.getCurrentNetwork().getNullCloud();
                    new UpdateCloudAction(nullCloud, uiManager).actionPerformed(null);
                }
            }
        };
        registrar.registerService((Object)nodeSelectionListener, RowsSetListener.class, new Properties());
    }

    private void createPanel() {
        this.setLayout(new BorderLayout());
        JPanel cloudList = this.createCloudListPanel();
        JPanel optionsPanel = this.createOptionsPanel();
        JScrollPane optionsScroll = new JScrollPane(optionsPanel);
        optionsScroll.setHorizontalScrollBarPolicy(30);
        cloudList.setBorder(optionsScroll.getBorder());
        JSplitPane splitPane = new JSplitPane(0, cloudList, optionsScroll);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)splitPane, "Center");
        this.sliderPanel.getSlider().addChangeListener(this.liveUpdateListener);
        this.maxWordsTextField.getDocument().addDocumentListener(this.liveUpdateListener);
        this.minOccurrenceField.getDocument().addDocumentListener(this.liveUpdateListener);
        this.clusterCutoffTextField.getDocument().addDocumentListener(this.liveUpdateListener);
        this.cmbStyle.addActionListener(this.liveUpdateListener);
        this.networkUpdateListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SemanticSummaryInputPanel.this.uiManager.getCurrentNetwork().updateAllClouds();
                SemanticSummaryInputPanel.this.liveUpdateListener.update();
            }
        };
        this.stemmer.addChangeListener(this.networkUpdateListener);
        this.filterNumsCheckBox.addChangeListener(this.networkUpdateListener);
    }

    private JPanel createCloudListPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel networkPanel = new JPanel();
        networkPanel.setLayout(new BorderLayout());
        this.networkLabel = new JLabel();
        this.networkLabel.setHorizontalAlignment(0);
        networkPanel.add((Component)this.networkLabel, "Center");
        networkPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.sortButton = new JToggleButton();
        this.setIcon(this.sortButton, "\uf15d");
        this.sortButton.setToolTipText("Sort Alphabetically");
        networkPanel.add((Component)this.sortButton, "East");
        networkPanel.add(Box.createRigidArea(this.sortButton.getPreferredSize()), "West");
        this.sortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SemanticSummaryInputPanel.this.cloudList.removeListSelectionListener(SemanticSummaryInputPanel.this.cloudListSelectionListener);
                SemanticSummaryInputPanel.this.setCloudListModel();
                SemanticSummaryInputPanel.this.cloudList.addListSelectionListener(SemanticSummaryInputPanel.this.cloudListSelectionListener);
            }
        });
        this.cloudList = new JList(new DefaultListModel());
        this.cloudList.setSelectionMode(0);
        this.cloudList.setSelectedIndex(0);
        this.cloudList.setVisibleRowCount(10);
        this.cloudList.setFixedCellHeight(20);
        CloudProvider cloudListProvider = new CloudProvider(){

            @Override
            public CloudParameters getCloud() {
                String cloudName = (String)SemanticSummaryInputPanel.this.cloudList.getSelectedValue();
                return SemanticSummaryInputPanel.this.uiManager.getCurrentNetwork().getCloud(cloudName);
            }
        };
        this.cloudList.getInputMap().put(KeyStroke.getKeyStroke("F2"), "rename_cloud");
        this.cloudList.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete_cloud");
        this.cloudList.getActionMap().put("rename_cloud", (Action)((Object)new RenameCloudAction(cloudListProvider, this.application, this.uiManager)));
        this.cloudList.getActionMap().put("delete_cloud", (Action)((Object)new DeleteCloudAction(cloudListProvider, this.application)));
        this.cloudListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    String cloudName = (String)SemanticSummaryInputPanel.this.cloudList.getSelectedValue();
                    SemanticSummaryInputPanel.this.uiManager.setCurrentCloud(SemanticSummaryInputPanel.this.uiManager.getCurrentNetwork(), cloudName);
                }
            }
        };
        this.cloudList.addListSelectionListener(this.cloudListSelectionListener);
        JScrollPane listScrollPane = new JScrollPane(this.cloudList);
        listScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.syncCheckBox = new JCheckBox("Selected Nodes");
        this.syncCheckBox.setToolTipText("Synchronize the cloud display with the currently selected nodes.");
        this.syncCheckboxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SemanticSummaryInputPanel.this.syncCheckBox.isSelected()) {
                    CloudParameters nullCloud = SemanticSummaryInputPanel.this.uiManager.getCurrentNetwork().getNullCloud();
                    new UpdateCloudAction(nullCloud, SemanticSummaryInputPanel.this.uiManager).actionPerformed(null);
                    SemanticSummaryInputPanel.this.uiManager.setCurrentCloud(nullCloud);
                } else {
                    SemanticSummaryInputPanel.this.uiManager.setCurrentCloud(SemanticSummaryInputPanel.this.uiManager.getCurrentNetwork());
                }
            }
        };
        this.syncCheckBox.addActionListener(this.syncCheckboxActionListener);
        this.cloudList.addMouseListener(new CloudListMouseListener(this.uiManager, this.application, this.registrar, this.cloudList, this.syncCheckBox));
        this.createButton = new JButton();
        this.createButton.setAction(this.createCloudAction);
        this.setIcon(this.createButton, "\uf067");
        this.createButton.setToolTipText("Create a new cloud from the selected nodes.");
        this.updateButton = new JButton();
        this.updateButton.setAction((Action)((Object)new UpdateCloudAction(cloudListProvider, this.uiManager)));
        this.setIcon(this.updateButton, "\uf021");
        this.updateButton.setToolTipText("Update the current cloud to use the selected nodes.");
        JPanel createUpdatePanel = new JPanel(new FlowLayout(2, 2, 2));
        createUpdatePanel.add(this.updateButton);
        createUpdatePanel.add(this.createButton);
        JPanel syncPanel = new JPanel(new BorderLayout());
        syncPanel.add((Component)this.syncCheckBox, "West");
        syncPanel.add((Component)createUpdatePanel, "East");
        panel.add((Component)networkPanel, "North");
        panel.add((Component)listScrollPane, "Center");
        panel.add((Component)syncPanel, "South");
        return panel;
    }

    private void setIcon(AbstractButton button, String icon) {
        button.setFont(this.iconManager.getIconFont(11.0f));
        button.setText(icon);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setPreferredSize(new Dimension(24, 24));
    }

    private JPanel createOptionsPanel() {
        JPanel semAnalysis = this.createSemAnalysisPanel();
        JPanel cloudLayout = this.createCloudLayoutPanel();
        JPanel normalizationPanel = this.createNormalizationPanel();
        JPanel advancedSettings = this.createAdvancedSettingsPanel();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(semAnalysis);
        panel.add(Box.createVerticalStrut(3));
        panel.add(cloudLayout);
        panel.add(Box.createVerticalStrut(3));
        panel.add(normalizationPanel);
        panel.add(Box.createVerticalStrut(5));
        panel.add(advancedSettings);
        JPanel newPanel = new JPanel();
        newPanel.setLayout(new BorderLayout());
        newPanel.add((Component)panel, "North");
        return newPanel;
    }

    private JPanel createExcludedWordsPanel() {
        JPanel excludedWordsPanel = new JPanel();
        excludedWordsPanel.setLayout(new BoxLayout(excludedWordsPanel, 1));
        JButton excludedWordsButton = new JButton("Excluded Words...");
        excludedWordsButton.setToolTipText("Allows additional words to be excluded from the cloud");
        excludedWordsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkParameters network = SemanticSummaryInputPanel.this.uiManager.getCurrentNetwork();
                WordSelectPanel wordSelectPanel = new WordSelectPanel(network.getFilter());
                JDialog dialog = wordSelectPanel.createDialog(SemanticSummaryInputPanel.this.application.getJFrame(), network.getNetworkName());
                dialog.setVisible(true);
                network.updateAllClouds();
                SemanticSummaryInputPanel.this.liveUpdateListener.update();
            }
        });
        excludedWordsPanel.add(excludedWordsButton);
        JButton delimetersButton = new JButton("Delimiters...");
        delimetersButton.setToolTipText("Allows attributes containing delimeters to be split into individual words.");
        delimetersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkParameters network = SemanticSummaryInputPanel.this.uiManager.getCurrentNetwork();
                WordSelectPanel wordSelectPanel = new WordSelectPanel(network.getDelimeters());
                JDialog dialog = wordSelectPanel.createDialog(SemanticSummaryInputPanel.this.application.getJFrame(), network.getNetworkName());
                dialog.setVisible(true);
                network.updateAllClouds();
                SemanticSummaryInputPanel.this.liveUpdateListener.update();
            }
        });
        excludedWordsPanel.add(delimetersButton);
        return excludedWordsPanel;
    }

    private JPanel createSemAnalysisPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JPanel attributePanel = new JPanel();
        attributePanel.setLayout(new GridBagLayout());
        this.attributeList = new CheckBoxJList();
        this.attributeList.setModel(new DefaultListModel());
        this.attributeList.addPropertyChangeListener("LIST_UPDATED", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                SemanticSummaryInputPanel.this.updateAttNames();
                SemanticSummaryInputPanel.this.liveUpdateListener.update();
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(300, 200));
        scrollPane.setViewportView(this.createAttributePanel(this.attributeList));
        this.attributeSelectionPopupMenu = new JPopupMenu();
        this.attributeSelectionPopupMenu.add(scrollPane);
        JButton attributeButton = new JButton("Edit");
        attributeButton.setToolTipText("Edit nodes values to use for semantic analysis");
        attributeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SemanticSummaryInputPanel.this.refreshAttributeCMB();
                SemanticSummaryInputPanel.this.attributeSelectionPopupMenu.show(e.getComponent(), 0, e.getComponent().getPreferredSize().height);
            }
        });
        this.attNames = new JTextArea();
        this.attNames.setColumns(15);
        this.attNames.setRows(4);
        this.attNames.setEditable(false);
        JScrollPane attListPane = new JScrollPane();
        attListPane.setPreferredSize(this.attNames.getPreferredSize());
        attListPane.setViewportView(this.attNames);
        attListPane.setHorizontalScrollBarPolicy(31);
        attListPane.setVerticalScrollBarPolicy(22);
        JLabel attributeLabel = new JLabel("Current Values:");
        attributeLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        attributePanel.add((Component)attributeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
        attributePanel.add((Component)attributeButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
        attributePanel.add((Component)attListPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 512, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(attributePanel);
        return panel;
    }

    private Component createAttributePanel(final CheckBoxJList attributeList) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JButton selectAllButton = new JButton("Select all");
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListModel model = attributeList.getModel();
                ArrayList<String> items = new ArrayList<String>(model.getSize());
                for (int i = 0; i < model.getSize(); ++i) {
                    items.add((String)model.getElementAt(i));
                }
                attributeList.setSelectedItems(items);
                SemanticSummaryInputPanel.this.updateAttNames();
                SemanticSummaryInputPanel.this.liveUpdateListener.update();
            }
        });
        JButton deselectAllButton = new JButton("Deselect all");
        deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                attributeList.setSelectedItems(Collections.emptyList());
                SemanticSummaryInputPanel.this.updateAttNames();
                SemanticSummaryInputPanel.this.liveUpdateListener.update();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(selectAllButton);
        buttonPanel.add(deselectAllButton);
        panel.add((Component)buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)attributeList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 512, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel createNormalizationPanel() {
        this.sliderPanel = new SliderBarPanel(0.0, 1.0, " Normalize", 10);
        String tooltip = "<html>Determines how much weight to give the whole network when normalizing the selected nodes<br><b>Acceptable Values:</b> greater than or equal to 0 and less than or equal to 1</html>";
        this.sliderPanel.setToolTipText(tooltip);
        return this.sliderPanel;
    }

    private JPanel createAdvancedSettingsPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Advanced");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        intFormat.setParseIntegerOnly(true);
        JLabel maxWordsLabel = new JLabel("Max Number of Words");
        this.maxWordsTextField = new JFormattedTextField(intFormat);
        this.maxWordsTextField.setColumns(7);
        this.maxWordsTextField.setValue(40);
        this.maxWordsTextField.addPropertyChangeListener(new FormattedTextFieldAction());
        String tooltip = "<html>Sets a limit on the number of words to display in the cloud<br><b>Acceptable Values:</b> greater than or equal to 0</html>";
        this.maxWordsTextField.setToolTipText(tooltip);
        maxWordsLabel.setToolTipText(tooltip);
        JPanel maxWordsPanel = new JPanel();
        maxWordsPanel.setLayout(new BorderLayout());
        maxWordsPanel.add((Component)maxWordsLabel, "West");
        maxWordsPanel.add((Component)this.maxWordsTextField, "East");
        JLabel minOccurrenceLabel = new JLabel("Minimum Word Occurrence");
        this.minOccurrenceField = new JFormattedTextField(intFormat);
        this.minOccurrenceField.setColumns(7);
        this.minOccurrenceField.setValue(40);
        this.minOccurrenceField.addPropertyChangeListener(new FormattedTextFieldAction());
        tooltip = "<html>Sets a lower limit on the number of times a word must occur for it to be included in the cloud.<br><b>Acceptable Values:</b> greater than or equal to 0</html>";
        this.minOccurrenceField.setToolTipText(tooltip);
        minOccurrenceLabel.setToolTipText(tooltip);
        JPanel minOccurancePanel = new JPanel();
        minOccurancePanel.setLayout(new BorderLayout());
        minOccurancePanel.add((Component)minOccurrenceLabel, "West");
        minOccurancePanel.add((Component)this.minOccurrenceField, "East");
        JLabel clusterCutoffLabel = new JLabel("Word Aggregation Cutoff");
        DecimalFormat decFormat = new DecimalFormat();
        decFormat.setParseIntegerOnly(false);
        this.clusterCutoffTextField = new JFormattedTextField(decFormat);
        this.clusterCutoffTextField.setColumns(7);
        this.clusterCutoffTextField.setValue(20);
        this.clusterCutoffTextField.addPropertyChangeListener(new FormattedTextFieldAction());
        tooltip = "<html>Cutoff for placing two words in the same cluster - ratio of the observed joint probability of the words to their joint probability if the words appeared independently of each other<br><b>Acceptable Values:</b> greater than or equal to 0</html>";
        this.clusterCutoffTextField.setToolTipText(tooltip);
        clusterCutoffLabel.setToolTipText(tooltip);
        JPanel clusterCutoffPanel = new JPanel(new BorderLayout());
        clusterCutoffPanel.add((Component)clusterCutoffLabel, "West");
        clusterCutoffPanel.add((Component)this.clusterCutoffTextField, "East");
        JLabel networkLabel = new JLabel("Network Options");
        networkLabel.setToolTipText("Options below apply to all clouds in the network");
        JPanel networkLabelPanel = new JPanel(new BorderLayout());
        networkLabelPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        networkLabelPanel.add((Component)networkLabel, "West");
        this.stemmer = new JCheckBox("Enable Stemming");
        tooltip = "<html>Causes all words to be stemmed using the Porter Stemmer algorithm.<br><b>Notice:</b> This will allow words with a similar stem to map to the same word.<br>However, words stems may not be what you expect.</html>";
        this.stemmer.setToolTipText(tooltip);
        this.stemmer.setSelected(false);
        JPanel stemmingPanel = new JPanel(new BorderLayout());
        stemmingPanel.add((Component)this.stemmer, "West");
        this.filterNumsCheckBox = new JCheckBox("Exclude Numbers");
        this.filterNumsCheckBox.setSelected(false);
        this.filterNumsCheckBox.setToolTipText("Causes numbers to be excluded from the cloud.");
        JPanel filterNumsPanel = new JPanel(new BorderLayout());
        filterNumsPanel.add((Component)this.filterNumsCheckBox, "West");
        JPanel wordsPanel = new JPanel(new BorderLayout());
        wordsPanel.add((Component)this.createExcludedWordsPanel(), "West");
        panel.add(maxWordsPanel);
        panel.add(minOccurancePanel);
        panel.add(clusterCutoffPanel);
        panel.add(networkLabelPanel);
        panel.add(stemmingPanel);
        panel.add(filterNumsPanel);
        panel.add(wordsPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private JPanel createCloudLayoutPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JPanel cloudLayoutPanel = new JPanel();
        cloudLayoutPanel.setLayout(new GridBagLayout());
        JLabel cloudStyleLabel = new JLabel("Cloud Style: ");
        cloudStyleLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        DefaultComboBoxModel comboModel = new DefaultComboBoxModel();
        this.cmbStyle = new JComboBox(comboModel);
        this.cmbStyle.setEditable(false);
        Dimension d = this.cmbStyle.getPreferredSize();
        this.cmbStyle.setPreferredSize(new Dimension(15, d.height));
        StringBuffer toolTip = new StringBuffer();
        toolTip.append("<html>--Visual style for the cloud layout--<br>");
        toolTip.append("<b>Clustered:</b> If a style with clustering is selected, then the cloud will be comprised of groups of words.<br>");
        toolTip.append("Each cluster is build by analyzing which words appear next to each other and what order they appear.<br>");
        toolTip.append("<b> No Clustering:</b> When a non-clustering option is selected, words appear in decreasing order of of size.");
        this.cmbStyle.setToolTipText(toolTip.toString());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        cloudLayoutPanel.add((Component)cloudStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        cloudLayoutPanel.add(this.cmbStyle, gridBagConstraints);
        DefaultComboBoxModel cmb = (DefaultComboBoxModel)this.cmbStyle.getModel();
        cmb.removeAllElements();
        cmb.addElement(CloudDisplayStyles.CLUSTERED_STANDARD);
        cmb.addElement(CloudDisplayStyles.CLUSTERED_BOXES);
        cmb.addElement(CloudDisplayStyles.NO_CLUSTERING);
        this.cmbStyle.setSelectedItem((Object)CloudDisplayStyles.getDefault());
        this.cmbStyle.repaint();
        panel.add(cloudLayoutPanel);
        return panel;
    }

    private ListModel<String> setCloudListModel() {
        NetworkParameters networkParams = this.uiManager.getCurrentNetwork();
        List<CloudParameters> networkClouds = networkParams.getClouds();
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        if (this.sortButton.isSelected()) {
            ArrayList<String> list = new ArrayList<String>(networkClouds.size());
            for (CloudParameters cloud : networkClouds) {
                list.add(cloud.getCloudName());
            }
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1.compareToIgnoreCase(s2);
                }
            });
            for (String name : list) {
                listModel.addElement(name);
            }
        } else {
            for (CloudParameters cloud : networkClouds) {
                listModel.addElement(cloud.getCloudName());
            }
        }
        this.cloudList.setModel(listModel);
        String cloudName = this.uiManager.getCurrentCloud().getCloudName();
        int index = listModel.lastIndexOf(cloudName);
        this.cloudList.setSelectedIndex(index);
        return listModel;
    }

    public void setCurrentCloud(CloudParameters params) {
        this.cloudList.removeListSelectionListener(this.cloudListSelectionListener);
        this.syncCheckBox.removeActionListener(this.syncCheckboxActionListener);
        this.stemmer.removeChangeListener(this.networkUpdateListener);
        this.filterNumsCheckBox.removeChangeListener(this.networkUpdateListener);
        this.liveUpdateListener.enabled = false;
        this.setCloudListModel();
        this.networkLabel.setText(params.getNetworkParams().getNetworkName());
        this.syncCheckBox.setSelected(params.isNullCloud());
        this.updateButton.setEnabled(!params.isNullCloud());
        this.refreshAttributeCMB();
        List<String> attributeNames = params.getAttributeNames();
        this.setAttributeNames(attributeNames == null ? Collections.emptyList() : attributeNames);
        this.maxWordsTextField.setValue(params.getMaxWords());
        this.minOccurrenceField.setValue(params.getMinWordOccurrence());
        this.clusterCutoffTextField.setValue(params.getClusterCutoff());
        this.cmbStyle.setSelectedItem((Object)params.getDisplayStyle());
        this.setupNetworkNormalization(params);
        this.updateNetworkControls();
        this.liveUpdateListener.enabled = true;
        this.cloudList.addListSelectionListener(this.cloudListSelectionListener);
        this.syncCheckBox.addActionListener(this.syncCheckboxActionListener);
        this.stemmer.addChangeListener(this.networkUpdateListener);
        this.filterNumsCheckBox.addChangeListener(this.networkUpdateListener);
    }

    private void updateCloudParameters(CloudParameters cloud) {
        String message;
        cloud.setNetWeightFactor(this.sliderPanel.getNetNormValue());
        List attributes = this.attributeList.getSelectedValuesList();
        ArrayList<String> attributeNames = new ArrayList<String>(attributes.size());
        for (Object attribute : attributes) {
            attributeNames.add((String)attribute);
        }
        cloud.setAttributeNames(attributeNames);
        Number value = (Number)this.maxWordsTextField.getValue();
        if (value != null && value.intValue() >= 0) {
            cloud.setMaxWords(value.intValue());
        } else {
            this.maxWordsTextField.setValue(250);
            cloud.setMaxWords(250);
            message = "The maximum number of words to display must be greater than or equal to 0.";
            JOptionPane.showMessageDialog(this.application.getJFrame(), message, "Parameter out of bounds", 2);
        }
        value = (Number)this.minOccurrenceField.getValue();
        if (value != null && value.intValue() >= 0) {
            cloud.setMinWordOccurrence(value.intValue());
        } else {
            this.minOccurrenceField.setValue(1);
            cloud.setMinWordOccurrence(1);
            message = "Minimum word occurrences must be greater than or equal to 0.";
            JOptionPane.showMessageDialog(this.application.getJFrame(), message, "Parameter out of bounds", 2);
        }
        value = (Number)this.clusterCutoffTextField.getValue();
        if (value != null && value.doubleValue() >= 0.0) {
            cloud.setClusterCutoff(value.doubleValue());
        } else {
            this.clusterCutoffTextField.setValue(1.0);
            cloud.setClusterCutoff(1.0);
            message = "The cluster cutoff must be greater than or equal to 0";
            JOptionPane.showMessageDialog(this.application.getJFrame(), message, "Parameter out of bounds", 2);
        }
        Object style = this.cmbStyle.getSelectedItem();
        if (style instanceof CloudDisplayStyles) {
            cloud.setDisplayStyle((CloudDisplayStyles)((Object)style));
        } else {
            cloud.setDisplayStyle(CloudDisplayStyles.getDefault());
            this.cmbStyle.setSelectedItem((Object)CloudDisplayStyles.getDefault());
            String message2 = "You must select one of the available styles.";
            JOptionPane.showMessageDialog(this.application.getJFrame(), message2, "Parameter out of bounds", 2);
        }
        cloud.getNetworkParams().setIsStemming(this.stemmer.isSelected());
        cloud.getNetworkParams().getFilter().setFilterNums(this.filterNumsCheckBox.isSelected());
        cloud.invalidate();
    }

    private void setAttributeNames(List<String> names) {
        this.attributeList.setSelectedItems(names);
        this.updateAttNames();
    }

    public void updateNetworkName(String networkName) {
        this.networkLabel.setText(networkName);
    }

    private void updateNetworkControls() {
        NetworkParameters networkParams = this.uiManager.getCurrentNetwork();
        this.stemmer.setSelected(networkParams.getIsStemming());
        this.filterNumsCheckBox.setSelected(networkParams.getFilter().getFilterNums());
    }

    private void setupNetworkNormalization(CloudParameters params) {
        ChangeListener[] listeners = this.sliderPanel.getSlider().getChangeListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.sliderPanel.getSlider().removeChangeListener(listeners[i]);
        }
        double netWeightFactor = params.getNetWeightFactor();
        this.sliderPanel.setNetNormValue(netWeightFactor);
        this.sliderPanel.setLabel(this.sliderPanel.getSlider().getValue());
        for (int i = 0; i < listeners.length; ++i) {
            this.sliderPanel.getSlider().addChangeListener(listeners[i]);
        }
    }

    private void updateAttNames() {
        StringBuilder buffer = new StringBuilder();
        if (!this.attributeList.isSelectionEmpty()) {
            List names = this.attributeList.getSelectedValuesList();
            for (int i = 0; i < names.size(); ++i) {
                if (i > 0) {
                    buffer.append("\n");
                }
                buffer.append(names.get(i).toString());
            }
        }
        this.attNames.setText(buffer.toString());
    }

    private void updateCMBAttributes() {
        ListSelectionListener[] listeners = this.attributeList.getListSelectionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ListSelectionListener curListener = listeners[i];
            this.attributeList.removeListSelectionListener(curListener);
        }
        DefaultListModel listModel = (DefaultListModel)this.attributeList.getModel();
        listModel.removeAllElements();
        CyNetwork network = this.uiManager.getCurrentNetwork().getNetwork();
        if (network != null) {
            for (String name : CloudModelManager.getColumnNames(network, CyNode.class)) {
                listModel.addElement(name);
            }
        }
        for (int i = 0; i < listeners.length; ++i) {
            ListSelectionListener curListener = listeners[i];
            this.attributeList.addListSelectionListener(curListener);
        }
    }

    private void refreshAttributeCMB() {
        this.updateCMBAttributes();
        CloudParameters curCloud = this.uiManager.getCurrentCloud();
        if (curCloud != null) {
            List<String> curAttList = curCloud.getAttributeNames();
            if (curAttList == null) {
                curAttList = CloudModelManager.getColumnNames(curCloud.getNetworkParams().getNetwork(), CyNode.class);
            }
            this.attributeList.setSelectedItems(curAttList);
            this.attributeList.repaint();
        }
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Number value;
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            String message = "The value you have entered is invalid. \n";
            boolean invalid = false;
            if (source == SemanticSummaryInputPanel.this.maxWordsTextField) {
                Number value2 = (Number)SemanticSummaryInputPanel.this.maxWordsTextField.getValue();
                if (value2 == null || value2.intValue() < 0) {
                    SemanticSummaryInputPanel.this.maxWordsTextField.setValue(250);
                    message = message + "The maximum number of words to display must be greater than or equal to 0.";
                    invalid = true;
                }
            } else if (source == SemanticSummaryInputPanel.this.minOccurrenceField) {
                Number value3 = (Number)SemanticSummaryInputPanel.this.minOccurrenceField.getValue();
                if (value3 == null || value3.intValue() < 0) {
                    SemanticSummaryInputPanel.this.minOccurrenceField.setValue(1);
                    message = message + "Minimum word occurrences must be greater than or equal to 0.";
                    invalid = true;
                }
            } else if (!(source != SemanticSummaryInputPanel.this.clusterCutoffTextField || (value = (Number)SemanticSummaryInputPanel.this.clusterCutoffTextField.getValue()) != null && value.doubleValue() >= 0.0)) {
                SemanticSummaryInputPanel.this.clusterCutoffTextField.setValue(1.0);
                message = message + "The cluster cutoff must be greater than or equal to 0";
                invalid = true;
            }
            if (invalid) {
                JOptionPane.showMessageDialog(SemanticSummaryInputPanel.this.application.getJFrame(), message, "Parameter out of bounds", 2);
            }
        }
    }

    private class LiveUpdateListener
    extends AbstractAction
    implements ChangeListener,
    PropertyChangeListener,
    DocumentListener {
        boolean enabled;

        private LiveUpdateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.update();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.update();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        void update() {
            CloudParameters cloud;
            if (this.enabled && (cloud = SemanticSummaryInputPanel.this.uiManager.getCurrentCloud()) != null) {
                SemanticSummaryInputPanel.this.updateCloudParameters(cloud);
                SemanticSummaryInputPanel.this.uiManager.getCloudDisplayPanel().updateCloudDisplay(cloud);
            }
        }
    }
}

