/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui.cloud;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.baderlab.wordcloud.internal.SelectionUtils;
import org.baderlab.wordcloud.internal.cluster.CloudDisplayStyles;
import org.baderlab.wordcloud.internal.cluster.CloudInfo;
import org.baderlab.wordcloud.internal.cluster.CloudWordInfo;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.ui.CloudTaskManager;
import org.baderlab.wordcloud.internal.ui.DualPanelDocker;
import org.baderlab.wordcloud.internal.ui.UIManager;
import org.baderlab.wordcloud.internal.ui.cloud.ModifiedClusterFlowLayout;
import org.baderlab.wordcloud.internal.ui.cloud.ModifiedFlowLayout;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class CloudDisplayPanel
extends JPanel
implements CytoPanelComponent {
    private static final long serialVersionUID = 5996569544692738989L;
    private JPanel tagCloudFlowPanel;
    private JScrollPane cloudScroll;
    private JRootPane rootPane;
    private JPanel loadingPanel;
    private final CloudTaskManager cloudTaskManager;
    private final UIManager uiManager;

    public CloudDisplayPanel(UIManager uiManager, CloudTaskManager cloudTaskManager) {
        this.uiManager = uiManager;
        this.cloudTaskManager = cloudTaskManager;
        this.setLayout(new BorderLayout());
        this.tagCloudFlowPanel = this.initializeTagCloud();
        this.cloudScroll = new JScrollPane(this.tagCloudFlowPanel);
        this.cloudScroll.setHorizontalScrollBarPolicy(31);
        this.cloudScroll.setBorder(BorderFactory.createEmptyBorder());
        this.cloudScroll.setBackground(this.getBackground());
        this.rootPane = new JRootPane();
        this.rootPane.getContentPane().setLayout(new BorderLayout());
        this.rootPane.getContentPane().add((Component)this.cloudScroll, "Center");
        this.rootPane.setBackground(this.getBackground());
        this.add((Component)this.rootPane, "Center");
    }

    public void setDocker(final DualPanelDocker docker) {
        final JButton dockButton = new JButton("Undock");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        buttonPanel.add(dockButton);
        buttonPanel.setOpaque(false);
        Object prop = javax.swing.UIManager.get("ScrollBar.width");
        int scrollWidth = prop instanceof Number ? ((Number)prop).intValue() : 15;
        buttonPanel.add(Box.createRigidArea(new Dimension(scrollWidth, 0)));
        JPanel glassPane = (JPanel)this.rootPane.getGlassPane();
        glassPane.setLayout(new BorderLayout());
        glassPane.setVisible(true);
        glassPane.add((Component)buttonPanel, "South");
        this.loadingPanel = new JPanel(new BorderLayout());
        this.loadingPanel.setOpaque(false);
        glassPane.add((Component)this.loadingPanel, "North");
        dockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                docker.flip();
            }
        });
        docker.setCallback(new DualPanelDocker.DockCallback(){

            @Override
            public void undocked() {
                dockButton.setText("Dock");
            }

            @Override
            public void docked() {
                dockButton.setText("Undock");
            }
        });
    }

    private JPanel initializeTagCloud() {
        JPanel panel = new JPanel(new ModifiedFlowLayout(1, 30, 25));
        return panel;
    }

    private void clearCloud() {
        this.tagCloudFlowPanel.removeAll();
        this.tagCloudFlowPanel.setLayout(new ModifiedFlowLayout(1, 30, 25));
        this.tagCloudFlowPanel.revalidate();
        this.cloudScroll.revalidate();
        this.tagCloudFlowPanel.updateUI();
    }

    public void updateCloudDisplay(CloudParameters params) {
        if (!params.isAlreadyCalculated() && !params.getNetworkParams().isNullNetwork()) {
            String loading = params.isNullCloud() ? " Loading..." : " Loading " + params.getCloudName() + "...";
            JLabel label = new JLabel(loading);
            label.setOpaque(true);
            this.loadingPanel.add((Component)label, "Center");
        }
        this.cloudTaskManager.submit(params, new CloudTaskManager.Callback(){

            @Override
            public void onFinish(CloudInfo cloudInfo) {
                if (cloudInfo != null && cloudInfo.isForCloud(CloudDisplayPanel.this.uiManager.getCurrentCloud())) {
                    CloudDisplayPanel.this.displayCloud(cloudInfo);
                }
            }
        });
    }

    private synchronized void displayCloud(CloudInfo cloudInfo) {
        this.loadingPanel.removeAll();
        this.clearCloud();
        ArrayList<CloudWordInfo> copy = new ArrayList<CloudWordInfo>();
        List<CloudWordInfo> original = cloudInfo.getCloudWordInfoList();
        for (int i = 0; i < original.size(); ++i) {
            CloudWordInfo curInfo = original.get(i);
            copy.add(curInfo);
        }
        Collections.sort(copy);
        int max = cloudInfo.getMaxWords();
        int numWords = copy.size();
        if (max < numWords) {
            copy.subList(max, numWords).clear();
        }
        int count = 0;
        HashMap<Integer, JPanel> clusters = new HashMap<Integer, JPanel>();
        List<CloudWordInfo> wordInfo = cloudInfo.getCloudWordInfoList();
        Iterator<CloudWordInfo> iter = wordInfo.iterator();
        while (iter.hasNext() && count < cloudInfo.getMaxWords()) {
            JPanel curPanel;
            CloudWordInfo curWordInfo = iter.next();
            if (!copy.contains(curWordInfo)) continue;
            int minOccurrence = cloudInfo.getMinWordOccurrence();
            if (cloudInfo.getSelectedCounts().get(curWordInfo.getWord()) < minOccurrence) continue;
            Integer clusterNum = curWordInfo.getCluster();
            JLabel curLabel = this.createLabel(curWordInfo);
            if (clusters.containsKey(clusterNum)) {
                curPanel = (JPanel)clusters.get(clusterNum);
            } else {
                if (cloudInfo.getDisplayStyle().equals((Object)CloudDisplayStyles.NO_CLUSTERING)) {
                    curPanel = this.tagCloudFlowPanel;
                    curPanel.setLayout(new ModifiedFlowLayout(1, 10, 0));
                } else {
                    curPanel = new JPanel(new ModifiedClusterFlowLayout(1, 10, 0));
                }
                if (cloudInfo.getDisplayStyle().equals((Object)CloudDisplayStyles.CLUSTERED_BOXES)) {
                    curPanel.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY), new EmptyBorder(10, 10, 10, 10)));
                }
            }
            curPanel.add(curLabel);
            clusters.put(clusterNum, curPanel);
            ++count;
        }
        TreeSet sortedSet = new TreeSet(clusters.keySet());
        for (Integer clusterNum : sortedSet) {
            JPanel curPanel = (JPanel)clusters.get(clusterNum);
            if (curPanel.equals(this.tagCloudFlowPanel)) continue;
            this.tagCloudFlowPanel.add(curPanel);
        }
        this.tagCloudFlowPanel.revalidate();
        this.revalidate();
        this.updateUI();
        this.repaint();
    }

    private JLabel createLabel(final CloudWordInfo info) {
        JLabel label = info.createCloudLabel();
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                JLabel clickedLabel = (JLabel)me.getComponent();
                String word = clickedLabel.getText();
                Set<CyNode> nodes = info.getCloudInfo().getStringNodeMapping().get(word);
                CyNetwork network = info.getCloudInfo().getNetwork();
                if (network == null) {
                    return;
                }
                SelectionUtils.setColumns(network.getDefaultNodeTable(), "selected", Boolean.FALSE);
                SelectionUtils.setColumns(network.getDefaultEdgeTable(), "selected", Boolean.FALSE);
                SelectionUtils.setColumns(network, nodes, "selected", Boolean.TRUE);
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                JLabel clickedLabel = (JLabel)me.getComponent();
                clickedLabel.setForeground(new Color(0, 200, 255));
                clickedLabel.repaint();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                JLabel clickedLabel = (JLabel)me.getComponent();
                clickedLabel.setForeground(info.getTextColor());
                clickedLabel.repaint();
            }
        });
        return label;
    }

    public RenderedImage createImage() {
        Dimension d = this.tagCloudFlowPanel.getSize();
        BufferedImage image = new BufferedImage(d.width, d.height, 1);
        Graphics2D g2d = image.createGraphics();
        this.tagCloudFlowPanel.paint(g2d);
        g2d.dispose();
        return image;
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.SOUTH;
    }

    public Icon getIcon() {
        return null;
    }

    public String getTitle() {
        return "WordCloud Display";
    }
}

