/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui;

import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.baderlab.wordcloud.internal.cluster.CloudInfo;
import org.baderlab.wordcloud.internal.model.CloudParameters;

public class CloudTaskManager {
    private final WeakHashMap<CloudParameters, Object> locks = new WeakHashMap();
    private final ExecutorService executor = Executors.newCachedThreadPool();

    private synchronized Object getLock(CloudParameters cloudParams) {
        Object lock = this.locks.get(cloudParams);
        if (lock == null) {
            lock = new Object();
            this.locks.put(cloudParams, lock);
        }
        return lock;
    }

    public synchronized void disposeAll() {
        this.executor.shutdown();
        this.locks.clear();
    }

    public void submit(final CloudParameters cloudParams, final Callback callback) {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CloudInfo cloudInfo;
                Object object = CloudTaskManager.this.getLock(cloudParams);
                synchronized (object) {
                    cloudInfo = cloudParams.calculateCloud();
                }
                if (callback != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            callback.onFinish(cloudInfo);
                        }
                    });
                }
            }
        };
        this.executor.submit(task);
    }

    public static interface Callback {
        public void onFinish(CloudInfo var1);
    }
}

