/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.baderlab.wordcloud.internal.IoUtil;
import org.baderlab.wordcloud.internal.model.CloudBuilder;
import org.baderlab.wordcloud.internal.model.CloudModelManager;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.model.WordDelimiters;
import org.baderlab.wordcloud.internal.model.WordFilter;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;

public class NetworkParameters {
    private final CloudModelManager parent;
    private final CyNetwork network;
    private Map<String, CloudParameters> clouds = new HashMap<String, CloudParameters>();
    private CloudParameters nullCloud;
    protected static final String CLOUDNAME = "Cloud";
    protected static final String SEPARATER = "_";
    protected static final int NULL_COUNT = -99;
    protected static final String NULL_NAME = "wordcloud.sync";
    private WordFilter filter;
    private WordDelimiters delimiters;

    protected NetworkParameters(CloudModelManager parent, CyNetwork network) {
        this.parent = parent;
        this.network = network;
        this.delimiters = new WordDelimiters();
        StreamUtil streamUtil = parent.getStreamUtil();
        this.filter = new WordFilter(new IoUtil(streamUtil));
        if (network != null) {
            parent.initializeCloudMetadata(network);
        }
    }

    public List<CloudParameters> getClouds() {
        ArrayList<CloudParameters> result = new ArrayList<CloudParameters>(this.clouds.values());
        Collections.sort(result);
        return result;
    }

    public void updateAllClouds() {
        for (CloudParameters cloud : this.clouds.values()) {
            cloud.invalidate();
        }
    }

    public CloudParameters getCloud(String cloudName) {
        return this.clouds.get(cloudName);
    }

    public CloudParameters getFirstCloud() {
        List<CloudParameters> list = this.getClouds();
        return list.isEmpty() ? null : list.get(0);
    }

    public CloudBuilder getCloudBuilder() {
        if (this.isNullNetwork()) {
            throw new IllegalStateException("Cannot create a cloud for a null network");
        }
        CloudBuilder builder = new CloudBuilder(this);
        return builder;
    }

    public synchronized CloudParameters getNullCloud() {
        if (this.nullCloud == null) {
            List<Object> attributes = this.isNullNetwork() ? Collections.emptyList() : CloudModelManager.getColumnNames(this.network, CyNode.class);
            this.nullCloud = new CloudParameters(this, NULL_NAME, -99);
            this.nullCloud.setSelectedNodes(Collections.emptySet());
            this.nullCloud.setAttributeNames(attributes);
        }
        return this.nullCloud;
    }

    public boolean isNullNetwork() {
        return this == this.parent.getNullNetwork();
    }

    protected CloudParameters createCloud(CloudBuilder builder) {
        if (this.isNullNetwork()) {
            throw new IllegalStateException("Cannot create a cloud for a null network");
        }
        String cloudName = builder.getName();
        if (cloudName == null) {
            cloudName = this.getNextCloudName();
        } else {
            if (this.clouds.containsKey(cloudName)) {
                throw new IllegalArgumentException("Cloud name already in use: " + cloudName);
            }
            if (this.columnAlreadyExists(cloudName)) {
                throw new IllegalArgumentException("Column name already in use: " + cloudName);
            }
        }
        CloudParameters cloudParams = new CloudParameters(this, cloudName, this.getCloudCount());
        cloudParams.setSelectedNodes(builder.getNodes());
        cloudParams.setAttributeNames(builder.getAttributeNames());
        cloudParams.setDisplayStyle(builder.getDisplayStyle());
        cloudParams.setMaxWords(builder.getMaxWords());
        cloudParams.setClusterCutoff(builder.getClusterCutoff());
        cloudParams.setNetWeightFactor(builder.getNetWeightFactor());
        cloudParams.setMinWordOccurrence(builder.getMinWordOccurrence());
        cloudParams.setClusterColumnName(builder.getClusterColumnName());
        cloudParams.setClusterTable(builder.getClusterTable());
        this.incrementCloudCounter();
        this.clouds.put(cloudParams.getCloudName(), cloudParams);
        this.parent.fireCloudAdded(cloudParams);
        return cloudParams;
    }

    public CloudParameters createCloudFromProperties(String propFile) {
        CloudParameters cloudParams = new CloudParameters(this, propFile);
        this.clouds.put(cloudParams.getCloudName(), cloudParams);
        return cloudParams;
    }

    protected void removeCloudMapping(CloudParameters cloud) {
        this.clouds.remove(cloud.getCloudName());
    }

    protected void changeCloudMapping(String oldName, String newName) {
        this.clouds.put(newName, this.clouds.remove(oldName));
    }

    private int getCloudCount() {
        if (this.network == null) {
            return 0;
        }
        Integer count = (Integer)this.network.getRow((CyIdentifiable)this.network).get("Cloud Counter", Integer.class);
        return count == null ? 0 : count;
    }

    public boolean containsCloud(String name) {
        return this.clouds.containsKey(name);
    }

    private void incrementCloudCounter() {
        int count = this.getCloudCount();
        this.network.getRow((CyIdentifiable)this.network).set("Cloud Counter", (Object)(count + 1));
    }

    private String getNextCloudName() {
        while (true) {
            int cloudCount = this.getCloudCount();
            String name = "Cloud_" + cloudCount;
            if (!this.columnAlreadyExists(name)) {
                return name;
            }
            this.incrementCloudCounter();
        }
    }

    protected boolean columnAlreadyExists(String name) {
        CyTable defaultTable = this.network.getDefaultNodeTable();
        CyTable localTable = this.network.getTable(CyNode.class, "LOCAL_ATTRS");
        return defaultTable.getColumn(name) != null && localTable.getColumn(name) != null;
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public CloudModelManager getManager() {
        return this.parent;
    }

    public void setFilter(WordFilter filter) {
        this.filter = filter;
    }

    public WordFilter getFilter() {
        return this.filter;
    }

    public void setDelimeters(WordDelimiters delimiters) {
        this.delimiters = delimiters;
    }

    public WordDelimiters getDelimeters() {
        return this.delimiters;
    }

    public boolean getIsStemming() {
        if (this.network == null) {
            return false;
        }
        return (Boolean)this.network.getRow((CyIdentifiable)this.network).get("Use Stemming", Boolean.class);
    }

    public void setIsStemming(boolean val) {
        if (this.network != null) {
            this.network.getRow((CyIdentifiable)this.network).set("Use Stemming", (Object)val);
        }
    }

    public String getNetworkName() {
        if (this.network == null) {
            return "No Network Loaded";
        }
        return (String)this.network.getRow((CyIdentifiable)this.network).get("name", String.class);
    }
}

