/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.baderlab.wordcloud.internal.cluster.CloudDisplayStyles;
import org.baderlab.wordcloud.internal.cluster.CloudInfo;
import org.baderlab.wordcloud.internal.model.CloudModelManager;
import org.baderlab.wordcloud.internal.model.CloudProvider;
import org.baderlab.wordcloud.internal.model.NetworkParameters;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;

public class CloudParameters
implements Comparable<CloudParameters>,
CloudProvider {
    public static final double DEFAULT_NET_WEIGHT = 0.0;
    public static final String DEFAULT_ATT_NAME = "name";
    public static final int DEFAULT_MAX_WORDS = 250;
    public static final double DEFAULT_CLUSTER_CUTOFF = 1.0;
    public static final int DEFAULT_MIN_OCCURRENCE = 1;
    private final NetworkParameters networkParams;
    private CloudInfo cloudWordInfoBuilder;
    private boolean calculated = false;
    private String cloudName;
    private List<String> attributeNames;
    private CloudDisplayStyles displayStyle;
    private int cloudNum;
    private int maxWords = 250;
    private double clusterCutoff = 1.0;
    private double netWeightFactor = 0.0;
    private int minWordOccurrence = 1;
    private String clusterColumnName;
    private CyTable clusterTable;
    private static final String WORDDELIMITER = "CloudParamWordDelimiter";
    private int networkCount = 1;
    private static final String NETWORKNAME = "Net";
    private static final String SEPARATER = "_";

    protected CloudParameters(NetworkParameters networkParams, String cloudName, int cloudNum) {
        if (cloudName == null) {
            throw new NullPointerException();
        }
        this.networkParams = networkParams;
        this.displayStyle = CloudDisplayStyles.getDefault();
        this.cloudNum = cloudNum;
        this.cloudName = cloudName;
        this.createColumn(cloudName);
    }

    public void invalidate() {
        this.calculated = false;
        this.cloudWordInfoBuilder = null;
    }

    public synchronized CloudInfo calculateCloud() {
        if (this.cloudWordInfoBuilder == null) {
            this.cloudWordInfoBuilder = new CloudInfo(this);
            this.cloudWordInfoBuilder.calculateFontSizes();
            this.calculated = true;
        }
        return this.cloudWordInfoBuilder;
    }

    public boolean isAlreadyCalculated() {
        return this.calculated;
    }

    protected CloudParameters(NetworkParameters networkParams, String propFile) {
        this.networkParams = networkParams;
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length != 2) continue;
            props.put(tokens[0], tokens[1]);
        }
        this.cloudName = (String)props.get("CloudName");
        this.displayStyle = CloudDisplayStyles.fromString((String)props.get("DisplayStyle"));
        this.netWeightFactor = Double.valueOf((String)props.get("NetWeightFactor"));
        this.clusterCutoff = Double.valueOf((String)props.get("ClusterCutoff"));
        this.cloudNum = Integer.valueOf((String)props.get("CloudNum"));
        if (props.get("MaxWords") != null) {
            this.maxWords = Integer.valueOf((String)props.get("MaxWords"));
        }
        if (props.get("MinOccurrence") != null) {
            this.minWordOccurrence = Integer.valueOf((String)props.get("MinOccurrence"));
        }
        for (CyTable table : networkParams.getManager().getTableManager().getAllTables(true)) {
            if (!table.getTitle().equals(props.get("ClusterTableName"))) continue;
            this.clusterTable = table;
        }
        String value = (String)props.get("AttributeName");
        String[] attributes = value.split(WORDDELIMITER);
        ArrayList<String> attributeList = new ArrayList<String>();
        for (int i = 0; i < attributes.length; ++i) {
            String curAttribute = attributes[i];
            attributeList.add(curAttribute);
        }
        this.attributeNames = attributeList;
    }

    private void createColumn(String name) {
        CyNetwork network = this.networkParams.getNetwork();
        if (network == null) {
            return;
        }
        CyTable table = network.getTable(CyNode.class, "LOCAL_ATTRS");
        if (table.getColumn(name) == null) {
            table.createColumn(name, Boolean.class, false);
        }
    }

    public boolean isNullCloud() {
        return this == this.networkParams.getNullCloud();
    }

    public void delete() {
        CyTable clusterTable;
        CyTable localTable;
        if (!this.networkParams.getClouds().contains(this)) {
            return;
        }
        CyNetwork network = this.networkParams.getNetwork();
        CyTable defaultNodeTable = network.getDefaultNodeTable();
        if (defaultNodeTable.getColumn(this.cloudName) != null) {
            defaultNodeTable.deleteColumn(this.cloudName);
        }
        if ((localTable = network.getTable(CyNode.class, "LOCAL_ATTRS")).getColumn(this.cloudName) != null) {
            localTable.deleteColumn(this.cloudName);
        }
        if ((clusterTable = this.getClusterTable()) != null) {
            clusterTable.deleteRows(Arrays.asList(this.cloudName));
            if (clusterTable.getRowCount() == 0) {
                network.getDefaultNetworkTable().deleteColumn(clusterTable.getTitle());
                this.networkParams.getManager().getTableManager().deleteTable(clusterTable.getSUID().longValue());
            }
        }
        CloudModelManager cloudModelManager = this.networkParams.getManager();
        this.networkParams.removeCloudMapping(this);
        cloudModelManager.fireCloudDeleted(this);
    }

    public void rename(String newName) {
        if (newName.equals(this.cloudName)) {
            return;
        }
        if (this.networkParams.containsCloud(newName)) {
            throw new IllegalArgumentException("Name '" + newName + "' already exists");
        }
        if (this.networkParams.columnAlreadyExists(newName)) {
            throw new IllegalArgumentException("Column '" + newName + "' already exists");
        }
        String oldName = this.cloudName;
        this.cloudName = newName;
        this.networkParams.changeCloudMapping(oldName, newName);
        CyNetwork network = this.networkParams.getNetwork();
        CyTable defaultNodeTable = network.getDefaultNodeTable();
        CyColumn column = defaultNodeTable.getColumn(oldName);
        if (column == null) {
            CyTable localTable = network.getTable(CyNode.class, "LOCAL_ATTRS");
            column = localTable.getColumn(oldName);
        }
        column.setName(newName);
        CloudModelManager cloudModelManager = this.networkParams.getManager();
        cloudModelManager.fireCloudModified(this);
    }

    public String toString() {
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append("CloudName\t" + this.cloudName + "\n");
        paramVariables.append("DisplayStyle\t" + (Object)((Object)this.displayStyle) + "\n");
        StringBuffer output = new StringBuffer();
        if (this.attributeNames != null) {
            for (int i = 0; i < this.attributeNames.size(); ++i) {
                output.append(this.attributeNames.get(i) + WORDDELIMITER);
            }
        }
        paramVariables.append("AttributeName\t" + output.toString() + "\n");
        paramVariables.append("NetWeightFactor\t" + this.netWeightFactor + "\n");
        paramVariables.append("ClusterCutoff\t" + this.clusterCutoff + "\n");
        paramVariables.append("CountInitialized\tfalse\n");
        paramVariables.append("SelInitialized\tfalse\n");
        paramVariables.append("RatiosInitialized\tfalse\n");
        paramVariables.append("MinRatio\t0.0\n");
        paramVariables.append("MaxRatio\t0.0\n");
        paramVariables.append("MaxWords\t" + this.maxWords + "\n");
        paramVariables.append("MeanRatio\t0.0\n");
        paramVariables.append("MeanWeight\t0.0\n");
        paramVariables.append("MaxWeight\t0.0\n");
        paramVariables.append("MinWeight\t0.0\n");
        paramVariables.append("CloudNum\t" + this.cloudNum + "\n");
        paramVariables.append("UseNetNormal\ttrue\n");
        paramVariables.append("NetworkCount\t" + this.networkCount + "\n");
        if (this.clusterTable != null) {
            paramVariables.append("ClusterTableName\t" + this.clusterTable.getTitle() + "\n");
        }
        paramVariables.append("MinOccurrence\t" + this.minWordOccurrence + "\n");
        StringBuffer output2 = new StringBuffer();
        paramVariables.append("CloudWords\t" + output2.toString() + "\n");
        return paramVariables.toString();
    }

    @Override
    public int compareTo(CloudParameters other) {
        return this.cloudNum - other.cloudNum;
    }

    public String getNextNetworkName() {
        String name = this.networkParams.getNetworkName() + "-" + this.cloudName + "-" + NETWORKNAME + SEPARATER + this.networkCount;
        ++this.networkCount;
        return name;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(List<String> names) {
        boolean changed = false;
        if (this.attributeNames == null || names.size() != this.attributeNames.size()) {
            changed = true;
        } else {
            for (int i = 0; i < names.size(); ++i) {
                String curAttribute = names.get(i);
                if (this.attributeNames.contains(curAttribute)) continue;
                changed = true;
            }
        }
        if (changed) {
            this.invalidate();
        }
        this.attributeNames = names;
    }

    public void addAttributeName(String name) {
        if (this.attributeNames == null) {
            this.attributeNames = new ArrayList<String>();
        }
        if (!this.attributeNames.contains(name)) {
            this.attributeNames.add(name);
            this.invalidate();
        }
    }

    public void removeAttribtueName(String name) {
        boolean removed;
        if (this.attributeNames != null && (removed = this.attributeNames.remove(name))) {
            this.invalidate();
        }
    }

    public NetworkParameters getNetworkParams() {
        return this.networkParams;
    }

    public Set<CyNode> getSelectedNodes() {
        return this.getSelectedNodes(this.networkParams.getNetwork());
    }

    private Set<CyNode> getSelectedNodes(CyNetwork network) {
        if (network == null) {
            return Collections.emptySet();
        }
        HashSet<CyNode> nodes = new HashSet<CyNode>();
        for (CyNode node : network.getNodeList()) {
            CyRow row = network.getRow((CyIdentifiable)node);
            Boolean selected = (Boolean)row.get(this.cloudName, Boolean.class);
            if (selected == null || !selected.booleanValue()) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public void setSelectedNodes(Collection<CyNode> nodes) {
        this.setSelectedNodes(this.networkParams.getNetwork(), nodes);
        this.invalidate();
    }

    private void setSelectedNodes(CyNetwork network, Collection<CyNode> nodes) {
        if (network == null) {
            return;
        }
        if (network.getDefaultNodeTable().getColumn(this.cloudName) == null) {
            return;
        }
        for (CyNode node : network.getNodeList()) {
            CyRow row = network.getRow((CyIdentifiable)node);
            Boolean wasSelected = (Boolean)row.get(this.cloudName, Boolean.class);
            if (wasSelected == null) {
                wasSelected = Boolean.FALSE;
            }
            boolean selected = nodes.contains(node);
            if (wasSelected == selected) continue;
            row.set(this.cloudName, (Object)selected);
        }
    }

    public int getSelectedNumNodes() {
        return this.getSelectedNumNodes(this.networkParams.getNetwork());
    }

    private int getSelectedNumNodes(CyNetwork network) {
        if (network == null) {
            return 0;
        }
        return this.getSelectedNodes(network).size();
    }

    public int getNetworkNumNodes() {
        if (this.networkParams == null) {
            return 0;
        }
        CyNetwork network = this.networkParams.getNetwork();
        if (network == null) {
            return 0;
        }
        return network.getNodeCount();
    }

    public double getMinRatio() {
        return this.cloudWordInfoBuilder.getMinRatio();
    }

    public double getMaxRatio() {
        return this.cloudWordInfoBuilder.getMaxRatio();
    }

    public double getNetWeightFactor() {
        return this.netWeightFactor;
    }

    public void setNetWeightFactor(double val) {
        this.netWeightFactor = val;
    }

    public double getClusterCutoff() {
        return this.clusterCutoff;
    }

    public void setClusterCutoff(double val) {
        this.clusterCutoff = val;
    }

    public int getMaxWords() {
        return this.maxWords;
    }

    public void setMaxWords(int val) {
        this.maxWords = val;
    }

    public int getMinWordOccurrence() {
        return this.minWordOccurrence;
    }

    public void setMinWordOccurrence(int val) {
        this.minWordOccurrence = val;
    }

    public int getCloudNum() {
        return this.cloudNum;
    }

    public CloudDisplayStyles getDisplayStyle() {
        return this.displayStyle;
    }

    public void setDisplayStyle(CloudDisplayStyles style) {
        this.displayStyle = style;
    }

    public String getClusterColumnName() {
        return this.clusterColumnName;
    }

    public void setClusterColumnName(String clusterColumnName) {
        this.clusterColumnName = clusterColumnName;
    }

    public void setClusterTable(CyTable clusterTable) {
        this.clusterTable = clusterTable;
    }

    public CyTable getClusterTable() {
        if (this.clusterTable != null) {
            return this.clusterTable;
        }
        try {
            CyNetwork network = this.networkParams.getNetwork();
            CyTableManager tableManager = this.networkParams.getManager().getTableManager();
            String tableName = this.cloudName.substring(0, this.cloudName.indexOf(" Cloud "));
            return tableManager.getTable(((Long)network.getDefaultNetworkTable().getRow((Object)network.getSUID()).get(tableName, Long.class)).longValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public CloudParameters getCloud() {
        return this;
    }
}

