/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.baderlab.wordcloud.internal.model.CloudModelListener;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.model.NetworkParameters;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.model.events.ColumnNameChangedEvent;
import org.cytoscape.model.events.ColumnNameChangedListener;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.model.events.RemovedNodesEvent;
import org.cytoscape.model.events.RemovedNodesListener;
import org.cytoscape.property.CyProperty;

public class CloudModelManager
implements NetworkAboutToBeDestroyedListener,
RemovedNodesListener,
ColumnNameChangedListener,
ColumnDeletedListener {
    static final Lock uidLock = new ReentrantLock();
    private final Map<CyNetwork, NetworkParameters> networks;
    private final Set<CloudModelListener> listeners;
    private NetworkParameters nullNetwork;
    private final CyNetworkManager networkManager;
    private final CyTableManager tableManager;
    private final StreamUtil streamUtil;
    private final CyProperty<Properties> cyProperties;

    public CloudModelManager(CyNetworkManager networkManager, CyTableManager tableManager, StreamUtil streamUtil, CyProperty<Properties> cyProperties) {
        this.networkManager = networkManager;
        this.tableManager = tableManager;
        this.streamUtil = streamUtil;
        this.cyProperties = cyProperties;
        this.listeners = new LinkedHashSet<CloudModelListener>();
        this.networks = new HashMap<CyNetwork, NetworkParameters>();
    }

    public NetworkParameters addNetwork(CyNetwork network) {
        if (network == null) {
            throw new NullPointerException();
        }
        if (this.isManaged(network)) {
            return this.getNetworkParameters(network);
        }
        NetworkParameters networkParameters = new NetworkParameters(this, network);
        this.networks.put(network, networkParameters);
        return networkParameters;
    }

    public synchronized NetworkParameters getNullNetwork() {
        if (this.nullNetwork == null) {
            this.nullNetwork = new NetworkParameters(this, null);
        }
        return this.nullNetwork;
    }

    public void removeNetwork(CyNetwork network) {
        NetworkParameters removed = this.networks.remove(network);
        this.fireNetworkRemoved(removed);
    }

    public boolean isManaged(CyNetwork network) {
        return this.networks.containsKey(network);
    }

    public Collection<NetworkParameters> getNetworks() {
        return this.networks.values();
    }

    public NetworkParameters getNetworkParameters(CyNetwork network) {
        return this.networks.get(network);
    }

    public boolean addListener(CloudModelListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(CloudModelListener listener) {
        return this.listeners.remove(listener);
    }

    protected void fireCloudAdded(CloudParameters cloudParams) {
        for (CloudModelListener listener : this.listeners) {
            listener.cloudAdded(cloudParams);
        }
    }

    protected void fireNetworkRemoved(NetworkParameters networkParams) {
        for (CloudModelListener listener : this.listeners) {
            listener.networkRemoved(networkParams);
        }
    }

    protected void fireNetworkModified(NetworkParameters networkParams) {
        for (CloudModelListener listener : this.listeners) {
            listener.networkModified(networkParams);
        }
    }

    protected void fireCloudDeleted(CloudParameters cloudParams) {
        for (CloudModelListener listener : this.listeners) {
            listener.cloudDeleted(cloudParams);
        }
    }

    protected void fireCloudModified(CloudParameters cloudParameters) {
        for (CloudModelListener listener : this.listeners) {
            listener.cloudModified(cloudParameters);
        }
    }

    public static List<String> getColumnNames(CyNetwork network, Class<? extends CyIdentifiable> tableType) {
        if (network == null) {
            return Collections.emptyList();
        }
        ArrayList<String> attributeList = new ArrayList<String>();
        CyTable table = null;
        if (tableType.equals(CyNode.class)) {
            table = network.getDefaultNodeTable();
        } else if (tableType.equals(CyEdge.class)) {
            table = network.getDefaultEdgeTable();
        }
        if (table != null) {
            for (CyColumn column : table.getColumns()) {
                Class type = column.getType();
                if (type.equals(String.class)) {
                    attributeList.add(column.getName());
                    continue;
                }
                if (!type.equals(List.class) || !column.getListElementType().equals(String.class)) continue;
                attributeList.add(column.getName());
            }
            Collections.sort(attributeList);
        }
        return attributeList;
    }

    public static boolean hasCloudMetadata(CyNetwork network) {
        return network.getDefaultNetworkTable().getColumn("Cloud Network UID") != null;
    }

    protected void initializeCloudMetadata(CyNetwork network) {
        CyRow row;
        CyTable networkTable = network.getDefaultNetworkTable();
        if (networkTable.getColumn("Cloud Network UID") == null) {
            networkTable.createColumn("Use Stemming", Boolean.class, false);
            networkTable.createColumn("Cloud Counter", Integer.class, false);
            networkTable.createColumn("Cloud Network UID", Integer.class, false);
        }
        if ((row = network.getRow((CyIdentifiable)network)).get("Cloud Network UID", Integer.class) == null) {
            row.set("Use Stemming", (Object)Boolean.FALSE);
            row.set("Cloud Counter", (Object)1);
            row.set("Cloud Network UID", (Object)this.getNextNetworkUID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextNetworkUID() {
        uidLock.lock();
        try {
            int maxUid = 0;
            for (CyNetwork network : this.networkManager.getNetworkSet()) {
                Integer uid;
                if (!CloudModelManager.hasCloudMetadata(network) || (uid = (Integer)network.getRow((CyIdentifiable)network).get("Cloud Network UID", Integer.class)) == null || uid <= maxUid) continue;
                maxUid = uid;
            }
            int n = maxUid + 1;
            return n;
        }
        finally {
            uidLock.unlock();
        }
    }

    public CyTableManager getTableManager() {
        return this.tableManager;
    }

    public StreamUtil getStreamUtil() {
        return this.streamUtil;
    }

    boolean overrideNetWeightProperty() {
        String propName = "wordcloud.overrideNetWeight";
        return Boolean.valueOf((String)((Properties)this.cyProperties.getProperties()).get("wordcloud.overrideNetWeight"));
    }

    double getNetWeightPropertyValue() {
        String propName = "wordcloud.defaultNetWeight";
        try {
            double value = Double.valueOf((String)((Properties)this.cyProperties.getProperties()).get("wordcloud.defaultNetWeight"));
            if (value < 0.0) {
                ((Properties)this.cyProperties.getProperties()).put("wordcloud.defaultNetWeight", "0.0");
                return 0.0;
            }
            if (value > 1.0) {
                ((Properties)this.cyProperties.getProperties()).put("wordcloud.defaultNetWeight", "1.0");
                return 1.0;
            }
            return value;
        }
        catch (Exception e) {
            ((Properties)this.cyProperties.getProperties()).put("wordcloud.defaultNetWeight", String.valueOf(0.0));
            return 0.0;
        }
    }

    public void handleEvent(NetworkAboutToBeDestroyedEvent e) {
        CyNetwork network = e.getNetwork();
        this.removeNetwork(network);
    }

    public synchronized void handleEvent(RemovedNodesEvent e) {
        CyNetwork network = (CyNetwork)e.getSource();
        NetworkParameters networkParams = this.networks.get(network);
        this.fireNetworkModified(networkParams);
    }

    public void handleEvent(ColumnNameChangedEvent e) {
        this.handleColumnNameChange((CyTable)e.getSource(), e.getOldColumnName(), e.getNewColumnName());
    }

    public void handleEvent(ColumnDeletedEvent e) {
        this.handleColumnNameChange((CyTable)e.getSource(), e.getColumnName(), null);
    }

    private void handleColumnNameChange(CyTable table, String oldName, String newName) {
        ArrayList<CloudParameters> modifiedClouds = new ArrayList<CloudParameters>();
        for (NetworkParameters networkParams : this.getNetworks()) {
            CyNetwork network = networkParams.getNetwork();
            if (!network.getDefaultNodeTable().equals(table) && !network.getTable(CyNode.class, "LOCAL_ATTRS").equals(table)) continue;
            for (CloudParameters cloudParams : networkParams.getClouds()) {
                if (!cloudParams.getAttributeNames().contains(oldName)) continue;
                cloudParams.removeAttribtueName(oldName);
                if (newName != null) {
                    cloudParams.addAttributeName(newName);
                }
                modifiedClouds.add(cloudParams);
            }
        }
        for (CloudParameters cloud : modifiedClouds) {
            this.fireCloudModified(cloud);
        }
    }
}

