/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.baderlab.wordcloud.internal.cluster.CloudWordInfo;
import org.baderlab.wordcloud.internal.model.CloudBuilder;
import org.baderlab.wordcloud.internal.model.CloudModelManager;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.model.NetworkParameters;
import org.baderlab.wordcloud.internal.ui.UIManager;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.command.util.NodeList;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class CreateWordCloudCommandHandlerTask
implements Task {
    private CyApplicationManager applicationManager;
    private CyTableManager tableManager;
    private CyTableFactory tableFactory;
    private CloudModelManager cloudModelManager;
    private UIManager uiManager;
    private CyNetwork network;
    @Tunable(description="Column with words")
    public String wordColumnName;
    @Tunable(description="Nodes to use")
    public NodeList nodeList = new NodeList(null);
    @Tunable(description="Cloud name")
    public String cloudName = "";
    @Tunable(description="Cloud group table name")
    public String cloudGroupTableName = "WordCloud Results Table";

    @Tunable(description="List of Nodes", context="nogui")
    public NodeList getnodeList() {
        if (this.network == null) {
            this.network = this.applicationManager.getCurrentNetwork();
        }
        this.nodeList.setNetwork(this.network);
        return this.nodeList;
    }

    public void setnodeList(NodeList setValue) {
    }

    public CreateWordCloudCommandHandlerTask(CyApplicationManager applicationManager, CloudModelManager cloudManager, UIManager uiManager, CyTableManager tableManager, CyTableFactory tableFactory) {
        this.applicationManager = applicationManager;
        this.uiManager = uiManager;
        this.tableManager = tableManager;
        this.tableFactory = tableFactory;
        this.cloudModelManager = cloudManager;
    }

    public void cancel() {
    }

    public void run(TaskMonitor monitor) {
        if (this.nodeList == null || this.nodeList.getValue() == null) {
            throw new IllegalArgumentException("nodeList is null");
        }
        if (this.cloudName == null || this.cloudName.trim().equals("")) {
            throw new IllegalArgumentException("cloudName is null");
        }
        if (this.cloudGroupTableName == null || this.cloudGroupTableName.trim().equals("")) {
            throw new IllegalArgumentException("cloudGroupTableName is null");
        }
        if (this.wordColumnName == null || this.wordColumnName.trim().equals("")) {
            throw new IllegalArgumentException("wordColumnName is null");
        }
        this.network = this.applicationManager.getCurrentNetwork();
        HashSet<CyNode> nodes = new HashSet<CyNode>(this.nodeList.getValue());
        CyTable cloudGroupTable = null;
        if (this.network.getDefaultNetworkTable().getColumn(this.cloudGroupTableName) != null) {
            cloudGroupTable = this.tableManager.getTable(((Long)this.network.getRow((CyIdentifiable)this.network).get(this.cloudGroupTableName, Long.class)).longValue());
        } else {
            cloudGroupTable = this.tableFactory.createTable(this.cloudGroupTableName, "Cloud", String.class, true, true);
            this.createColumn(cloudGroupTable, "WC_Word");
            this.createColumn(cloudGroupTable, "WC_FontSize");
            this.createColumn(cloudGroupTable, "WC_Cluster");
            this.createColumn(cloudGroupTable, "WC_Number");
            this.tableManager.addTable(cloudGroupTable);
            this.network.getDefaultNetworkTable().createColumn(this.cloudGroupTableName, Long.class, false);
            this.network.getRow((CyIdentifiable)this.network).set(this.cloudGroupTableName, (Object)cloudGroupTable.getSUID());
        }
        NetworkParameters networkParams = this.cloudModelManager.addNetwork(this.network);
        CloudBuilder builder = networkParams.getCloudBuilder();
        CloudParameters currentCloud = this.uiManager.getCurrentCloud();
        if (currentCloud != null) {
            builder.copyFrom(currentCloud);
        }
        builder.setName(this.cloudName).setNodes(nodes).setAttributes(Arrays.asList(this.wordColumnName)).setClusterTable(cloudGroupTable);
        builder.applyOverrideProperties();
        CloudParameters cloudParams = builder.build();
        List<CloudWordInfo> wordInfo = cloudParams.calculateCloud().getCloudWordInfoList();
        ArrayList<String> WC_Word = new ArrayList<String>();
        ArrayList<String> WC_FontSize = new ArrayList<String>();
        ArrayList<String> WC_Cluster = new ArrayList<String>();
        ArrayList<String> WC_Number = new ArrayList<String>();
        for (CloudWordInfo cloudWord : wordInfo) {
            String[] split = cloudWord.toSplitString();
            WC_Word.add(split[0]);
            WC_FontSize.add(split[1]);
            WC_Cluster.add(split[2]);
            WC_Number.add(split[3]);
        }
        CyRow clusterRow = cloudGroupTable.getRow((Object)this.cloudName);
        clusterRow.set("WC_Word", WC_Word);
        clusterRow.set("WC_FontSize", WC_FontSize);
        clusterRow.set("WC_Cluster", WC_Cluster);
        clusterRow.set("WC_Number", WC_Number);
    }

    private void createColumn(CyTable nodeTable, String columnName) {
        CyColumn column = nodeTable.getColumn(columnName);
        if (column != null) {
            nodeTable.deleteColumn(columnName);
        }
        nodeTable.createListColumn(columnName, String.class, false);
    }
}

