/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.cluster;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import org.baderlab.wordcloud.internal.cluster.CloudInfo;

public class CloudWordInfo
implements Comparable<CloudWordInfo> {
    private final String word;
    private final int fontSize;
    private final CloudInfo cloudInfo;
    private final Color textColor;
    private final int cluster;
    private final int wordNum;
    private static final String FIRSTDELIMITER = "TabbedEquivalent";
    private static final String SECONDDELIMITER = "NewLineEquivalent";

    public CloudWordInfo(CloudInfo cloudInfo, String word, int fontSize, Color textColor, int cluster, int wordNum) {
        this.cloudInfo = cloudInfo;
        this.word = word;
        this.fontSize = fontSize;
        this.textColor = textColor;
        this.cluster = cluster;
        this.wordNum = wordNum;
    }

    public CloudWordInfo(CloudInfo cloudInfo, String word, int fontSize) {
        this(cloudInfo, word, fontSize, null, 0, 0);
    }

    @Override
    public int compareTo(CloudWordInfo c) {
        Integer first = this.getFontSize();
        Integer second = c.getFontSize();
        int result = second.compareTo(first);
        if (result == 0 && (result = (first = Integer.valueOf(this.getCluster())).compareTo(second = Integer.valueOf(c.getCluster()))) == 0 && (result = (first = Integer.valueOf(this.getWordNumber())).compareTo(second = Integer.valueOf(c.getWordNumber()))) == 0) {
            String firstString = this.getWord();
            String secondString = c.getWord();
            result = firstString.compareTo(secondString);
        }
        return result;
    }

    public JLabel createCloudLabel() {
        JLabel label = new JLabel(this.word);
        label.setFont(new Font("sansserif", 1, this.fontSize));
        label.setForeground(this.textColor);
        return label;
    }

    public String toString() {
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append("WordTabbedEquivalent" + this.word + SECONDDELIMITER);
        paramVariables.append("FontSizeTabbedEquivalent" + this.fontSize + SECONDDELIMITER);
        paramVariables.append("ClusterTabbedEquivalent" + this.cluster + SECONDDELIMITER);
        paramVariables.append("WordNumTabbedEquivalent" + this.wordNum + SECONDDELIMITER);
        paramVariables.append("TextColorTabbedEquivalent" + this.textColor.getRGB() + SECONDDELIMITER);
        return paramVariables.toString();
    }

    public String[] toSplitString() {
        return new String[]{this.word, Integer.toString(this.fontSize), Integer.toString(this.cluster), Integer.toString(this.wordNum)};
    }

    public String getWord() {
        return this.word;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public CloudInfo getCloudInfo() {
        return this.cloudInfo;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public int getCluster() {
        return this.cluster;
    }

    public int getWordNumber() {
        return this.wordNum;
    }
}

