/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.baderlab.wordcloud.internal.IoUtil;
import org.baderlab.wordcloud.internal.model.CloudModelManager;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.model.NetworkParameters;
import org.baderlab.wordcloud.internal.model.WordDelimiters;
import org.baderlab.wordcloud.internal.model.WordFilter;
import org.baderlab.wordcloud.internal.ui.UIManager;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyRow;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionListener
implements SessionAboutToBeSavedListener,
SessionLoadedListener {
    private static final String netNameSep = "SemanticSummaryNetworkSeparator";
    private static final String cloudNameSep = "SemanticSummaryCloudSeparator";
    private final Logger logger = LoggerFactory.getLogger(SessionListener.class);
    private final CloudModelManager cloudManager;
    private final IoUtil ioUtil;
    private final CyNetworkManager networkManager;
    private final CyApplicationManager applicationManager;
    private final UIManager uiManager;

    public SessionListener(CloudModelManager cloudManager, IoUtil ioUtil, CyNetworkManager networkManager, CyApplicationManager applicationManager, UIManager uiManager) {
        this.cloudManager = cloudManager;
        this.ioUtil = ioUtil;
        this.networkManager = networkManager;
        this.applicationManager = applicationManager;
        this.uiManager = uiManager;
    }

    public String describe() {
        StringBuffer sb = new StringBuffer();
        sb.append("For every node in the current network, this plugin ");
        sb.append("displays a word cloud of the selected ");
        sb.append("cyNode attribute.  The node ID is the defuault ");
        sb.append("attribute.");
        return sb.toString();
    }

    public void handleEvent(SessionAboutToBeSavedEvent event) {
        ArrayList<File> files = new ArrayList<File>();
        this.saveSessionStateFiles(files);
        try {
            event.addAppFiles("ca.baderlab.WordCloud", files);
        }
        catch (Exception e) {
            this.logger.error("Unexpected error while loading WordCloud app state", (Throwable)e);
        }
    }

    public void handleEvent(SessionLoadedEvent event) {
        List files = (List)event.getLoadedSession().getAppFileListMap().get("ca.baderlab.WordCloud");
        if (files == null) {
            return;
        }
        this.restoreSessionState(files);
    }

    public void saveSessionStateFiles(List<File> pFileList) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        Collection<NetworkParameters> networks = this.cloudManager.getNetworks();
        for (NetworkParameters params : networks) {
            CyNetwork network = params.getNetwork();
            try {
                int uid = (Integer)network.getRow((CyIdentifiable)network).get("Cloud Network UID", Integer.class);
                File current_filter = new File(tmpDir, netNameSep + uid + netNameSep + ".FILTER.txt");
                BufferedWriter filterWriter = new BufferedWriter(new FileWriter(current_filter));
                filterWriter.write(params.getFilter().toString());
                filterWriter.close();
                pFileList.add(current_filter);
                File current_delimiter = new File(tmpDir, netNameSep + uid + netNameSep + ".DELIMITER.txt");
                BufferedWriter delimiterWriter = new BufferedWriter(new FileWriter(current_delimiter));
                delimiterWriter.write(params.getDelimeters().toString());
                delimiterWriter.close();
                pFileList.add(current_delimiter);
                for (CloudParameters cloud : params.getClouds()) {
                    String cloud_name = cloud.getCloudName();
                    File current_cloud = new File(tmpDir, netNameSep + uid + netNameSep + cloudNameSep + cloud_name + cloudNameSep + ".CLOUDS.txt");
                    BufferedWriter subCloud1Writer = new BufferedWriter(new FileWriter(current_cloud));
                    subCloud1Writer.write(cloud.toString());
                    subCloud1Writer.close();
                    pFileList.add(current_cloud);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private Set<CyNetwork> getSemanticSummaryNetworks() {
        HashSet<CyNetwork> networks = new HashSet<CyNetwork>();
        for (CyNetwork network : this.networkManager.getNetworkSet()) {
            if (!CloudModelManager.hasCloudMetadata(network)) continue;
            networks.add(network);
        }
        return networks;
    }

    private CyNetwork getNetwork(int uid) {
        for (CyNetwork network : this.networkManager.getNetworkSet()) {
            Integer other;
            CyRow row = network.getRow((CyIdentifiable)network);
            if (row == null || (other = (Integer)row.get("Cloud Network UID", Integer.class)) == null || uid != other) continue;
            return network;
        }
        return null;
    }

    public void restoreSessionState(List<File> pStateFileList) {
        if (pStateFileList == null || pStateFileList.size() == 0) {
            return;
        }
        try {
            for (CyNetwork network : this.getSemanticSummaryNetworks()) {
                this.cloudManager.addNetwork(network);
            }
            for (int i = 0; i < pStateFileList.size(); ++i) {
                NetworkParameters networkParams;
                CyNetwork network;
                int uid;
                String net_name;
                String[] fullname;
                String fullText;
                File prop_file = pStateFileList.get(i);
                if (prop_file.getName().contains(".CLOUDS.txt")) {
                    fullText = this.ioUtil.readAll(prop_file.getAbsolutePath());
                    fullname = prop_file.getName().split(netNameSep);
                    net_name = fullname[1];
                    uid = Integer.parseInt(net_name);
                    network = this.getNetwork(uid);
                    networkParams = this.cloudManager.getNetworkParameters(network);
                    networkParams.createCloudFromProperties(fullText);
                }
                if (prop_file.getName().contains(".FILTER.txt")) {
                    fullText = this.ioUtil.readAll(prop_file.getAbsolutePath());
                    fullname = prop_file.getName().split(netNameSep);
                    net_name = fullname[1];
                    uid = Integer.parseInt(net_name);
                    network = this.getNetwork(uid);
                    networkParams = this.cloudManager.getNetworkParameters(network);
                    WordFilter curFilter = new WordFilter(fullText);
                    networkParams.setFilter(curFilter);
                }
                if (!prop_file.getName().contains(".DELIMITER.txt")) continue;
                fullText = this.ioUtil.readAll(prop_file.getAbsolutePath());
                fullname = prop_file.getName().split(netNameSep);
                net_name = fullname[1];
                uid = Integer.parseInt(net_name);
                network = this.getNetwork(uid);
                networkParams = this.cloudManager.getNetworkParameters(network);
                WordDelimiters curDelimiter = new WordDelimiters(fullText);
                networkParams.setDelimeters(curDelimiter);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

