/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal;

import java.util.Properties;
import javax.swing.Action;
import org.baderlab.wordcloud.internal.ActionNodeViewTaskFactory;
import org.baderlab.wordcloud.internal.IoUtil;
import org.baderlab.wordcloud.internal.SessionListener;
import org.baderlab.wordcloud.internal.command.CreateWordCloudCommandHandlerTaskFactory;
import org.baderlab.wordcloud.internal.command.DeleteWordCloudCommandHandlerTaskFactory;
import org.baderlab.wordcloud.internal.command.SelectWordCloudCommandHandlerTaskFactory;
import org.baderlab.wordcloud.internal.model.CloudModelManager;
import org.baderlab.wordcloud.internal.ui.CloudTaskManager;
import org.baderlab.wordcloud.internal.ui.UIManager;
import org.baderlab.wordcloud.internal.ui.action.CreateCloudAction;
import org.baderlab.wordcloud.internal.ui.action.ExportImageAction;
import org.baderlab.wordcloud.internal.ui.action.ShowAboutDialogAction;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.property.AbstractConfigDirPropsReader;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.NodeViewTaskFactory;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.TaskFactory;
import org.osgi.framework.BundleContext;

public class CyActivator
extends AbstractCyActivator {
    private static final String APPS_MENU = "Apps.WordCloud";
    private CloudTaskManager cloudTaskManager;
    private UIManager uiManager;

    public void start(BundleContext context) throws Exception {
        CyApplicationManager applicationManager = (CyApplicationManager)this.getService(context, CyApplicationManager.class);
        CySwingApplication application = (CySwingApplication)this.getService(context, CySwingApplication.class);
        CyTableManager tableManager = (CyTableManager)this.getService(context, CyTableManager.class);
        CyTableFactory tableFactory = (CyTableFactory)this.getService(context, CyTableFactory.class);
        CyNetworkManager networkManager = (CyNetworkManager)this.getService(context, CyNetworkManager.class);
        CyServiceRegistrar registrar = (CyServiceRegistrar)this.getService(context, CyServiceRegistrar.class);
        FileUtil fileUtil = (FileUtil)this.getService(context, FileUtil.class);
        StreamUtil streamUtil = (StreamUtil)this.getService(context, StreamUtil.class);
        OpenBrowser openBrowser = (OpenBrowser)this.getService(context, OpenBrowser.class);
        PropsReader propsReader = new PropsReader("wordcloud", "wordcloud.props");
        Properties propsReaderServiceProps = new Properties();
        propsReaderServiceProps.setProperty("cyPropertyName", "wordcloud.props");
        this.registerAllServices(context, (Object)propsReader, propsReaderServiceProps);
        CloudModelManager cloudModelManager = new CloudModelManager(networkManager, tableManager, streamUtil, (CyProperty<Properties>)propsReader);
        this.registerAllServices(context, cloudModelManager, new Properties());
        this.cloudTaskManager = new CloudTaskManager();
        this.uiManager = new UIManager(cloudModelManager, applicationManager, application, registrar, this.cloudTaskManager);
        cloudModelManager.addListener(this.uiManager);
        this.registerAllServices(context, this.uiManager, new Properties());
        AbstractCyAction showAction = this.uiManager.createShowHideAction();
        showAction.setPreferredMenu(APPS_MENU);
        this.registerService(context, showAction, CyAction.class, new Properties());
        CreateCloudAction createAction = new CreateCloudAction(applicationManager, application, cloudModelManager, this.uiManager);
        createAction.setPreferredMenu(APPS_MENU);
        this.registerService(context, (Object)createAction, CyAction.class, new Properties());
        ExportImageAction exportImageAction = new ExportImageAction(application, fileUtil, this.uiManager);
        exportImageAction.setPreferredMenu(APPS_MENU);
        this.registerService(context, (Object)exportImageAction, CyAction.class, new Properties());
        Properties props = new Properties();
        props.setProperty("title", (String)createAction.getValue("Name"));
        this.registerService(context, new ActionNodeViewTaskFactory((Action)((Object)createAction)), NodeViewTaskFactory.class, props);
        ShowAboutDialogAction aboutAction = new ShowAboutDialogAction(application, openBrowser);
        aboutAction.setPreferredMenu(APPS_MENU);
        this.registerService(context, (Object)aboutAction, CyAction.class, new Properties());
        SessionListener sessionListener = new SessionListener(cloudModelManager, new IoUtil(streamUtil), networkManager, applicationManager, this.uiManager);
        this.registerAllServices(context, sessionListener, new Properties());
        this.registerCommand(context, "create", new CreateWordCloudCommandHandlerTaskFactory(applicationManager, application, cloudModelManager, this.uiManager, tableManager, tableFactory));
        this.registerCommand(context, "delete", new DeleteWordCloudCommandHandlerTaskFactory(this.uiManager));
        this.registerCommand(context, "select", new SelectWordCloudCommandHandlerTaskFactory(this.uiManager));
    }

    public void shutDown() {
        this.uiManager.dispose();
        this.cloudTaskManager.disposeAll();
    }

    private void registerCommand(BundleContext context, String name, TaskFactory factory) {
        Properties props = new Properties();
        props.put("command", name);
        props.put("commandNamespace", "wordcloud");
        this.registerService(context, factory, TaskFactory.class, props);
    }

    class PropsReader
    extends AbstractConfigDirPropsReader {
        public PropsReader(String name, String fileName) {
            super(name, fileName, CyProperty.SavePolicy.CONFIG_DIR);
        }
    }
}

