/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.model.CloudProvider;
import org.baderlab.wordcloud.internal.ui.UIManager;
import org.baderlab.wordcloud.internal.ui.action.RenameCloudDialog;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyNetwork;

public class RenameCloudAction
extends AbstractCyAction {
    private CloudProvider cloudProvider;
    private CySwingApplication swingApplication;
    private UIManager uiManager;

    public RenameCloudAction(CloudProvider cloudProvider, CySwingApplication swingApplication, UIManager uiManager) {
        super("Rename Cloud");
        this.cloudProvider = cloudProvider;
        this.swingApplication = swingApplication;
        this.uiManager = uiManager;
    }

    public void actionPerformed(ActionEvent e) {
        String newName;
        CloudParameters cloud;
        block5: {
            cloud = this.cloudProvider.getCloud();
            if (cloud == null) {
                return;
            }
            String curName = cloud.getCloudName();
            JFrame parent = this.swingApplication.getJFrame();
            newName = null;
            while (true) {
                int value;
                RenameCloudDialog theDialog = new RenameCloudDialog(parent, true, curName);
                theDialog.setLocationRelativeTo(parent);
                theDialog.setVisible(true);
                newName = theDialog.getNewCloudName();
                if (curName.equals(newName)) {
                    return;
                }
                if (newName == null || newName.trim().equals("")) {
                    return;
                }
                if (this.isCloudNameTaken(newName)) {
                    value = this.showWarnDialog(parent, "A cloud with the name '" + newName + "' already exists. Please try again.", "Duplicate Cloud Name");
                    if (value != 1) continue;
                    return;
                }
                if (!this.isColumnNameTaken(newName)) break block5;
                value = this.showWarnDialog(parent, "Cannot name cloud '" + newName + "' because a column with that name exists. Please try again.", "Duplicate Column Name");
                if (value == 1) break;
            }
            return;
        }
        cloud.rename(newName);
    }

    private int showWarnDialog(Component parent, String message, String title) {
        Object[] options = new Object[]{"Try Again", "Cancel"};
        int value = JOptionPane.showOptionDialog(parent, message, title, 2, 1, null, options, options[0]);
        return value;
    }

    private boolean isCloudNameTaken(String name) {
        return this.uiManager.getCurrentNetwork().containsCloud(name);
    }

    private boolean isColumnNameTaken(String name) {
        CyNetwork network = this.uiManager.getCurrentNetwork().getNetwork();
        if (network != null) {
            return network.getDefaultNodeTable().getColumn(name) != null;
        }
        return false;
    }
}

