/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui.action;

import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.model.CloudProvider;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;

public class DeleteCloudAction
extends AbstractCyAction {
    private CloudProvider cloudProvider;
    private CySwingApplication swingApplication;

    public DeleteCloudAction(CloudProvider cloudProvider, CySwingApplication swingApplication) {
        super("Delete Cloud");
        this.cloudProvider = cloudProvider;
        this.swingApplication = swingApplication;
    }

    public void actionPerformed(ActionEvent e) {
        CloudParameters cloud = this.cloudProvider.getCloud();
        if (cloud == null) {
            return;
        }
        if (this.confirmDelete(cloud)) {
            cloud.delete();
        }
    }

    private boolean confirmDelete(CloudParameters cloud) {
        JFrame parent = this.swingApplication.getJFrame();
        String cloudName = cloud.getCloudName();
        String networkName = cloud.getNetworkParams().getNetworkName();
        String message = String.format("Delete '%s' from network '%s'?", cloudName, networkName);
        int value = JOptionPane.showConfirmDialog(parent, message, "Delete Cloud", 0);
        return value == 0;
    }
}

