/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.baderlab.wordcloud.internal.SelectionUtils;
import org.baderlab.wordcloud.internal.model.CloudModelListener;
import org.baderlab.wordcloud.internal.model.CloudModelManager;
import org.baderlab.wordcloud.internal.model.CloudParameters;
import org.baderlab.wordcloud.internal.model.NetworkParameters;
import org.baderlab.wordcloud.internal.ui.CloudTaskManager;
import org.baderlab.wordcloud.internal.ui.DualPanelDocker;
import org.baderlab.wordcloud.internal.ui.cloud.CloudDisplayPanel;
import org.baderlab.wordcloud.internal.ui.input.SemanticSummaryInputPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;

public class UIManager
implements CloudModelListener,
SetCurrentNetworkListener,
SetCurrentNetworkViewListener,
RowsSetListener {
    private final CloudModelManager cloudManager;
    private final CyApplicationManager applicationManager;
    private final CySwingApplication application;
    private final CyServiceRegistrar registrar;
    private final CloudTaskManager cloudTaskManager;
    private SemanticSummaryInputPanel inputWindow;
    private CloudDisplayPanel cloudWindow;
    private DualPanelDocker docker;
    private AbstractCyAction showHideAction;
    private Map<NetworkParameters, CloudParameters> selectedClouds = new HashMap<NetworkParameters, CloudParameters>();
    private NetworkParameters currentNetwork;
    private boolean hidden = true;

    public UIManager(CloudModelManager cloudManager, CyApplicationManager applicationManager, CySwingApplication application, CyServiceRegistrar registrar, CloudTaskManager cloudTaskManager) {
        this.cloudManager = cloudManager;
        this.applicationManager = applicationManager;
        this.application = application;
        this.registrar = registrar;
        this.cloudTaskManager = cloudTaskManager;
    }

    public AbstractCyAction createShowHideAction() {
        if (this.showHideAction == null) {
            this.showHideAction = new AbstractCyAction("Show WordCloud"){

                public void actionPerformed(ActionEvent e) {
                    if (UIManager.this.docker == null) {
                        UIManager.this.setCurrentCloud(UIManager.this.applicationManager.getCurrentNetwork());
                    } else {
                        UIManager.this.hide();
                    }
                }
            };
        }
        return this.showHideAction;
    }

    private void show() {
        this.hidden = false;
        if (this.docker == null) {
            this.inputWindow = new SemanticSummaryInputPanel(this.applicationManager, this.application, this, this.registrar);
            this.inputWindow.setPreferredSize(new Dimension(350, 400));
            this.cloudWindow = new CloudDisplayPanel(this, this.cloudTaskManager);
            this.docker = new DualPanelDocker(this.inputWindow, this.cloudWindow, this.application, this.registrar);
            this.cloudWindow.setDocker(this.docker);
            if (this.showHideAction != null) {
                this.showHideAction.setName("Hide WordCloud");
            }
        }
    }

    private void hide() {
        this.hidden = true;
        if (this.docker != null) {
            this.docker.dispose();
            this.docker = null;
            this.inputWindow = null;
            this.cloudWindow = null;
            this.currentNetwork = null;
            if (this.showHideAction != null) {
                this.showHideAction.setName("Show WordCloud");
            }
        }
    }

    public void dispose() {
        this.hide();
    }

    public SemanticSummaryInputPanel getInputPanel() {
        return this.inputWindow;
    }

    public CloudDisplayPanel getCloudDisplayPanel() {
        return this.cloudWindow;
    }

    public NetworkParameters getCurrentNetwork() {
        return this.currentNetwork;
    }

    public CloudModelManager getCloudModelManager() {
        return this.cloudManager;
    }

    public void setCurrentCloud(CyNetwork network) {
        if (network == null) {
            this.setCurrentCloud((NetworkParameters)null);
        } else {
            this.setCurrentCloud(this.cloudManager.addNetwork(network));
        }
    }

    public void setCurrentCloud(NetworkParameters networkParams) {
        CloudParameters selectedCloud;
        if (networkParams == null) {
            networkParams = this.cloudManager.getNullNetwork();
        }
        if ((selectedCloud = this.selectedClouds.get(networkParams)) != null) {
            this.setCurrentCloud(selectedCloud);
        } else {
            CloudParameters defaultCloud = networkParams.getFirstCloud();
            if (defaultCloud != null) {
                this.setCurrentCloud(defaultCloud);
            } else {
                this.setCurrentCloud(networkParams.getNullCloud());
            }
        }
    }

    public void setCurrentCloud(NetworkParameters network, String cloudName) {
        CloudParameters cloud = network.getCloud(cloudName);
        this.setCurrentCloud(cloud == null ? network.getNullCloud() : cloud);
    }

    public void setCurrentCloud(CloudParameters cloud) {
        this.setCurrentCloud(cloud, true);
    }

    public void setCurrentCloud(CloudParameters cloud, boolean updateNodeSelection) {
        if (cloud == null) {
            throw new NullPointerException();
        }
        this.currentNetwork = cloud.getNetworkParams();
        this.selectedClouds.put(cloud.getNetworkParams(), cloud);
        this.show();
        this.inputWindow.setCurrentCloud(cloud);
        this.cloudWindow.updateCloudDisplay(cloud);
        if (updateNodeSelection) {
            this.updateNodeSelection(cloud);
        }
    }

    public void updateNodeSelection(CloudParameters cloud) {
        Set<CyNode> selNodes = cloud.getSelectedNodes();
        CyNetwork network = cloud.getNetworkParams().getNetwork();
        if (network != null) {
            SelectionUtils.setSelected(network, selNodes);
        }
    }

    private void clear() {
        this.setCurrentCloud(this.cloudManager.getNullNetwork());
    }

    public CloudParameters getCurrentCloud() {
        if (this.currentNetwork == null) {
            return this.cloudManager.getNullNetwork().getNullCloud();
        }
        CloudParameters cloud = this.selectedClouds.get(this.currentNetwork);
        return cloud == null ? this.currentNetwork.getNullCloud() : cloud;
    }

    public boolean isCurrentCloud(CloudParameters cloud) {
        return cloud.getNetworkParams() == this.currentNetwork && cloud == this.selectedClouds.get(cloud.getNetworkParams());
    }

    @Override
    public void cloudAdded(CloudParameters cloudParams) {
        if (this.hidden) {
            this.show();
        }
        this.setCurrentCloud(cloudParams);
        this.docker.bringToFront();
    }

    @Override
    public void cloudDeleted(CloudParameters cloud) {
        if (this.isCurrentCloud(cloud)) {
            this.selectedClouds.remove(cloud.getNetworkParams());
        }
        if (this.hidden) {
            return;
        }
        if (cloud.getNetworkParams() == this.currentNetwork) {
            this.setCurrentCloud(cloud.getNetworkParams());
        }
    }

    @Override
    public void networkModified(NetworkParameters networkParams) {
        if (this.hidden) {
            return;
        }
        if (networkParams == this.currentNetwork) {
            CloudParameters currentCloud = this.selectedClouds.get(this.currentNetwork);
            this.inputWindow.setCurrentCloud(currentCloud);
            this.cloudWindow.updateCloudDisplay(currentCloud);
        }
    }

    @Override
    public void cloudModified(CloudParameters cloudParams) {
        if (this.hidden) {
            return;
        }
        if (cloudParams.getNetworkParams() == this.currentNetwork) {
            this.inputWindow.setCurrentCloud(this.selectedClouds.get(this.currentNetwork));
        }
    }

    @Override
    public void networkRemoved(NetworkParameters networkParams) {
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        if (this.hidden) {
            return;
        }
        CyNetworkView networkView = e.getNetworkView();
        if (networkView == null) {
            this.clear();
        } else {
            this.setCurrentCloud((CyNetwork)networkView.getModel());
        }
    }

    public void handleEvent(SetCurrentNetworkEvent e) {
        if (this.hidden) {
            return;
        }
        this.setCurrentCloud(e.getNetwork());
    }

    public void handleEvent(RowsSetEvent e) {
        if (this.hidden) {
            return;
        }
        boolean isNetworkRename = false;
        for (RowSetRecord record : e.getPayloadCollection()) {
            if (!record.getColumn().equals("name")) continue;
            isNetworkRename = true;
            break;
        }
        if (isNetworkRename) {
            this.inputWindow.updateNetworkName(this.currentNetwork.getNetworkName());
        }
    }
}

