/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.baderlab.wordcloud.internal.ui.cloud.CloudDisplayPanel;
import org.baderlab.wordcloud.internal.ui.input.SemanticSummaryInputPanel;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.service.util.CyServiceRegistrar;

public class DualPanelDocker {
    private final CySwingApplication swingApplication;
    private final CyServiceRegistrar registrar;
    private final SemanticSummaryInputPanel inputPanel;
    private final CloudDisplayPanel cloudPanel;
    private CytoPanelComponent inputComponent;
    private CytoPanelComponent cloudComponent;
    private DockCallback callback;
    private JFrame dialog;
    private State state;

    public DualPanelDocker(SemanticSummaryInputPanel inputPanel, CloudDisplayPanel cloudPanel, CySwingApplication swingApplication, CyServiceRegistrar registrar) {
        this.inputPanel = inputPanel;
        this.cloudPanel = cloudPanel;
        this.swingApplication = swingApplication;
        this.registrar = registrar;
        this.inputComponent = this.wrapInCytoPanel(inputPanel, CytoPanelName.WEST, "WordCloud");
        this.cloudComponent = this.wrapInCytoPanel(cloudPanel, CytoPanelName.SOUTH, "WordCloud Display");
        this.state = State.UNDOCKED;
        this.flip();
    }

    public void setCallback(DockCallback callback) {
        this.callback = callback;
    }

    public void flip() {
        switch (this.state) {
            case DOCKED: {
                this.undock();
                this.state = State.UNDOCKED;
                if (this.callback == null) break;
                this.callback.undocked();
                break;
            }
            case UNDOCKED: {
                this.dock();
                this.state = State.DOCKED;
                if (this.callback == null) break;
                this.callback.docked();
            }
        }
    }

    public void dispose() {
        this.registrar.unregisterService((Object)this.inputComponent, CytoPanelComponent.class);
        this.registrar.unregisterService((Object)this.cloudComponent, CytoPanelComponent.class);
        if (this.dialog != null) {
            this.dialog.removeWindowListener(this.dialog.getWindowListeners()[0]);
            this.dialog.dispatchEvent(new WindowEvent(this.dialog, 201));
            this.dialog = null;
        }
    }

    private void dock() {
        if (this.dialog != null) {
            this.dialog.removeWindowListener(this.dialog.getWindowListeners()[0]);
            this.dialog.dispatchEvent(new WindowEvent(this.dialog, 201));
            this.dialog.dispose();
            this.dialog = null;
        }
        this.registrar.registerService((Object)this.inputComponent, CytoPanelComponent.class, new Properties());
        this.registrar.registerService((Object)this.cloudComponent, CytoPanelComponent.class, new Properties());
        this.cloudPanel.setBackground(this.cloudPanel.getParent().getBackground());
        this.bringToFront(this.inputComponent);
        this.bringToFront(this.cloudComponent);
    }

    private void undock() {
        this.registrar.unregisterService((Object)this.inputComponent, CytoPanelComponent.class);
        this.registrar.unregisterService((Object)this.cloudComponent, CytoPanelComponent.class);
        this.dialog = new JFrame("WordCloud");
        this.dialog.getContentPane().add((Component)this.inputPanel, "West");
        this.dialog.getContentPane().add((Component)this.cloudPanel, "Center");
        this.cloudPanel.setBackground(this.cloudPanel.getParent().getBackground());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.setPreferredSize(new Dimension(this.inputPanel.getPreferredSize().width * 3, 700));
        this.dialog.pack();
        this.dialog.setVisible(true);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DualPanelDocker.this.flip();
            }
        });
    }

    private void bringToFront(CytoPanelComponent panel) {
        this.bringToFront(panel.getCytoPanelName(), panel.getComponent());
    }

    private void bringToFront(CytoPanelName compassPoint, Component component) {
        CytoPanel cytoPanel = this.swingApplication.getCytoPanel(compassPoint);
        int index = cytoPanel.indexOfComponent(component);
        cytoPanel.setSelectedIndex(index);
    }

    public void bringToFront() {
        this.bringToFront(CytoPanelName.WEST, this.inputPanel);
        this.bringToFront(CytoPanelName.SOUTH, this.cloudPanel);
    }

    public SemanticSummaryInputPanel getInputPanel() {
        return this.inputPanel;
    }

    public CloudDisplayPanel getCloudPanel() {
        return this.cloudPanel;
    }

    private CytoPanelComponent wrapInCytoPanel(final JPanel panel, final CytoPanelName compassPoint, final String title) {
        return new CytoPanelComponent(){

            public String getTitle() {
                return title;
            }

            public Icon getIcon() {
                return null;
            }

            public CytoPanelName getCytoPanelName() {
                return compassPoint;
            }

            public Component getComponent() {
                return panel;
            }
        };
    }

    public static interface DockCallback {
        public void docked();

        public void undocked();
    }

    private static enum State {
        DOCKED,
        UNDOCKED;

    }
}

