/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.cluster;

import java.util.ArrayList;
import java.util.List;
import org.baderlab.wordcloud.internal.cluster.CloudInfo;

public class SingleWordCluster
implements Comparable<SingleWordCluster> {
    private List<String> wordList = new ArrayList<String>();
    private int totalSum = 0;
    private int numItems = 0;
    private final CloudInfo cloudInfo;

    public SingleWordCluster(CloudInfo cloudInfo) {
        this.cloudInfo = cloudInfo;
    }

    public void add(String aWord) {
        double ratio = this.cloudInfo.getRatios().get(aWord);
        int fontSize = this.cloudInfo.calculateFontSize(aWord, ratio);
        this.totalSum += fontSize;
        ++this.numItems;
        this.wordList.add(aWord);
    }

    public String remove(String aWord) {
        if (!this.wordList.contains(aWord)) {
            return null;
        }
        double ratio = this.cloudInfo.getRatios().get(aWord);
        int fontSize = this.cloudInfo.calculateFontSize(aWord, ratio);
        this.totalSum -= fontSize;
        --this.numItems;
        this.wordList.remove(aWord);
        return aWord;
    }

    public double computeRootMean() {
        if (this.totalSum == 0 || this.numItems == 0) {
            return 0.0;
        }
        return (double)this.totalSum / Math.pow(this.numItems, 0.5);
    }

    public int getLargestFont() {
        int largest = 0;
        for (String curWord : this.wordList) {
            double ratio;
            int curSize = this.cloudInfo.calculateFontSize(curWord, ratio = this.cloudInfo.getRatios().get(curWord).doubleValue());
            if (largest >= curSize) continue;
            largest = curSize;
        }
        return largest;
    }

    public double calculateWeightedSum() {
        double sum = 0.0;
        double k = 2.0;
        for (String curWord : this.wordList) {
            double ratio = this.cloudInfo.getRatios().get(curWord);
            int curSize = this.cloudInfo.calculateFontSize(curWord, ratio);
            sum += Math.pow(curSize, k);
        }
        sum = Math.pow(sum, 1.0 / k);
        return sum;
    }

    @Override
    public int compareTo(SingleWordCluster o) {
        double compareCount;
        double thisCount = this.calculateWeightedSum();
        if (thisCount < (compareCount = o.calculateWeightedSum())) {
            return -1;
        }
        if (thisCount > compareCount) {
            return 1;
        }
        String thisWord = this.getWordList().get(0);
        String compareWord = this.getWordList().get(0);
        return thisWord.compareTo(compareWord);
    }

    public List<String> getWordList() {
        return this.wordList;
    }

    public int getTotalSum() {
        return this.totalSum;
    }

    public int getNumItems() {
        return this.numItems;
    }
}

