/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.wordcloud.internal.cluster;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.baderlab.wordcloud.internal.cluster.CloudInfo;
import org.baderlab.wordcloud.internal.cluster.CloudWordInfo;
import org.baderlab.wordcloud.internal.cluster.ClusterPriorityQueue;
import org.baderlab.wordcloud.internal.cluster.SingleWordCluster;
import org.baderlab.wordcloud.internal.cluster.WordClusters;
import org.baderlab.wordcloud.internal.cluster.WordPair;

public class ClusterBuilder {
    private final CloudInfo cloudInfo;
    private final ClusterPriorityQueue queue;
    private final WordClusters clusters;
    private List<CloudWordInfo> cloudWords;

    public ClusterBuilder(CloudInfo cloudInfo) {
        this.cloudInfo = cloudInfo;
        this.queue = new ClusterPriorityQueue(cloudInfo);
        this.clusters = new WordClusters(cloudInfo);
        this.cloudWords = new ArrayList<CloudWordInfo>();
    }

    public void clusterData(double cutoffVal) {
        boolean isDone = false;
        while (!isDone && !this.queue.isEmpty()) {
            WordPair curPair = this.queue.peak();
            if (curPair.getProbability() < cutoffVal) {
                isDone = true;
                continue;
            }
            curPair = this.queue.remove();
            this.clusters.combineClusters(curPair);
        }
        this.clusters.orderClusters();
    }

    private Color getClusterColor(int clusterNum) {
        switch (clusterNum % 7) {
            default: {
                return Color.BLACK;
            }
            case 1: {
                return new Color(204, 0, 0);
            }
            case 2: {
                return new Color(0, 110, 0);
            }
            case 3: {
                return new Color(255, 179, 0);
            }
            case 4: {
                return new Color(0, 0, 160);
            }
            case 5: {
                return new Color(130, 32, 130);
            }
            case 6: 
        }
        return Color.GRAY;
    }

    public void buildCloudWords() {
        this.cloudWords = new ArrayList<CloudWordInfo>();
        Integer wordCount = 0;
        Map<String, Double> ratios = this.cloudInfo.getRatios();
        for (int i = 0; i < this.clusters.getClusters().size(); ++i) {
            SingleWordCluster curCluster = this.clusters.getClusters().get(i);
            List<String> curList = curCluster.getWordList();
            Color clusterColor = this.getClusterColor(i);
            for (int j = 0; j < curList.size(); ++j) {
                String curWord = curList.get(j);
                Integer fontSize = this.cloudInfo.calculateFontSize(curWord, ratios.get(curWord));
                CloudWordInfo curInfo = new CloudWordInfo(this.cloudInfo, curWord, fontSize, clusterColor, i, wordCount);
                Integer n = wordCount;
                Integer n2 = wordCount = Integer.valueOf(wordCount + 1);
                this.cloudWords.add(curInfo);
            }
        }
    }

    public List<CloudWordInfo> getCloudWords() {
        return this.cloudWords;
    }

    public WordClusters getClusters() {
        return this.clusters;
    }

    public ClusterPriorityQueue getQueue() {
        return this.queue;
    }
}

