/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster;

import java.util.ArrayList;
import java.util.List;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.WordInfo;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class UpdateClusterLabelTask
extends AbstractTask {
    private Cluster cluster;
    private CyTable clusterSetTable;
    private TaskMonitor taskMonitor = null;

    public UpdateClusterLabelTask(Cluster cluster, CyTable clusterSetTable) {
        this.cluster = cluster;
        this.clusterSetTable = clusterSetTable;
    }

    public void updateClusterLabel() {
        AnnotationSet parent = this.cluster.getParent();
        CyNetwork network = (CyNetwork)parent.getView().getModel();
        String nameColumnName = parent.getNameColumnName();
        double sameClusterBonus = parent.getSameClusterBonus();
        double centralityBonus = parent.getCentralityBonus();
        String mostCentralNodeLabel = this.cluster.getMostCentralNodeLabel();
        if (this.cluster.getSize() == 1) {
            String oldLabel = this.cluster.getLabel();
            String newLabel = (String)network.getRow((CyIdentifiable)this.cluster.getNodesToCoordinates().keySet().iterator().next()).get(nameColumnName, String.class);
            if (!newLabel.equals(oldLabel)) {
                this.cluster.setLabel(newLabel);
            }
        } else {
            CyRow clusterRow = this.clusterSetTable.getRow((Object)this.cluster.getCloudName());
            List wordList = (List)clusterRow.get("WC_Word", List.class);
            List sizeList = (List)clusterRow.get("WC_FontSize", List.class);
            List clusterList = (List)clusterRow.get("WC_Cluster", List.class);
            List numberList = (List)clusterRow.get("WC_Number", List.class);
            ArrayList<WordInfo> wordInfos = new ArrayList<WordInfo>();
            if (wordList != null) {
                for (int i = 0; i < wordList.size(); ++i) {
                    wordInfos.add(new WordInfo((String)wordList.get(i), Integer.parseInt((String)sizeList.get(i)), Integer.parseInt((String)clusterList.get(i)), Integer.parseInt((String)numberList.get(i))));
                }
            }
            AnnotationSet annotationSet = this.cluster.getParent();
            if (wordInfos != null && wordInfos.size() != this.cluster.getWordInfos().size()) {
                this.cluster.setWordInfos(wordInfos);
                this.cluster.setLabel(this.cluster.makeLabel(wordInfos, mostCentralNodeLabel, sameClusterBonus, centralityBonus, annotationSet.getWordSizeThresholds(), annotationSet.getMaxWords()));
            } else {
                for (int infoIndex = 0; infoIndex < this.cluster.getWordInfos().size(); ++infoIndex) {
                    if (wordInfos.get(infoIndex).equals(this.cluster.getWordInfos().get(infoIndex))) continue;
                    this.cluster.setWordInfos(wordInfos);
                    this.cluster.setLabel(this.cluster.makeLabel(wordInfos, mostCentralNodeLabel, sameClusterBonus, centralityBonus, annotationSet.getWordSizeThresholds(), annotationSet.getMaxWords()));
                    if (this.cluster.getTextAnnotation() != null) {
                        this.cluster.getTextAnnotation().setText(this.cluster.getLabel());
                    }
                    return;
                }
            }
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setTitle("Updating cluster label");
        this.updateClusterLabel();
    }
}

