/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.model;

import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;

public class GSEAResult
extends EnrichmentResult {
    private int gsSize;
    private double ES;
    private double NES;
    private double fdrqvalue;
    private double fwerqvalue;
    private int rankAtMax;
    private double scoreAtMax;

    public GSEAResult(String name, int size, double ES, double NES, double pvalue, double fdrqvalue, double fwerqvalue, int rankAtMax, double scoreAtMax) {
        this.name = name;
        this.gsSize = size;
        this.ES = ES;
        this.NES = NES;
        this.pvalue = pvalue;
        this.fdrqvalue = fdrqvalue;
        this.fwerqvalue = fwerqvalue;
        this.rankAtMax = rankAtMax;
        this.scoreAtMax = scoreAtMax;
        this.setSource();
    }

    public GSEAResult(String[] tokens) {
        if (tokens.length != 8 && tokens.length != 10) {
            return;
        }
        this.name = tokens[1];
        this.gsSize = Integer.parseInt(tokens[2]);
        this.ES = Double.parseDouble(tokens[3]);
        this.NES = Double.parseDouble(tokens[4]);
        this.pvalue = Double.parseDouble(tokens[5]);
        this.fdrqvalue = Double.parseDouble(tokens[6]);
        this.fwerqvalue = Double.parseDouble(tokens[7]);
        if (tokens.length == 10) {
            this.rankAtMax = Integer.parseInt(tokens[8]);
            this.scoreAtMax = Double.parseDouble(tokens[9]);
        } else {
            this.rankAtMax = -1;
            this.scoreAtMax = -1.0;
        }
        this.setSource();
    }

    public boolean geneSetOfInterest(double pvalue, double fdrqvalue) {
        return this.pvalue <= pvalue && this.fdrqvalue <= fdrqvalue;
    }

    public int getGsSize() {
        return this.gsSize;
    }

    public void setGsSize(int gsSize) {
        this.gsSize = gsSize;
    }

    public double getES() {
        return this.ES;
    }

    public void setES(double ES) {
        this.ES = ES;
    }

    public double getNES() {
        return this.NES;
    }

    public void setNES(double NES) {
        this.NES = NES;
    }

    public double getFdrqvalue() {
        return this.fdrqvalue;
    }

    public void setFdrqvalue(double fdrqvalue) {
        this.fdrqvalue = fdrqvalue;
    }

    public double getFwerqvalue() {
        return this.fwerqvalue;
    }

    public void setFwerqvalue(double fwerqvalue) {
        this.fwerqvalue = fwerqvalue;
    }

    public int getRankAtMax() {
        return this.rankAtMax;
    }

    public void setRankAtMax(int rankAtMax) {
        this.rankAtMax = rankAtMax;
    }

    public double getScoreAtMax() {
        return this.scoreAtMax;
    }

    public void setScoreAtMax(double scoreAtMax) {
        this.scoreAtMax = scoreAtMax;
    }

    public String toString() {
        return this.name + "\t" + this.gsSize + "\t" + this.ES + "\t" + this.NES + "\t" + this.pvalue + "\t" + this.fdrqvalue + "\t" + this.fwerqvalue + "\t" + this.rankAtMax + "\t" + this.scoreAtMax;
    }
}

