/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.ClusterTableModel;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.Observer;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.UpdateAnnotationTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.DeleteClusterTask;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;

public class MergeClustersTask
extends AbstractTask {
    private AnnotationSet annotationSet;

    public MergeClustersTask(AnnotationSet annotationSet) {
        this.annotationSet = annotationSet;
    }

    public void mergeAction() {
        JTable clusterTable = this.annotationSet.getClusterTable();
        CyNetworkView selectedView = this.annotationSet.getView();
        CyNetwork selectedNetwork = (CyNetwork)selectedView.getModel();
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        int[] selectedRows = clusterTable.getSelectedRows();
        if (selectedRows.length < 2) {
            JOptionPane.showMessageDialog(null, "Please select at least two clusters", "Error Message", 0);
        } else {
            ArrayList<Cluster> selectedClusters = new ArrayList<Cluster>();
            block2: for (int rowIndex = 0; rowIndex < clusterTable.getRowCount(); ++rowIndex) {
                Cluster cluster = (Cluster)clusterTable.getModel().getValueAt(clusterTable.convertRowIndexToModel(rowIndex), 0);
                for (int selectedRow : selectedRows) {
                    if (rowIndex != selectedRow) continue;
                    selectedClusters.add(cluster);
                    continue block2;
                }
            }
            CommandExecutorTaskFactory executor = autoAnnotationManager.getCommandExecutor();
            SynchronousTaskManager<?> syncTaskManager = autoAnnotationManager.getSyncTaskManager();
            DialogTaskManager dialogTaskManager = autoAnnotationManager.getDialogTaskManager();
            Cluster firstCluster = (Cluster)selectedClusters.get(0);
            int clusterNumber = firstCluster.getClusterNumber();
            String clusterColumnName = this.annotationSet.getClusterColumnName();
            TaskIterator currentTasks = new TaskIterator(new Task[0]);
            for (Cluster clusterToSwallow : selectedClusters.subList(1, selectedClusters.size())) {
                for (CyNode node : clusterToSwallow.getNodes()) {
                    selectedNetwork.getRow((CyIdentifiable)node).set(clusterColumnName, (Object)clusterNumber);
                }
                firstCluster.swallow(clusterToSwallow);
                currentTasks.append((Task)new DeleteClusterTask(this.annotationSet, clusterToSwallow));
            }
            if (currentTasks.hasNext()) {
                AutoAnnotationManager.getInstance().getDialogTaskManager().execute(currentTasks);
            }
            for (CyNode node : selectedNetwork.getNodeList()) {
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)false);
            }
            for (CyNode node : firstCluster.getNodesToCoordinates().keySet()) {
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)true);
            }
            String nameColumnName = this.annotationSet.getNameColumnName();
            ArrayList<String> commands = new ArrayList<String>();
            String command_delete = "wordcloud delete cloudName=\"" + firstCluster.getCloudName() + "\"";
            commands.add(command_delete);
            String command = "wordcloud create wordColumnName=\"" + nameColumnName + "\"" + " nodeList=\"selected\" cloudName=\"" + firstCluster.getCloudName() + "\"" + " cloudGroupTableName=\"" + this.annotationSet.getName() + "\"";
            commands.add(command);
            Observer observer = new Observer();
            TaskIterator taskIterator = executor.createTaskIterator(commands, null);
            dialogTaskManager.execute(taskIterator, (TaskObserver)observer);
            while (!observer.isFinished()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            for (CyNode node : firstCluster.getNodesToCoordinates().keySet()) {
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)false);
            }
            ((ClusterTableModel)clusterTable.getModel()).removeClusterFromTable(firstCluster);
            ((ClusterTableModel)clusterTable.getModel()).addClusterToTable(firstCluster);
            firstCluster.setCoordinatesChanged(true);
            this.insertTasksAfterCurrentTask(new Task[]{new UpdateAnnotationTask(this.annotationSet)});
            clusterTable.clearSelection();
            CytoPanel westPanel = autoAnnotationManager.getWestPanel();
            westPanel.setSelectedIndex(westPanel.indexOfComponent((Component)autoAnnotationManager.getAnnotationPanel()));
        }
    }

    public void run(TaskMonitor arg0) throws Exception {
        this.mergeAction();
    }
}

